/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.Renderer;
import com.jme3.shader.BufferObjectField;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObject;
import com.jme3.util.SafeArrayList;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BufferObject
extends NativeObject {
    private static final Map<Class<?>, VarType> CLASS_TO_VAR_TYPE = new HashMap();
    private final Map<String, BufferObjectField> fields;
    private final SafeArrayList<BufferObjectField> fieldArray;
    private final Layout layout;
    private final int binding;
    private BufferType bufferType;
    private ByteBuffer previousData;

    protected static VarType getVarTypeByValue(Object value) {
        VarType varType = CLASS_TO_VAR_TYPE.get(value.getClass());
        if (varType != null) {
            return varType;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            throw new IllegalArgumentException("Can't calculate a var type for the empty collection value[" + value + "].");
        }
        if (value instanceof List) {
            return BufferObject.getVarTypeByValue(((List)value).get(0));
        }
        if (value instanceof Collection) {
            return BufferObject.getVarTypeByValue(((Collection)value).iterator().next());
        }
        throw new IllegalArgumentException("Can't calculate a var type for the value " + value);
    }

    public BufferObject(int binding, Layout layout, BufferType bufferType) {
        this.handleRef = new Object();
        this.bufferType = bufferType;
        this.binding = binding;
        this.layout = layout;
        this.fields = new HashMap<String, BufferObjectField>();
        this.fieldArray = new SafeArrayList<BufferObjectField>(BufferObjectField.class);
    }

    public BufferObject(int binding, Layout layout) {
        this(binding, layout, BufferType.UniformBufferObject);
    }

    public BufferObject(int binding, BufferType bufferType) {
        this(binding, Layout.std140, bufferType);
    }

    public BufferObject(BufferType bufferType) {
        this(1, Layout.std140, bufferType);
    }

    public BufferObject(Layout layout) {
        this(1, layout, BufferType.UniformBufferObject);
    }

    public BufferObject(int binding) {
        this(binding, Layout.std140, BufferType.UniformBufferObject);
    }

    public BufferObject() {
        this(1, Layout.std140, BufferType.UniformBufferObject);
    }

    private BufferObject(Void unused, int id) {
        super(id);
        this.fieldArray = null;
        this.fields = null;
        this.layout = null;
        this.binding = 0;
    }

    public void declareField(String name, VarType varType) {
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("The field " + name + " is already declared.");
        }
        BufferObjectField field = new BufferObjectField(name, varType);
        this.fields.put(name, field);
        this.fieldArray.add(field);
    }

    public BufferType getBufferType() {
        return this.bufferType;
    }

    public void setBufferType(BufferType bufferType) {
        if (this.getId() != -1) {
            throw new IllegalStateException("Can't change buffer's type when this buffer is already initialized.");
        }
        this.bufferType = bufferType;
    }

    public void setFieldValue(String name, Object value) {
        BufferObjectField field = this.fields.get(name);
        if (field == null) {
            this.declareField(name, BufferObject.getVarTypeByValue(value));
            field = this.fields.get(name);
        }
        field.setValue(value);
        this.setUpdateNeeded();
    }

    public <T> T getFieldValue(String name) {
        BufferObjectField field = this.fields.get(name);
        if (field == null) {
            throw new IllegalArgumentException("Unknown a field with the name " + name);
        }
        return (T)field.getValue();
    }

    public int getBinding() {
        return this.binding;
    }

    @Override
    public void resetObject() {
        this.id = -1;
        this.setUpdateNeeded();
    }

    public ByteBuffer computeData(int maxSize) {
        int estimateSize = 0;
        for (BufferObjectField field : this.fieldArray) {
            estimateSize += this.estimateSize(field);
        }
        if (maxSize < estimateSize) {
            throw new IllegalStateException("The estimated size(" + estimateSize + ") of this BO is bigger than maximum available size " + maxSize);
        }
        if (this.previousData != null) {
            if (this.previousData.capacity() < estimateSize) {
                BufferUtils.destroyDirectBuffer(this.previousData);
                this.previousData = null;
            } else {
                this.previousData.clear();
            }
        }
        ByteBuffer data = this.previousData == null ? BufferUtils.createByteBuffer(estimateSize) : this.previousData;
        for (BufferObjectField field : this.fieldArray) {
            this.writeField(field, data);
        }
        data.flip();
        this.previousData = data;
        return data;
    }

    protected int estimateSize(BufferObjectField field) {
        switch (field.getType()) {
            case Float: 
            case Int: {
                if (this.layout == Layout.std140) {
                    return 16;
                }
                return 4;
            }
            case Boolean: {
                if (this.layout == Layout.std140) {
                    return 16;
                }
                return 1;
            }
            case Vector2: {
                return 8;
            }
            case Vector3: {
                int multiplier = this.layout == Layout.std140 ? 4 : 3;
                return 4 * multiplier;
            }
            case Vector4: {
                return 16;
            }
            case IntArray: {
                return this.estimate((int[])field.getValue());
            }
            case FloatArray: {
                return this.estimate((float[])field.getValue());
            }
            case Vector2Array: {
                return this.estimateArray(field.getValue(), 8);
            }
            case Vector3Array: {
                int multiplier = this.layout == Layout.std140 ? 16 : 12;
                return this.estimateArray(field.getValue(), multiplier);
            }
            case Vector4Array: {
                return this.estimateArray(field.getValue(), 16);
            }
            case Matrix3: {
                int multiplier = this.layout == Layout.std140 ? 16 : 12;
                return 9 * multiplier;
            }
            case Matrix4: {
                return 64;
            }
            case Matrix3Array: {
                int multiplier = this.layout == Layout.std140 ? 16 : 12;
                multiplier = 9 * multiplier;
                return this.estimateArray(field.getValue(), multiplier);
            }
            case Matrix4Array: {
                int multiplier = 256;
                return this.estimateArray(field.getValue(), 256);
            }
        }
        throw new IllegalArgumentException("The type of BO field " + (Object)((Object)field.getType()) + " doesn't support.");
    }

    protected int estimateArray(Object value, int multiplier) {
        if (value instanceof Object[]) {
            return ((Object[])value).length * multiplier;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() * multiplier;
        }
        throw new IllegalArgumentException("Unexpected value " + value);
    }

    protected int estimate(float[] values) {
        return values.length * 4;
    }

    protected int estimate(int[] values) {
        return values.length * 4;
    }

    protected void writeField(BufferObjectField field, ByteBuffer data) {
        Object value = field.getValue();
        switch (field.getType()) {
            case Int: {
                data.putInt(((Number)value).intValue());
                if (this.layout != Layout.std140) break;
                data.putInt(0);
                data.putLong(0L);
                break;
            }
            case Float: {
                data.putFloat(((Number)value).floatValue());
                if (this.layout != Layout.std140) break;
                data.putInt(0);
                data.putLong(0L);
                break;
            }
            case Boolean: {
                data.put((byte)((Boolean)value != false ? 1 : 0));
                if (this.layout != Layout.std140) break;
                data.putInt(0);
                data.putLong(0L);
                data.putShort((short)0);
                data.put((byte)0);
                break;
            }
            case Vector2: {
                this.write(data, (Vector2f)value);
                break;
            }
            case Vector3: {
                this.write(data, (Vector3f)value);
                break;
            }
            case Vector4: {
                this.writeVec4(data, value);
                break;
            }
            case IntArray: {
                this.write(data, (int[])value);
                break;
            }
            case FloatArray: {
                this.write(data, (float[])value);
                break;
            }
            case Vector2Array: {
                this.writeVec2Array(data, value);
                break;
            }
            case Vector3Array: {
                this.writeVec3Array(data, value);
                break;
            }
            case Vector4Array: {
                this.writeVec4Array(data, value);
                break;
            }
            case Matrix3: {
                this.write(data, (Matrix3f)value);
                break;
            }
            case Matrix4: {
                this.write(data, (Matrix4f)value);
                break;
            }
            case Matrix3Array: {
                this.writeMat3Array(data, value);
                break;
            }
            case Matrix4Array: {
                this.writeMat4Array(data, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of BO field " + (Object)((Object)field.getType()) + " doesn't support.");
            }
        }
    }

    protected void writeMat3Array(ByteBuffer data, Object value) {
        block4: {
            block5: {
                block3: {
                    Matrix3f[] values;
                    if (!(value instanceof Matrix3f[])) break block3;
                    for (Matrix3f mat : values = (Matrix3f[])value) {
                        this.write(data, mat);
                    }
                    break block4;
                }
                if (!(value instanceof SafeArrayList)) break block5;
                SafeArrayList values = (SafeArrayList)value;
                for (Matrix3f mat : (Matrix3f[])values.getArray()) {
                    this.write(data, mat);
                }
                break block4;
            }
            if (!(value instanceof Collection)) break block4;
            Collection values = (Collection)value;
            for (Matrix3f mat : values) {
                this.write(data, mat);
            }
        }
    }

    protected void writeMat4Array(ByteBuffer data, Object value) {
        block4: {
            block5: {
                block3: {
                    Matrix4f[] values;
                    if (!(value instanceof Matrix4f[])) break block3;
                    for (Matrix4f mat : values = (Matrix4f[])value) {
                        this.write(data, mat);
                    }
                    break block4;
                }
                if (!(value instanceof SafeArrayList)) break block5;
                SafeArrayList values = (SafeArrayList)value;
                for (Matrix4f mat : (Matrix4f[])values.getArray()) {
                    this.write(data, mat);
                }
                break block4;
            }
            if (!(value instanceof Collection)) break block4;
            Collection values = (Collection)value;
            for (Matrix4f mat : values) {
                this.write(data, mat);
            }
        }
    }

    protected void writeVec4Array(ByteBuffer data, Object value) {
        block4: {
            block5: {
                block3: {
                    Object[] values;
                    if (!(value instanceof Object[])) break block3;
                    for (Object vec : values = (Object[])value) {
                        this.writeVec4(data, vec);
                    }
                    break block4;
                }
                if (!(value instanceof SafeArrayList)) break block5;
                SafeArrayList values = (SafeArrayList)value;
                for (Object vec : values.getArray()) {
                    this.writeVec4(data, vec);
                }
                break block4;
            }
            if (!(value instanceof Collection)) break block4;
            Collection values = (Collection)value;
            for (Object vec : values) {
                this.writeVec4(data, vec);
            }
        }
    }

    protected void writeVec3Array(ByteBuffer data, Object value) {
        block4: {
            block5: {
                block3: {
                    Vector3f[] values;
                    if (!(value instanceof Vector3f[])) break block3;
                    for (Vector3f vec : values = (Vector3f[])value) {
                        this.write(data, vec);
                    }
                    break block4;
                }
                if (!(value instanceof SafeArrayList)) break block5;
                SafeArrayList values = (SafeArrayList)value;
                for (Vector3f vec : (Vector3f[])values.getArray()) {
                    this.write(data, vec);
                }
                break block4;
            }
            if (!(value instanceof Collection)) break block4;
            Collection values = (Collection)value;
            for (Vector3f vec : values) {
                this.write(data, vec);
            }
        }
    }

    protected void writeVec2Array(ByteBuffer data, Object value) {
        block4: {
            block5: {
                block3: {
                    Vector2f[] values;
                    if (!(value instanceof Vector2f[])) break block3;
                    for (Vector2f vec : values = (Vector2f[])value) {
                        this.write(data, vec);
                    }
                    break block4;
                }
                if (!(value instanceof SafeArrayList)) break block5;
                SafeArrayList values = (SafeArrayList)value;
                for (Vector2f vec : (Vector2f[])values.getArray()) {
                    this.write(data, vec);
                }
                break block4;
            }
            if (!(value instanceof Collection)) break block4;
            Collection values = (Collection)value;
            for (Vector2f vec : values) {
                this.write(data, vec);
            }
        }
    }

    protected void write(ByteBuffer data, float[] value) {
        for (float val : value) {
            data.putFloat(val);
        }
    }

    protected void write(ByteBuffer data, int[] value) {
        for (int val : value) {
            data.putInt(val);
        }
    }

    protected void writeVec4(ByteBuffer data, Object value) {
        if (value == null) {
            data.putLong(0L).putLong(0L);
        } else if (value instanceof Vector4f) {
            Vector4f vec4 = (Vector4f)value;
            data.putFloat(vec4.getX()).putFloat(vec4.getY()).putFloat(vec4.getZ()).putFloat(vec4.getW());
        } else if (value instanceof Quaternion) {
            Quaternion vec4 = (Quaternion)value;
            data.putFloat(vec4.getX()).putFloat(vec4.getY()).putFloat(vec4.getZ()).putFloat(vec4.getW());
        } else if (value instanceof ColorRGBA) {
            ColorRGBA vec4 = (ColorRGBA)value;
            data.putFloat(vec4.getRed()).putFloat(vec4.getGreen()).putFloat(vec4.getBlue()).putFloat(vec4.getAlpha());
        }
    }

    protected void write(ByteBuffer data, Vector3f value) {
        if (value == null) {
            data.putLong(0L).putInt(0);
        } else {
            data.putFloat(value.getX()).putFloat(value.getY()).putFloat(value.getZ());
        }
        if (this.layout == Layout.std140) {
            data.putInt(0);
        }
    }

    protected void write(ByteBuffer data, float x, float y, float z) {
        data.putFloat(x).putFloat(y).putFloat(z);
        if (this.layout == Layout.std140) {
            data.putInt(0);
        }
    }

    protected void write(ByteBuffer data, float x, float y, float z, float w) {
        data.putFloat(x).putFloat(y).putFloat(z).putFloat(w);
    }

    protected void write(ByteBuffer data, Vector2f value) {
        if (value == null) {
            data.putLong(0L);
        } else {
            data.putFloat(value.getX()).putFloat(value.getY());
        }
    }

    protected void write(ByteBuffer data, Matrix3f value) {
        this.write(data, value.get(0, 0), value.get(1, 0), value.get(2, 0));
        this.write(data, value.get(0, 1), value.get(1, 1), value.get(2, 1));
        this.write(data, value.get(0, 2), value.get(1, 2), value.get(2, 2));
    }

    protected void write(ByteBuffer data, Matrix4f value) {
        this.write(data, value.get(0, 0), value.get(1, 0), value.get(2, 0), value.get(3, 0));
        this.write(data, value.get(0, 1), value.get(1, 1), value.get(2, 1), value.get(3, 1));
        this.write(data, value.get(0, 2), value.get(1, 2), value.get(2, 2), value.get(3, 2));
        this.write(data, value.get(0, 3), value.get(1, 3), value.get(2, 3), value.get(3, 3));
    }

    @Override
    public void deleteObject(Object rendererObject) {
        if (!(rendererObject instanceof Renderer)) {
            throw new IllegalArgumentException("This bo can't be deleted from " + rendererObject);
        }
        ((Renderer)rendererObject).deleteBuffer(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new BufferObject(null, this.getId());
    }

    @Override
    protected void deleteNativeBuffers() {
        super.deleteNativeBuffers();
        if (this.previousData != null) {
            BufferUtils.destroyDirectBuffer(this.previousData);
            this.previousData = null;
        }
    }

    @Override
    public long getUniqueId() {
        return 0x900000000L | (long)this.id;
    }

    static {
        CLASS_TO_VAR_TYPE.put(Float.class, VarType.Float);
        CLASS_TO_VAR_TYPE.put(Integer.class, VarType.Int);
        CLASS_TO_VAR_TYPE.put(Boolean.class, VarType.Boolean);
        CLASS_TO_VAR_TYPE.put(Vector2f.class, VarType.Vector2);
        CLASS_TO_VAR_TYPE.put(Vector3f.class, VarType.Vector3);
        CLASS_TO_VAR_TYPE.put(ColorRGBA.class, VarType.Vector4);
        CLASS_TO_VAR_TYPE.put(Quaternion.class, VarType.Vector4);
        CLASS_TO_VAR_TYPE.put(Vector4f.class, VarType.Vector4);
        CLASS_TO_VAR_TYPE.put(Vector2f[].class, VarType.Vector2Array);
        CLASS_TO_VAR_TYPE.put(Vector3f[].class, VarType.Vector3Array);
        CLASS_TO_VAR_TYPE.put(Vector4f[].class, VarType.Vector4Array);
        CLASS_TO_VAR_TYPE.put(ColorRGBA[].class, VarType.Vector4Array);
        CLASS_TO_VAR_TYPE.put(Quaternion[].class, VarType.Vector4Array);
        CLASS_TO_VAR_TYPE.put(Matrix3f.class, VarType.Matrix3);
        CLASS_TO_VAR_TYPE.put(Matrix4f.class, VarType.Matrix4);
        CLASS_TO_VAR_TYPE.put(Matrix3f[].class, VarType.Matrix3Array);
        CLASS_TO_VAR_TYPE.put(Matrix4f[].class, VarType.Matrix4Array);
    }

    public static enum BufferType {
        ShaderStorageBufferObject(Caps.ShaderStorageBufferObject),
        UniformBufferObject(Caps.UniformBufferObject);

        private final Caps requiredCaps;

        private BufferType(Caps requiredCaps) {
            this.requiredCaps = requiredCaps;
        }

        public Caps getRequiredCaps() {
            return this.requiredCaps;
        }
    }

    public static enum Layout {
        std140,
        std430;

    }
}

