/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.instancing;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.GeometryGroupNode;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.instancing.InstancedGeometry;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InstancedNode
extends GeometryGroupNode {
    private InstancedNodeControl control;
    protected HashMap<Geometry, InstancedGeometry> igByGeom = new HashMap();
    private InstanceTypeKey lookUp = new InstanceTypeKey();
    private HashMap<InstanceTypeKey, InstancedGeometry> instancesMap = new HashMap();

    static int getGeometryStartIndex2(Geometry geom) {
        return InstancedNode.getGeometryStartIndex(geom);
    }

    static void setGeometryStartIndex2(Geometry geom, int startIndex) {
        InstancedNode.setGeometryStartIndex(geom, startIndex);
    }

    protected InstancedNode() {
    }

    public InstancedNode(String name) {
        super(name);
        this.control = new InstancedNodeControl(this);
        this.addControl(this.control);
    }

    private void renderFromControl() {
        for (InstancedGeometry ig : this.instancesMap.values()) {
            ig.updateInstances();
        }
    }

    private InstancedGeometry lookUpByGeometry(Geometry geom) {
        this.lookUp.mesh = geom.getMesh();
        this.lookUp.material = geom.getMaterial();
        this.lookUp.lodLevel = geom.getLodLevel();
        InstancedGeometry ig = this.instancesMap.get(this.lookUp);
        if (ig == null) {
            ig = new InstancedGeometry("mesh-" + System.identityHashCode(this.lookUp.mesh) + ",material-" + this.lookUp.material.getMaterialDef().getName() + ",lod-" + this.lookUp.lodLevel);
            ig.setMaterial(this.lookUp.material);
            ig.setMesh(this.lookUp.mesh);
            if (this.lookUp.lodLevel > 0) {
                ig.setLodLevel(this.lookUp.lodLevel);
            }
            ig.setUserData("JmePhysicsIgnore", true);
            ig.setCullHint(Spatial.CullHint.Never);
            ig.setShadowMode(RenderQueue.ShadowMode.Inherit);
            this.instancesMap.put(this.lookUp.clone(), ig);
            this.attachChild(ig);
        }
        return ig;
    }

    private void addToInstancedGeometry(Geometry geom) {
        Material material = geom.getMaterial();
        MatParam param = material.getParam("UseInstancing");
        if (param == null || !((Boolean)param.getValue()).booleanValue()) {
            throw new IllegalStateException("You must set the 'UseInstancing' parameter to true on the material prior to adding it to InstancedNode");
        }
        InstancedGeometry ig = this.lookUpByGeometry(geom);
        this.igByGeom.put(geom, ig);
        geom.associateWithGroupNode(this, 0);
        ig.addInstance(geom);
    }

    private void removeFromInstancedGeometry(Geometry geom) {
        InstancedGeometry ig = this.igByGeom.remove(geom);
        if (ig != null) {
            ig.deleteInstance(geom);
            if (ig.isEmpty()) {
                this.detachChild(ig);
            }
        }
    }

    private void relocateInInstancedGeometry(Geometry geom) {
        InstancedGeometry newIG;
        InstancedGeometry oldIG = this.igByGeom.get(geom);
        if (oldIG != (newIG = this.lookUpByGeometry(geom))) {
            if (oldIG == null) {
                throw new AssertionError();
            }
            oldIG.deleteInstance(geom);
            if (oldIG.isEmpty()) {
                this.detachChild(oldIG);
            }
            newIG.addInstance(geom);
            this.igByGeom.put(geom, newIG);
        }
    }

    private void ungroupSceneGraph(Spatial s) {
        Geometry g;
        if (s instanceof Node) {
            for (Spatial sp : ((Node)s).getChildren()) {
                this.ungroupSceneGraph(sp);
            }
        } else if (s instanceof Geometry && (g = (Geometry)s).isGrouped()) {
            g.unassociateFromGroupNode();
            if (InstancedNode.getGeometryStartIndex(g) != -1) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public Spatial detachChildAt(int index) {
        Spatial s = super.detachChildAt(index);
        if (s instanceof Node) {
            this.ungroupSceneGraph(s);
        } else if (s instanceof InstancedGeometry) {
            InstancedGeometry ig = (InstancedGeometry)s;
            this.lookUp.mesh = ig.getMesh();
            this.lookUp.material = ig.getMaterial();
            this.lookUp.lodLevel = ig.getLodLevel();
            this.instancesMap.remove(this.lookUp, ig);
            ig.cleanup();
        }
        return s;
    }

    private void instance(Spatial n) {
        if (n instanceof Geometry) {
            Geometry g = (Geometry)n;
            if (!g.isGrouped() && g.getBatchHint() != Spatial.BatchHint.Never) {
                this.addToInstancedGeometry(g);
            }
        } else if (n instanceof Node) {
            for (Spatial child : ((Node)n).getChildren()) {
                if (child instanceof GeometryGroupNode) continue;
                this.instance(child);
            }
        }
    }

    public void instance() {
        this.instance(this);
    }

    @Override
    public Node clone() {
        return this.clone(true);
    }

    @Override
    public Node clone(boolean cloneMaterials) {
        InstancedNode clone = (InstancedNode)super.clone(cloneMaterials);
        if (this.instancesMap.size() > 0) {
            for (int i = 0; i < clone.children.size(); ++i) {
                Geometry geom;
                if (clone.children.get(i) instanceof InstancedGeometry) {
                    clone.children.remove(i);
                    continue;
                }
                if (clone.children.get(i) instanceof Geometry && (geom = (Geometry)clone.children.get(i)).isGrouped()) {
                    throw new AssertionError();
                }
            }
        }
        clone.controls.remove(this.control);
        clone.control = new InstancedNodeControl(clone);
        clone.controls.add(clone.control);
        clone.lookUp = new InstanceTypeKey();
        clone.igByGeom = new HashMap();
        clone.instancesMap = new HashMap();
        clone.instance();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.control = cloner.clone(this.control);
        this.lookUp = cloner.clone(this.lookUp);
        HashMap<Geometry, InstancedGeometry> newIgByGeom = new HashMap<Geometry, InstancedGeometry>();
        for (Map.Entry<Geometry, InstancedGeometry> e : this.igByGeom.entrySet()) {
            newIgByGeom.put(cloner.clone(e.getKey()), cloner.clone(e.getValue()));
        }
        this.igByGeom = newIgByGeom;
        HashMap<InstanceTypeKey, InstancedGeometry> newInstancesMap = new HashMap<InstanceTypeKey, InstancedGeometry>();
        for (Map.Entry<InstanceTypeKey, InstancedGeometry> e : this.instancesMap.entrySet()) {
            newInstancesMap.put(cloner.clone(e.getKey()), cloner.clone(e.getValue()));
        }
        this.instancesMap = newInstancesMap;
    }

    @Override
    public void onTransformChange(Geometry geom) {
    }

    @Override
    public void onMaterialChange(Geometry geom) {
        this.relocateInInstancedGeometry(geom);
    }

    @Override
    public void onMeshChange(Geometry geom) {
        this.relocateInInstancedGeometry(geom);
    }

    @Override
    public void onGeometryUnassociated(Geometry geom) {
        this.removeFromInstancedGeometry(geom);
    }

    private static class InstancedNodeControl
    implements Control,
    JmeCloneable {
        private InstancedNode node;

        public InstancedNodeControl() {
        }

        public InstancedNodeControl(InstancedNode node) {
            this.node = node;
        }

        @Override
        @Deprecated
        public Control cloneForSpatial(Spatial spatial) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object jmeClone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Error cloning control", e);
            }
        }

        @Override
        public void cloneFields(Cloner cloner, Object original) {
            this.node = cloner.clone(this.node);
        }

        @Override
        public void setSpatial(Spatial spatial) {
        }

        @Override
        public void update(float tpf) {
        }

        @Override
        public void render(RenderManager rm, ViewPort vp) {
            this.node.renderFromControl();
        }

        @Override
        public void write(JmeExporter ex) throws IOException {
        }

        @Override
        public void read(JmeImporter im) throws IOException {
        }
    }

    private static final class InstanceTypeKey
    implements Cloneable,
    JmeCloneable {
        Mesh mesh;
        Material material;
        int lodLevel;

        public InstanceTypeKey(Mesh mesh, Material material, int lodLevel) {
            this.mesh = mesh;
            this.material = material;
            this.lodLevel = lodLevel;
        }

        public InstanceTypeKey() {
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + this.mesh.hashCode();
            hash = 41 * hash + this.material.hashCode();
            hash = 41 * hash + this.lodLevel;
            return hash;
        }

        public boolean equals(Object obj) {
            InstanceTypeKey other = (InstanceTypeKey)obj;
            if (this.mesh != other.mesh) {
                return false;
            }
            if (this.material != other.material) {
                return false;
            }
            return this.lodLevel == other.lodLevel;
        }

        public InstanceTypeKey clone() {
            try {
                return (InstanceTypeKey)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError();
            }
        }

        @Override
        public Object jmeClone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        @Override
        public void cloneFields(Cloner cloner, Object original) {
            this.mesh = cloner.clone(this.mesh);
            this.material = cloner.clone(this.material);
        }
    }
}

