/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.shader.Shader;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.util.Collection;

public enum Caps {
    FrameBuffer,
    FrameBufferMRT,
    FrameBufferMultisample,
    TextureMultisample,
    OpenGL20,
    OpenGL21,
    OpenGL30,
    OpenGL31,
    OpenGL32,
    OpenGL33,
    OpenGL40,
    OpenGL41,
    OpenGL42,
    OpenGL43,
    OpenGL44,
    OpenGL45,
    Reserved0,
    GLSL100,
    GLSL110,
    GLSL120,
    GLSL130,
    GLSL140,
    GLSL150,
    GLSL330,
    GLSL400,
    GLSL410,
    GLSL420,
    GLSL430,
    GLSL440,
    GLSL450,
    VertexTextureFetch,
    GeometryShader,
    TesselationShader,
    TextureArray,
    TextureBuffer,
    FloatTexture,
    IntegerTexture,
    FloatColorBuffer,
    FloatDepthBuffer,
    PackedFloatTexture,
    SharedExponentTexture,
    PackedFloatColorBuffer,
    SharedExponentColorBuffer,
    Reserved1,
    NonPowerOfTwoTextures,
    MeshInstancing,
    VertexBufferArray,
    Multisample,
    PackedDepthStencilBuffer,
    Srgb,
    FrameBufferBlit,
    TextureCompressionS3TC,
    TextureFilterAnisotropic,
    TextureCompressionETC1,
    TextureCompressionETC2,
    OpenGLES20,
    Rgba8,
    DepthTexture,
    IntegerIndexBuffer,
    PartialNonPowerOfTwoTextures,
    SeamlessCubemap,
    CoreProfile,
    BinaryShader,
    UniformBufferObject,
    ShaderStorageBufferObject,
    OpenGLES30,
    GLSL300,
    OpenGLES31,
    GLSL310,
    OpenGLES32,
    GLSL320,
    Depth24,
    UnpackRowLength;


    public static boolean supports(Collection<Caps> caps, Texture tex) {
        if (tex.getType() == Texture.Type.TwoDimensionalArray && !caps.contains((Object)TextureArray)) {
            return false;
        }
        Image img = tex.getImage();
        if (img == null) {
            return true;
        }
        Image.Format fmt = img.getFormat();
        switch (fmt) {
            case Depth24Stencil8: {
                return caps.contains((Object)PackedDepthStencilBuffer);
            }
            case Depth32F: {
                return caps.contains((Object)FloatDepthBuffer);
            }
            case RGB16F_to_RGB111110F: 
            case RGB111110F: {
                return caps.contains((Object)PackedFloatTexture);
            }
            case RGB16F_to_RGB9E5: 
            case RGB9E5: {
                return caps.contains((Object)SharedExponentTexture);
            }
        }
        if (fmt.isFloatingPont()) {
            return caps.contains((Object)FloatTexture);
        }
        return true;
    }

    private static boolean supportsColorBuffer(Collection<Caps> caps, FrameBuffer.RenderBuffer colorBuf) {
        Image.Format colorFmt = colorBuf.getFormat();
        if (colorFmt.isDepthFormat()) {
            return false;
        }
        if (colorFmt.isCompressed()) {
            return false;
        }
        switch (colorFmt) {
            case RGB111110F: {
                return caps.contains((Object)PackedFloatColorBuffer);
            }
            case RGB16F_to_RGB111110F: 
            case RGB16F_to_RGB9E5: 
            case RGB9E5: {
                return false;
            }
        }
        if (colorFmt.isFloatingPont()) {
            return caps.contains((Object)FloatColorBuffer);
        }
        return true;
    }

    public static boolean supports(Collection<Caps> caps, FrameBuffer fb) {
        if (!caps.contains((Object)FrameBuffer)) {
            return false;
        }
        if (fb.getSamples() > 1 && !caps.contains((Object)FrameBufferMultisample)) {
            return false;
        }
        FrameBuffer.RenderBuffer depthBuf = fb.getDepthBuffer();
        if (depthBuf != null) {
            Image.Format depthFmt = depthBuf.getFormat();
            if (!depthFmt.isDepthFormat()) {
                return false;
            }
            if (depthFmt == Image.Format.Depth32F && !caps.contains((Object)FloatDepthBuffer)) {
                return false;
            }
            if (depthFmt == Image.Format.Depth24Stencil8 && !caps.contains((Object)PackedDepthStencilBuffer)) {
                return false;
            }
        }
        for (int i = 0; i < fb.getNumColorBuffers(); ++i) {
            if (Caps.supportsColorBuffer(caps, fb.getColorBuffer(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean supports(Collection<Caps> caps, Shader shader) {
        for (Shader.ShaderSource source : shader.getSources()) {
            if (!source.getLanguage().startsWith("GLSL")) continue;
            int ver = Integer.parseInt(source.getLanguage().substring(4));
            switch (ver) {
                case 100: {
                    if (!caps.contains((Object)GLSL100)) {
                        return false;
                    }
                }
                case 110: {
                    if (!caps.contains((Object)GLSL110)) {
                        return false;
                    }
                }
                case 120: {
                    if (!caps.contains((Object)GLSL120)) {
                        return false;
                    }
                }
                case 130: {
                    if (!caps.contains((Object)GLSL130)) {
                        return false;
                    }
                }
                case 140: {
                    if (!caps.contains((Object)GLSL140)) {
                        return false;
                    }
                }
                case 150: {
                    if (!caps.contains((Object)GLSL150)) {
                        return false;
                    }
                }
                case 330: {
                    if (!caps.contains((Object)GLSL330)) {
                        return false;
                    }
                }
                case 400: {
                    if (!caps.contains((Object)GLSL400)) {
                        return false;
                    }
                }
                case 410: {
                    if (!caps.contains((Object)GLSL410)) {
                        return false;
                    }
                }
                case 420: {
                    if (!caps.contains((Object)GLSL420)) {
                        return false;
                    }
                }
                case 430: {
                    if (!caps.contains((Object)GLSL430)) {
                        return false;
                    }
                }
                case 440: {
                    if (!caps.contains((Object)GLSL440)) {
                        return false;
                    }
                }
                case 450: {
                    if (caps.contains((Object)GLSL450)) break;
                    return false;
                }
            }
            return false;
        }
        return true;
    }
}

