/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.profile.SpStep;
import com.jme3.renderer.Camera;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import com.jme3.util.SafeArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class FilterPostProcessor
implements SceneProcessor,
Savable {
    public static final String FPP = FilterPostProcessor.class.getSimpleName();
    private RenderManager renderManager;
    private Renderer renderer;
    private ViewPort viewPort;
    private FrameBuffer renderFrameBufferMS;
    private int numSamples = 1;
    private FrameBuffer renderFrameBuffer;
    private Texture2D filterTexture;
    private Texture2D depthTexture;
    private SafeArrayList<Filter> filters = new SafeArrayList<Filter>(Filter.class);
    private AssetManager assetManager;
    private Picture fsQuad;
    private boolean computeDepth = false;
    private FrameBuffer outputBuffer;
    private int width;
    private int height;
    private float bottom;
    private float left;
    private float right;
    private float top;
    private int originalWidth;
    private int originalHeight;
    private int lastFilterIndex = -1;
    private boolean cameraInit = false;
    private boolean multiView = false;
    private AppProfiler prof;
    private Image.Format fbFormat = Image.Format.RGB111110F;
    private final Image.Format depthFormat = Image.Format.Depth;

    public FilterPostProcessor(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    protected FilterPostProcessor() {
    }

    public void addFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null.");
        }
        this.filters.add(filter);
        if (this.isInitialized()) {
            this.initFilter(filter, this.viewPort);
        }
        this.setFilterState(filter, filter.isEnabled());
    }

    public void removeFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null.");
        }
        this.filters.remove(filter);
        filter.cleanup(this.renderer);
        this.updateLastFilterIndex();
    }

    public Iterator<Filter> getFilterIterator() {
        return this.filters.iterator();
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.renderer = rm.getRenderer();
        this.viewPort = vp;
        this.fsQuad = new Picture("filter full screen quad");
        this.fsQuad.setWidth(1.0f);
        this.fsQuad.setHeight(1.0f);
        if (!this.renderer.getCaps().contains((Object)Caps.PackedFloatTexture)) {
            this.fbFormat = !this.renderer.getCaps().contains((Object)Caps.FloatTexture) ? Image.Format.RGB8 : Image.Format.RGB16F;
        }
        Camera cam = vp.getCamera();
        this.left = cam.getViewPortLeft();
        this.right = cam.getViewPortRight();
        this.top = cam.getViewPortTop();
        this.bottom = cam.getViewPortBottom();
        this.originalWidth = cam.getWidth();
        this.originalHeight = cam.getHeight();
        this.reshape(vp, cam.getWidth(), cam.getHeight());
    }

    public Image.Format getDefaultPassTextureFormat() {
        return this.fbFormat;
    }

    private void initFilter(Filter filter, ViewPort vp) {
        filter.setProcessor(this);
        if (filter.isRequiresDepthTexture()) {
            if (!this.computeDepth && this.renderFrameBuffer != null) {
                this.depthTexture = new Texture2D(this.width, this.height, this.depthFormat);
                this.renderFrameBuffer.setDepthTexture(this.depthTexture);
            }
            this.computeDepth = true;
            filter.init(this.assetManager, this.renderManager, vp, this.width, this.height);
            filter.setDepthTexture(this.depthTexture);
        } else {
            filter.init(this.assetManager, this.renderManager, vp, this.width, this.height);
        }
    }

    private void renderProcessing(Renderer r, FrameBuffer buff, Material mat) {
        if (buff == this.outputBuffer) {
            this.viewPort.getCamera().resize(this.originalWidth, this.originalHeight, false);
            this.viewPort.getCamera().setViewPort(this.left, this.right, this.bottom, this.top);
            this.renderManager.setCamera(this.viewPort.getCamera(), false);
            if (mat.getAdditionalRenderState().isDepthWrite()) {
                mat.getAdditionalRenderState().setDepthTest(false);
                mat.getAdditionalRenderState().setDepthWrite(false);
            }
        } else {
            this.viewPort.getCamera().resize(buff.getWidth(), buff.getHeight(), false);
            this.viewPort.getCamera().setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
            this.renderManager.setCamera(this.viewPort.getCamera(), false);
            mat.getAdditionalRenderState().setDepthTest(true);
            mat.getAdditionalRenderState().setDepthWrite(true);
        }
        this.fsQuad.setMaterial(mat);
        this.fsQuad.updateGeometricState();
        r.setFrameBuffer(buff);
        r.clearBuffers(true, true, true);
        this.renderManager.renderGeometry(this.fsQuad);
    }

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    @Override
    public void postQueue(RenderQueue rq) {
        for (Filter filter : this.filters.getArray()) {
            if (!filter.isEnabled()) continue;
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPostQueue, FPP, filter.getName());
            }
            filter.postQueue(rq);
        }
    }

    private void renderFilterChain(Renderer r, FrameBuffer sceneFb) {
        Texture2D tex = this.filterTexture;
        FrameBuffer buff = sceneFb;
        boolean msDepth = this.depthTexture != null && this.depthTexture.getImage().getMultiSamples() > 1;
        for (int i = 0; i < this.filters.size(); ++i) {
            boolean wantsBilinear;
            Filter filter = this.filters.get(i);
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPostFrame, FPP, filter.getName());
            }
            if (!filter.isEnabled()) continue;
            if (filter.getPostRenderPasses() != null) {
                for (Filter.Pass pass : filter.getPostRenderPasses()) {
                    if (this.prof != null) {
                        this.prof.spStep(SpStep.ProcPostFrame, FPP, filter.getName(), pass.toString());
                    }
                    pass.beforeRender();
                    if (pass.requiresSceneAsTexture()) {
                        pass.getPassMaterial().setTexture("Texture", tex);
                        if (tex.getImage().getMultiSamples() > 1) {
                            pass.getPassMaterial().setInt("NumSamples", tex.getImage().getMultiSamples());
                        } else {
                            pass.getPassMaterial().clearParam("NumSamples");
                        }
                    }
                    if (pass.requiresDepthAsTexture()) {
                        pass.getPassMaterial().setTexture("DepthTexture", this.depthTexture);
                        if (msDepth) {
                            pass.getPassMaterial().setInt("NumSamplesDepth", this.depthTexture.getImage().getMultiSamples());
                        } else {
                            pass.getPassMaterial().clearParam("NumSamplesDepth");
                        }
                    }
                    this.renderProcessing(r, pass.getRenderFrameBuffer(), pass.getPassMaterial());
                }
            }
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPostFrame, FPP, filter.getName(), "postFrame");
            }
            filter.postFrame(this.renderManager, this.viewPort, buff, sceneFb);
            Material mat = filter.getMaterial();
            if (msDepth && filter.isRequiresDepthTexture()) {
                mat.setInt("NumSamplesDepth", this.depthTexture.getImage().getMultiSamples());
            }
            if (filter.isRequiresSceneTexture()) {
                mat.setTexture("Texture", tex);
                if (tex.getImage().getMultiSamples() > 1) {
                    mat.setInt("NumSamples", tex.getImage().getMultiSamples());
                } else {
                    mat.clearParam("NumSamples");
                }
            }
            if (wantsBilinear = filter.isRequiresBilinear()) {
                tex.setMagFilter(Texture.MagFilter.Bilinear);
                tex.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
            }
            buff = this.outputBuffer;
            if (i != this.lastFilterIndex) {
                buff = filter.getRenderFrameBuffer();
                tex = filter.getRenderedTexture();
            }
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPostFrame, FPP, filter.getName(), "render");
            }
            this.renderProcessing(r, buff, mat);
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPostFrame, FPP, filter.getName(), "postFilter");
            }
            filter.postFilter(r, buff);
            if (!wantsBilinear) continue;
            tex.setMagFilter(Texture.MagFilter.Nearest);
            tex.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
    }

    @Override
    public void postFrame(FrameBuffer out) {
        FrameBuffer sceneBuffer = this.renderFrameBuffer;
        if (this.renderFrameBufferMS != null && !this.renderer.getCaps().contains((Object)Caps.OpenGL32)) {
            this.renderer.copyFrameBuffer(this.renderFrameBufferMS, this.renderFrameBuffer, true, true);
        } else if (this.renderFrameBufferMS != null) {
            sceneBuffer = this.renderFrameBufferMS;
        }
        this.renderFilterChain(this.renderer, sceneBuffer);
        this.renderer.setFrameBuffer(this.outputBuffer);
        if (this.viewPort != null) {
            this.renderManager.setCamera(this.viewPort.getCamera(), false);
        }
    }

    @Override
    public void preFrame(float tpf) {
        if (this.filters.isEmpty() || this.lastFilterIndex == -1) {
            if (this.cameraInit) {
                this.viewPort.getCamera().resize(this.originalWidth, this.originalHeight, true);
                this.viewPort.getCamera().setViewPort(this.left, this.right, this.bottom, this.top);
                this.viewPort.setOutputFrameBuffer(this.outputBuffer);
                this.cameraInit = false;
            }
        } else {
            this.setupViewPortFrameBuffer();
            if (this.multiView) {
                this.viewPort.getCamera().resize(this.width, this.height, false);
                this.viewPort.getCamera().setViewPort(0.0f, 1.0f, 0.0f, 1.0f);
                this.viewPort.getCamera().update();
                this.renderManager.setCamera(this.viewPort.getCamera(), false);
            }
        }
        for (Filter filter : this.filters.getArray()) {
            if (!filter.isEnabled()) continue;
            if (this.prof != null) {
                this.prof.spStep(SpStep.ProcPreFrame, FPP, filter.getName());
            }
            filter.preFrame(tpf);
        }
    }

    protected void setFilterState(Filter filter, boolean enabled) {
        if (this.filters.contains(filter)) {
            filter.enabled = enabled;
            this.updateLastFilterIndex();
        }
    }

    private void updateLastFilterIndex() {
        this.lastFilterIndex = -1;
        for (int i = this.filters.size() - 1; i >= 0 && this.lastFilterIndex == -1; --i) {
            if (!this.filters.get(i).isEnabled()) continue;
            this.lastFilterIndex = i;
            if (this.isInitialized() && this.viewPort.getOutputFrameBuffer() == this.outputBuffer) {
                this.setupViewPortFrameBuffer();
            }
            return;
        }
        if (this.isInitialized() && this.lastFilterIndex == -1) {
            this.viewPort.setOutputFrameBuffer(this.outputBuffer);
        }
    }

    @Override
    public void cleanup() {
        if (this.viewPort != null) {
            this.viewPort.getCamera().resize(this.originalWidth, this.originalHeight, true);
            this.viewPort.getCamera().setViewPort(this.left, this.right, this.bottom, this.top);
            this.viewPort.setOutputFrameBuffer(this.outputBuffer);
            this.viewPort = null;
            if (this.renderFrameBuffer != null) {
                this.renderFrameBuffer.dispose();
            }
            if (this.depthTexture != null) {
                this.depthTexture.getImage().dispose();
            }
            this.filterTexture.getImage().dispose();
            if (this.renderFrameBufferMS != null) {
                this.renderFrameBufferMS.dispose();
            }
            for (Filter filter : this.filters.getArray()) {
                filter.cleanup(this.renderer);
            }
        }
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
        this.prof = profiler;
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
        Camera cam = vp.getCamera();
        cam.setViewPort(this.left, this.right, this.bottom, this.top);
        cam.resize(w, h, false);
        this.left = cam.getViewPortLeft();
        this.right = cam.getViewPortRight();
        this.top = cam.getViewPortTop();
        this.bottom = cam.getViewPortBottom();
        this.originalWidth = w;
        this.originalHeight = h;
        this.width = (int)((float)w * Math.abs(this.right - this.left));
        this.height = (int)((float)h * Math.abs(this.bottom - this.top));
        this.width = Math.max(1, this.width);
        this.height = Math.max(1, this.height);
        if (this.originalWidth != this.width || this.originalHeight != this.height) {
            this.multiView = true;
        }
        this.cameraInit = true;
        this.computeDepth = false;
        if (this.renderFrameBuffer == null && this.renderFrameBufferMS == null) {
            this.outputBuffer = this.viewPort.getOutputFrameBuffer();
        }
        EnumSet<Caps> caps = this.renderer.getCaps();
        if (this.numSamples > 1 && caps.contains((Object)Caps.FrameBufferMultisample)) {
            this.renderFrameBufferMS = new FrameBuffer(this.width, this.height, this.numSamples);
            if (caps.contains((Object)Caps.OpenGL32)) {
                Texture2D msColor = new Texture2D(this.width, this.height, this.numSamples, this.fbFormat);
                Texture2D msDepth = new Texture2D(this.width, this.height, this.numSamples, this.depthFormat);
                this.renderFrameBufferMS.setDepthTexture(msDepth);
                this.renderFrameBufferMS.setColorTexture(msColor);
                this.filterTexture = msColor;
                this.depthTexture = msDepth;
            } else {
                this.renderFrameBufferMS.setDepthBuffer(this.depthFormat);
                this.renderFrameBufferMS.setColorBuffer(this.fbFormat);
            }
        }
        if (this.numSamples <= 1 || !caps.contains((Object)Caps.OpenGL32)) {
            this.renderFrameBuffer = new FrameBuffer(this.width, this.height, 1);
            this.renderFrameBuffer.setDepthBuffer(this.depthFormat);
            this.filterTexture = new Texture2D(this.width, this.height, this.fbFormat);
            this.renderFrameBuffer.setColorTexture(this.filterTexture);
        }
        for (Filter filter : this.filters.getArray()) {
            this.initFilter(filter, vp);
        }
        this.setupViewPortFrameBuffer();
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void removeAllFilters() {
        this.filters.clear();
        this.updateLastFilterIndex();
    }

    public void setNumSamples(int numSamples) {
        if (numSamples <= 0) {
            throw new IllegalArgumentException("numSamples must be > 0");
        }
        this.numSamples = numSamples;
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public void setFrameBufferFormat(Image.Format fbFormat) {
        this.fbFormat = fbFormat;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.numSamples, "numSamples", 0);
        oc.writeSavableArrayList(new ArrayList<Filter>(this.filters), "filters", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.numSamples = ic.readInt("numSamples", 0);
        this.filters = new SafeArrayList<Filter>(Filter.class, ic.readSavableArrayList("filters", null));
        for (Filter filter : this.filters.getArray()) {
            filter.setProcessor(this);
            this.setFilterState(filter, filter.isEnabled());
        }
        this.assetManager = im.getAssetManager();
    }

    public Texture2D getDepthTexture() {
        return this.depthTexture;
    }

    public Texture2D getFilterTexture() {
        return this.filterTexture;
    }

    public <T extends Filter> T getFilter(Class<T> filterType) {
        for (Filter c : this.filters.getArray()) {
            if (!filterType.isAssignableFrom(c.getClass())) continue;
            return (T)c;
        }
        return null;
    }

    public List<Filter> getFilterList() {
        return Collections.unmodifiableList(this.filters);
    }

    private void setupViewPortFrameBuffer() {
        if (this.renderFrameBufferMS != null) {
            this.viewPort.setOutputFrameBuffer(this.renderFrameBufferMS);
        } else {
            this.viewPort.setOutputFrameBuffer(this.renderFrameBuffer);
        }
    }
}

