/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.logic;

import com.jme3.asset.AssetManager;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.LightProbe;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class SinglePassAndImageBasedLightingLogic
extends DefaultTechniqueDefLogic {
    private static final String DEFINE_SINGLE_PASS_LIGHTING = "SINGLE_PASS_LIGHTING";
    private static final String DEFINE_NB_LIGHTS = "NB_LIGHTS";
    private static final String DEFINE_NB_PROBES = "NB_PROBES";
    private static final String DEFINE_USE_AMBIENT_LIGHT = "USE_AMBIENT_LIGHT";
    private static final RenderState ADDITIVE_LIGHT = new RenderState();
    private boolean useAmbientLight;
    private final ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private final List<LightProbe> lightProbes = new ArrayList<LightProbe>(3);
    private final int singlePassLightingDefineId;
    private final int nbLightsDefineId;
    private final int nbProbesDefineId;
    private final int useAmbientLightDefineId;

    public SinglePassAndImageBasedLightingLogic(TechniqueDef techniqueDef) {
        super(techniqueDef);
        this.singlePassLightingDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_SINGLE_PASS_LIGHTING, VarType.Boolean);
        this.nbLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NB_LIGHTS, VarType.Int);
        this.nbProbesDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NB_PROBES, VarType.Int);
        this.useAmbientLightDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_USE_AMBIENT_LIGHT, VarType.Boolean);
    }

    @Override
    public Shader makeCurrent(AssetManager assetManager, RenderManager renderManager, EnumSet<Caps> rendererCaps, LightList lights, DefineList defines) {
        defines.set(this.nbLightsDefineId, renderManager.getSinglePassLightBatchSize() * 3);
        defines.set(this.singlePassLightingDefineId, true);
        if (lights != null) {
            this.lightProbes.clear();
            this.extractIndirectLights(lights, false);
            defines.set(this.nbProbesDefineId, this.lightProbes.size());
            defines.set(this.useAmbientLightDefineId, this.useAmbientLight);
        }
        return super.makeCurrent(assetManager, renderManager, rendererCaps, lights, defines);
    }

    protected int updateLightListUniforms(Shader shader, Geometry g, LightList lightList, int numLights, RenderManager rm, int startIndex, int lastTexUnit) {
        int curIndex;
        if (numLights == 0) {
            return 0;
        }
        Uniform lightData = shader.getUniform("g_LightData");
        lightData.setVector4Length(numLights * 3);
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        Uniform lightProbeData = shader.getUniform("g_LightProbeData");
        Uniform lightProbeData2 = shader.getUniform("g_LightProbeData2");
        Uniform lightProbeData3 = shader.getUniform("g_LightProbeData3");
        Uniform shCoeffs = shader.getUniform("g_ShCoeffs");
        Uniform lightProbePemMap = shader.getUniform("g_PrefEnvMap");
        Uniform shCoeffs2 = shader.getUniform("g_ShCoeffs2");
        Uniform lightProbePemMap2 = shader.getUniform("g_PrefEnvMap2");
        Uniform shCoeffs3 = shader.getUniform("g_ShCoeffs3");
        Uniform lightProbePemMap3 = shader.getUniform("g_PrefEnvMap3");
        this.lightProbes.clear();
        if (startIndex != 0) {
            rm.getRenderer().applyRenderState(ADDITIVE_LIGHT);
            ambientColor.setValue(VarType.Vector4, ColorRGBA.Black);
        } else {
            this.extractIndirectLights(lightList, true);
            ambientColor.setValue(VarType.Vector4, this.ambientLightColor);
        }
        if (!this.lightProbes.isEmpty()) {
            LightProbe lightProbe = this.lightProbes.get(0);
            lastTexUnit = this.setProbeData(rm, lastTexUnit, lightProbeData, shCoeffs, lightProbePemMap, lightProbe);
            if (this.lightProbes.size() > 1) {
                lightProbe = this.lightProbes.get(1);
                lastTexUnit = this.setProbeData(rm, lastTexUnit, lightProbeData2, shCoeffs2, lightProbePemMap2, lightProbe);
            }
            if (this.lightProbes.size() > 2) {
                lightProbe = this.lightProbes.get(2);
                this.setProbeData(rm, lastTexUnit, lightProbeData3, shCoeffs3, lightProbePemMap3, lightProbe);
            }
        } else {
            lightProbeData.setValue(VarType.Matrix4, LightProbe.FALLBACK_MATRIX);
        }
        int lightDataIndex = 0;
        TempVars vars = TempVars.get();
        Vector4f tmpVec = vars.vect4f1;
        int endIndex = numLights + startIndex;
        block5: for (curIndex = startIndex; curIndex < endIndex && curIndex < lightList.size(); ++curIndex) {
            Light l = lightList.get(curIndex);
            if (l.getType() == Light.Type.Ambient) {
                ++endIndex;
                continue;
            }
            ColorRGBA color = l.getColor();
            if (l.getType() != Light.Type.Probe) {
                lightData.setVector4InArray(color.getRed(), color.getGreen(), color.getBlue(), l.getType().getId(), lightDataIndex);
                ++lightDataIndex;
            }
            switch (l.getType()) {
                case Directional: {
                    DirectionalLight dl = (DirectionalLight)l;
                    Vector3f dir = dl.getDirection();
                    tmpVec.set(dir.getX(), dir.getY(), dir.getZ(), 0.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), -1.0f, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Point: {
                    PointLight pl = (PointLight)l;
                    Vector3f pos = pl.getPosition();
                    float invRadius = pl.getInvRadius();
                    tmpVec.set(pos.getX(), pos.getY(), pos.getZ(), 1.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRadius, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Spot: {
                    SpotLight sl = (SpotLight)l;
                    Vector3f pos2 = sl.getPosition();
                    Vector3f dir2 = sl.getDirection();
                    float invRange = sl.getInvSpotRange();
                    float spotAngleCos = sl.getPackedAngleCos();
                    tmpVec.set(pos2.getX(), pos2.getY(), pos2.getZ(), 1.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRange, lightDataIndex);
                    tmpVec.set(dir2.getX(), dir2.getY(), dir2.getZ(), 0.0f);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), spotAngleCos, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                }
            }
        }
        vars.release();
        while (lightDataIndex < numLights * 3) {
            lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightDataIndex);
            ++lightDataIndex;
        }
        return curIndex;
    }

    private int setProbeData(RenderManager rm, int lastTexUnit, Uniform lightProbeData, Uniform shCoeffs, Uniform lightProbePemMap, LightProbe lightProbe) {
        lightProbeData.setValue(VarType.Matrix4, lightProbe.getUniformMatrix());
        shCoeffs.setValue(VarType.Vector3Array, lightProbe.getShCoeffs());
        int pemUnit = lastTexUnit++;
        rm.getRenderer().setTexture(pemUnit, lightProbe.getPrefilteredEnvMap());
        lightProbePemMap.setValue(VarType.Int, pemUnit);
        return lastTexUnit;
    }

    @Override
    public void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights, int lastTexUnit) {
        int nbRenderedLights = 0;
        Renderer renderer = renderManager.getRenderer();
        int batchSize = renderManager.getSinglePassLightBatchSize();
        if (lights.size() == 0) {
            this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, 0, lastTexUnit);
            renderer.setShader(shader);
            SinglePassAndImageBasedLightingLogic.renderMeshFromGeometry(renderer, geometry);
        } else {
            while (nbRenderedLights < lights.size()) {
                nbRenderedLights = this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, nbRenderedLights, lastTexUnit);
                renderer.setShader(shader);
                SinglePassAndImageBasedLightingLogic.renderMeshFromGeometry(renderer, geometry);
            }
        }
    }

    protected void extractIndirectLights(LightList lightList, boolean removeLights) {
        this.ambientLightColor.set(0.0f, 0.0f, 0.0f, 1.0f);
        this.useAmbientLight = false;
        for (int j = 0; j < lightList.size(); ++j) {
            Light l = lightList.get(j);
            if (l instanceof AmbientLight) {
                this.useAmbientLight = true;
                this.ambientLightColor.addLocal(l.getColor());
                if (removeLights) {
                    lightList.remove(l);
                    --j;
                }
            }
            if (!(l instanceof LightProbe)) continue;
            this.lightProbes.add((LightProbe)l);
            if (!removeLights) continue;
            lightList.remove(l);
            --j;
        }
        this.ambientLightColor.a = 1.0f;
    }

    static {
        ADDITIVE_LIGHT.setBlendMode(RenderState.BlendMode.AlphaAdditive);
        ADDITIVE_LIGHT.setDepthWrite(false);
    }
}

