/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.JoystickAxis;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JoystickCompatibilityMappings {
    private static final Logger logger = Logger.getLogger(JoystickCompatibilityMappings.class.getName());
    private static String[] searchPaths = new String[]{"joystick-mapping.properties"};
    private static Map<String, Map<String, String>> joystickMappings = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, AxisData>> axisMappings = new HashMap<String, Map<String, AxisData>>();
    private static Map<JoystickAxis, float[]> axisRangeMappings = new HashMap<JoystickAxis, float[]>();
    private static Map<String, Map<String, String>> buttonMappings = new HashMap<String, Map<String, String>>();
    private static final Map<Pattern, String> nameRemappings = new HashMap<Pattern, String>();
    private static final Map<String, String> nameCache = new HashMap<String, String>();

    private JoystickCompatibilityMappings() {
    }

    protected static Map<String, String> getMappings(String joystickName, boolean create) {
        Map<String, String> result = joystickMappings.get(joystickName.trim());
        if (result == null && create) {
            result = new HashMap<String, String>();
            joystickMappings.put(joystickName.trim(), result);
        }
        return result;
    }

    private static Map<String, AxisData> getAxisMappings(String joystickName, boolean create) {
        Map<String, AxisData> result = axisMappings.get(joystickName.trim());
        if (result == null && create) {
            result = new HashMap<String, AxisData>();
            axisMappings.put(joystickName.trim(), result);
        }
        return result;
    }

    protected static Map<String, String> getButtonMappings(String joystickName, boolean create) {
        Map<String, String> result = buttonMappings.get(joystickName.trim());
        if (result == null && create) {
            result = new HashMap<String, String>();
            buttonMappings.put(joystickName.trim(), result);
        }
        return result;
    }

    public static float remapAxisRange(JoystickAxis axis, float currentValue) {
        String joyName = axis.getJoystick().getName();
        float[] range = axisRangeMappings.get(axis);
        if (range == null) {
            Map<String, AxisData> map = JoystickCompatibilityMappings.getAxisMappings(joyName, false);
            if (map != null && map.containsKey(axis.getName())) {
                range = map.get((Object)axis.getName()).range;
                axisRangeMappings.put(axis, range);
            } else if ((joyName = JoystickCompatibilityMappings.getNormalizedName(joyName)) != null && (map = JoystickCompatibilityMappings.getAxisMappings(joyName, false)) != null && map.containsKey(axis.getName())) {
                range = map.get((Object)axis.getName()).range;
                axisRangeMappings.put(axis, range);
            }
        }
        if (range == null) {
            axisRangeMappings.put(axis, new float[0]);
            return currentValue;
        }
        if (range.length == 0) {
            return currentValue;
        }
        return (currentValue + range[1] + range[0]) * ((range[1] - range[0]) / 2.0f);
    }

    public static String remapAxis(String joystickName, String componentId) {
        logger.log(Level.FINE, "remapAxis(" + joystickName + ", " + componentId + ")");
        joystickName = joystickName.trim();
        Map<String, Object> map = JoystickCompatibilityMappings.getAxisMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped axis:" + map.get(componentId));
            return ((AxisData)map.get((Object)componentId)).name;
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped axis:" + map.get(componentId));
            return (String)map.get(componentId);
        }
        joystickName = JoystickCompatibilityMappings.getNormalizedName(joystickName);
        logger.log(Level.FINE, "normalized joystick name:" + joystickName);
        if (joystickName == null) {
            return componentId;
        }
        map = JoystickCompatibilityMappings.getAxisMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return ((AxisData)map.get((Object)componentId)).name;
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return (String)map.get(componentId);
        }
        return componentId;
    }

    public static String remapButton(String joystickName, String componentId) {
        logger.log(Level.FINE, "remapAxis(" + joystickName + ", " + componentId + ")");
        joystickName = joystickName.trim();
        Map<String, String> map = JoystickCompatibilityMappings.getButtonMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped axis:" + map.get(componentId));
            return map.get(componentId);
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped axis:" + map.get(componentId));
            return map.get(componentId);
        }
        joystickName = JoystickCompatibilityMappings.getNormalizedName(joystickName);
        logger.log(Level.FINE, "normalized joystick name:" + joystickName);
        if (joystickName == null) {
            return componentId;
        }
        map = JoystickCompatibilityMappings.getButtonMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return map.get(componentId);
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return map.get(componentId);
        }
        return componentId;
    }

    public static String remapComponent(String joystickName, String componentId) {
        logger.log(Level.FINE, "remapComponent(" + joystickName + ", " + componentId + ")");
        joystickName = joystickName.trim();
        Map<String, String> map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map != null && map.containsKey(componentId)) {
            logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
            return map.get(componentId);
        }
        joystickName = JoystickCompatibilityMappings.getNormalizedName(joystickName);
        logger.log(Level.FINE, "normalized joystick name:" + joystickName);
        if (joystickName == null) {
            return componentId;
        }
        map = JoystickCompatibilityMappings.getMappings(joystickName, false);
        if (map == null) {
            return componentId;
        }
        if (!map.containsKey(componentId)) {
            return componentId;
        }
        logger.log(Level.FINE, "returning remapped:" + map.get(componentId));
        return map.get(componentId);
    }

    public static Map<String, String> getJoystickButtonMappings(String joystickName) {
        Map<String, String> result = JoystickCompatibilityMappings.getButtonMappings(joystickName.trim(), false);
        if (result == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, String> getJoystickMappings(String joystickName) {
        Map<String, String> result = JoystickCompatibilityMappings.getMappings(joystickName.trim(), false);
        if (result == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(result);
    }

    public static void addAxisMapping(String stickName, String sourceComponentId, String remapId) {
        logger.log(Level.FINE, "addAxisMapping(" + stickName + ", " + sourceComponentId + ", " + remapId + ")");
        JoystickCompatibilityMappings.getAxisMappings(stickName, true).put(sourceComponentId, new AxisData(remapId, new float[0]));
    }

    public static void addAxisMapping(String stickName, String sourceComponentId, String remapId, float[] range) {
        logger.log(Level.FINE, "addAxisMapping(" + stickName + ", " + sourceComponentId + ", " + remapId + ")");
        if (range.length != 2) {
            throw new IllegalArgumentException("The range must have exactly 2 elements");
        }
        JoystickCompatibilityMappings.getAxisMappings(stickName, true).put(sourceComponentId, new AxisData(remapId, range));
    }

    public static void addButtonMapping(String stickName, String sourceComponentId, String remapId) {
        logger.log(Level.FINE, "addButtonMapping(" + stickName + ", " + sourceComponentId + ", " + remapId + ")");
        JoystickCompatibilityMappings.getButtonMappings(stickName, true).put(sourceComponentId, remapId);
    }

    public static void addMapping(String stickName, String sourceComponentId, String remapId) {
        logger.log(Level.FINE, "addMapping(" + stickName + ", " + sourceComponentId + ", " + remapId + ")");
        JoystickCompatibilityMappings.getMappings(stickName, true).put(sourceComponentId, remapId);
    }

    public static void addMappings(Properties p) {
        String AXIS_LABEL = "axis";
        String BUTTON_LABEL = "button";
        block10: for (Map.Entry<Object, Object> e : p.entrySet()) {
            int lBrackIndex;
            String type;
            float[] range = null;
            String key = String.valueOf(e.getKey()).trim();
            int firstSplit = key.indexOf(46);
            int split = key.lastIndexOf(46);
            if (split < 0) {
                logger.log(Level.WARNING, "Skipping mapping:{0}", e);
                continue;
            }
            if (firstSplit >= 0 && firstSplit != split) {
                type = key.substring(0, firstSplit).trim();
                if (!type.equals("axis") && !type.equals("button")) {
                    firstSplit = -1;
                    type = "";
                }
            } else {
                firstSplit = -1;
                type = "";
            }
            String stick = key.substring(firstSplit + 1, split).trim();
            String component = key.substring(split + 1).trim();
            String value = String.valueOf(e.getValue()).trim();
            if ("regex".equals(component)) {
                JoystickCompatibilityMappings.addJoystickNameRegex(value, stick);
            }
            if ((lBrackIndex = value.indexOf(91)) > 0) {
                range = new float[2];
                int rBrackIndex = value.indexOf(93);
                int commaIndex = value.indexOf(44);
                if (rBrackIndex > -1 && commaIndex > -1) {
                    try {
                        range[0] = Float.parseFloat(value.substring(lBrackIndex + 1, commaIndex).trim());
                        range[1] = Float.parseFloat(value.substring(commaIndex + 1, rBrackIndex).trim());
                        value = value.substring(0, lBrackIndex).trim();
                        type = "axis";
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "Could not parse axis range \"" + value.substring(lBrackIndex) + "\"", nfe);
                    }
                }
            }
            switch (type) {
                case "axis": {
                    if (range == null) {
                        JoystickCompatibilityMappings.addAxisMapping(stick, component, value);
                        continue block10;
                    }
                    JoystickCompatibilityMappings.addAxisMapping(stick, component, value, range);
                    continue block10;
                }
                case "button": {
                    JoystickCompatibilityMappings.addButtonMapping(stick, component, value);
                    continue block10;
                }
            }
            JoystickCompatibilityMappings.addMapping(stick, component, value);
        }
    }

    public static void addJoystickNameRegex(String regex, String name) {
        logger.log(Level.FINE, "addJoystickNameRegex(" + regex + ", " + name + ")");
        nameRemappings.put(Pattern.compile(regex), name);
    }

    protected static String getNormalizedName(String name) {
        String result = nameCache.get(name);
        if (result != null) {
            return result;
        }
        for (Map.Entry<Pattern, String> e : nameRemappings.entrySet()) {
            Pattern p = e.getKey();
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            nameCache.put(name, e.getValue());
            return e.getValue();
        }
        return null;
    }

    public static void loadMappingProperties(URL u) throws IOException {
        logger.log(Level.FINE, "Loading mapping properties:{0}", u);
        try (InputStream in = u.openStream();){
            Properties p = new Properties();
            p.load(in);
            JoystickCompatibilityMappings.addMappings(p);
        }
    }

    protected static void loadMappings(ClassLoader cl, String path) throws IOException {
        logger.log(Level.FINE, "Searching for mappings for path:{0}", path);
        Enumeration<URL> en = cl.getResources(path);
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            try {
                JoystickCompatibilityMappings.loadMappingProperties(u);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error loading:" + u, e);
            }
        }
    }

    protected static void loadDefaultMappings() {
        for (String s : searchPaths) {
            try {
                JoystickCompatibilityMappings.loadMappings(JoystickCompatibilityMappings.class.getClassLoader(), s);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error searching resource path:{0}", s);
            }
        }
    }

    static {
        JoystickCompatibilityMappings.loadDefaultMappings();
    }

    private static class AxisData {
        String name;
        float[] range;

        AxisData(String name, float[] range) {
            this.name = name;
            this.range = range;
        }
    }
}

