/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapCharacter;
import com.jme3.font.BitmapCharacterSet;
import com.jme3.font.BitmapFont;
import com.jme3.font.Rectangle;
import com.jme3.font.StringBlock;
import com.jme3.math.ColorRGBA;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

class LetterQuad {
    private static final Rectangle UNBOUNDED = new Rectangle(0.0f, 0.0f, Float.MAX_VALUE, Float.MAX_VALUE);
    private static final float LINE_DIR = -1.0f;
    private final BitmapFont font;
    private final char c;
    private final int index;
    private int style;
    private BitmapCharacter bitmapChar = null;
    private float x0 = -2.1474836E9f;
    private float y0 = -2.1474836E9f;
    private float width = -2.1474836E9f;
    private float height = -2.1474836E9f;
    private float xAdvance = 0.0f;
    private float u0;
    private float v0;
    private float u1;
    private float v1;
    private float lineY;
    private boolean eol;
    private LetterQuad previous;
    private LetterQuad next;
    private int colorInt = -1;
    private final boolean rightToLeft;
    private float alignX;
    private float alignY;
    private float sizeScale = 1.0f;

    protected LetterQuad(BitmapFont font, boolean rightToLeft) {
        this.font = font;
        this.c = '\u0000';
        this.rightToLeft = rightToLeft;
        this.index = -1;
        this.setBitmapChar(null);
    }

    protected LetterQuad(char c, LetterQuad prev) {
        this.font = prev.font;
        this.rightToLeft = prev.rightToLeft;
        this.c = c;
        this.index = prev.index + 1;
        this.eol = this.isLineFeed();
        this.setBitmapChar(c);
        prev.insert(this);
    }

    LetterQuad addNextCharacter(char c) {
        LetterQuad n = new LetterQuad(c, this);
        return n;
    }

    BitmapCharacter getBitmapChar() {
        return this.bitmapChar;
    }

    char getChar() {
        return this.c;
    }

    int getIndex() {
        return this.index;
    }

    private Rectangle getBound(StringBlock block) {
        if (block.getTextBox() != null) {
            return block.getTextBox();
        }
        return UNBOUNDED;
    }

    LetterQuad getPrevious() {
        return this.previous;
    }

    LetterQuad getNext() {
        return this.next;
    }

    public float getU0() {
        return this.u0;
    }

    float getU1() {
        return this.u1;
    }

    float getV0() {
        return this.v0;
    }

    float getV1() {
        return this.v1;
    }

    boolean isRightToLeft() {
        return this.rightToLeft;
    }

    boolean isInvalid() {
        return this.x0 == -2.1474836E9f;
    }

    boolean isInvalid(StringBlock block) {
        return this.isInvalid(block, 0.0f);
    }

    boolean isInvalid(StringBlock block, float gap) {
        if (this.isHead() || this.isTail()) {
            return false;
        }
        if (this.x0 == -2.1474836E9f || this.y0 == -2.1474836E9f) {
            return true;
        }
        Rectangle bound = block.getTextBox();
        if (bound == null) {
            return false;
        }
        return this.x0 > 0.0f && bound.x + bound.width - gap < this.getX1();
    }

    void clip(StringBlock block) {
        Rectangle bound = block.getTextBox();
        if (bound == null) {
            return;
        }
        float x1 = Math.min(bound.x + bound.width, this.x0 + this.width);
        float newWidth = x1 - this.x0;
        if (newWidth == this.width) {
            return;
        }
        float rescale = newWidth / this.width;
        this.u1 = this.u0 + (this.u1 - this.u0) * rescale;
        this.width = newWidth;
    }

    float getX0() {
        return this.x0;
    }

    float getX1() {
        return this.x0 + this.width;
    }

    float getNextX() {
        return this.x0 + this.xAdvance;
    }

    float getNextLine() {
        return this.lineY + -1.0f * (float)this.font.getCharSet().getLineHeight() * this.sizeScale;
    }

    float getY0() {
        return this.y0;
    }

    float getY1() {
        return this.y0 - this.height;
    }

    float getWidth() {
        return this.width;
    }

    float getHeight() {
        return this.height;
    }

    void insert(LetterQuad ins) {
        LetterQuad n = this.next;
        this.next = ins;
        ins.next = n;
        ins.previous = this;
        n.previous = ins;
    }

    void invalidate() {
        this.eol = this.isLineFeed();
        this.setBitmapChar(this.font.getCharSet().getCharacter(this.c, this.style));
    }

    boolean isTail() {
        return this.next == null;
    }

    boolean isHead() {
        return this.previous == null;
    }

    LetterQuad remove() {
        this.previous.next = this.next;
        this.next.previous = this.previous;
        return this.next;
    }

    void setPrevious(LetterQuad before) {
        this.previous = before;
    }

    void setStyle(int style) {
        this.style = style;
        this.invalidate();
    }

    void setColor(ColorRGBA color) {
        this.colorInt = color.asIntRGBA();
        this.invalidate();
    }

    void setAlpha(float alpha) {
        int i = (int)(alpha * 255.0f) & 0xFF;
        this.colorInt = this.colorInt & 0xFFFFFF00 | i;
        this.invalidate();
    }

    void setBitmapChar(char c) {
        BitmapCharacterSet charSet = this.font.getCharSet();
        BitmapCharacter bm = charSet.getCharacter(c, this.style);
        this.setBitmapChar(bm);
    }

    void setBitmapChar(BitmapCharacter bitmapChar) {
        this.x0 = -2.1474836E9f;
        this.y0 = -2.1474836E9f;
        this.width = -2.1474836E9f;
        this.height = -2.1474836E9f;
        this.alignX = 0.0f;
        this.alignY = 0.0f;
        BitmapCharacterSet charSet = this.font.getCharSet();
        this.bitmapChar = bitmapChar;
        if (bitmapChar != null) {
            this.u0 = (float)bitmapChar.getX() / (float)charSet.getWidth();
            this.v0 = (float)bitmapChar.getY() / (float)charSet.getHeight();
            this.u1 = this.u0 + (float)bitmapChar.getWidth() / (float)charSet.getWidth();
            this.v1 = this.v0 + (float)bitmapChar.getHeight() / (float)charSet.getHeight();
        } else {
            this.u0 = 0.0f;
            this.v0 = 0.0f;
            this.u1 = 0.0f;
            this.v1 = 0.0f;
        }
    }

    void setNext(LetterQuad next) {
        this.next = next;
    }

    void update(StringBlock block) {
        float[] tabs = block.getTabPosition();
        float tabWidth = block.getTabWidth();
        Rectangle bound = this.getBound(block);
        this.sizeScale = block.getSize() / (float)this.font.getCharSet().getRenderedSize();
        this.lineY = this.computeLineY(block);
        if (this.isHead()) {
            this.x0 = this.getBound((StringBlock)block).x;
            this.y0 = this.lineY;
            this.width = 0.0f;
            this.height = 0.0f;
            this.xAdvance = 0.0f;
        } else if (this.isTab()) {
            this.x0 = this.previous.getNextX();
            this.width = tabWidth;
            this.y0 = this.lineY;
            this.height = 0.0f;
            if (tabs != null && this.x0 < tabs[tabs.length - 1]) {
                for (int i = 0; i < tabs.length - 1; ++i) {
                    if (!(this.x0 > tabs[i]) || !(this.x0 < tabs[i + 1])) continue;
                    this.width = tabs[i + 1] - this.x0;
                }
            }
            this.xAdvance = this.width;
        } else if (this.bitmapChar == null) {
            this.x0 = this.getPrevious().getX1();
            this.y0 = this.lineY;
            this.width = 0.0f;
            this.height = 0.0f;
            this.xAdvance = 0.0f;
        } else {
            float xOffset = (float)this.bitmapChar.getXOffset() * this.sizeScale;
            float yOffset = (float)this.bitmapChar.getYOffset() * this.sizeScale;
            this.xAdvance = (float)this.bitmapChar.getXAdvance() * this.sizeScale;
            this.width = (float)this.bitmapChar.getWidth() * this.sizeScale;
            this.height = (float)this.bitmapChar.getHeight() * this.sizeScale;
            float incrScale = this.rightToLeft ? -1.0f : 1.0f;
            float kernAmount = 0.0f;
            if (this.previous.isHead() || this.previous.eol) {
                this.x0 = bound.x;
                this.xAdvance -= xOffset * incrScale;
            } else {
                this.x0 = this.previous.getNextX() + xOffset * incrScale;
                this.xAdvance -= xOffset * incrScale;
            }
            this.y0 = this.lineY + -1.0f * yOffset;
            BitmapCharacter lastChar = this.previous.getBitmapChar();
            if (lastChar != null && block.isKerning()) {
                kernAmount = (float)lastChar.getKerning(this.c) * this.sizeScale;
                this.x0 += kernAmount * incrScale;
            }
        }
        if (this.isEndOfLine()) {
            this.xAdvance = bound.x - this.x0;
        }
    }

    void setEndOfLine() {
        this.eol = true;
    }

    boolean isEndOfLine() {
        return this.eol;
    }

    boolean isLineWrap() {
        return !this.isHead() && !this.isTail() && this.bitmapChar == null && this.c == '\u0000';
    }

    private float computeLineY(StringBlock block) {
        if (this.isHead()) {
            return this.getBound((StringBlock)block).y;
        }
        if (this.previous.eol) {
            return this.previous.getNextLine();
        }
        return this.previous.lineY;
    }

    boolean isLineStart() {
        return this.x0 == 0.0f || this.previous != null && this.previous.eol;
    }

    boolean isBlank() {
        return this.c == ' ' || this.isTab();
    }

    public void storeToArrays(float[] pos, float[] tc, short[] idx, byte[] colors, int quadIdx) {
        float x = this.x0 + this.alignX;
        float y = this.y0 - this.alignY;
        float xpw = x + this.width;
        float ymh = y - this.height;
        pos[0] = x;
        pos[1] = y;
        pos[2] = 0.0f;
        pos[3] = x;
        pos[4] = ymh;
        pos[5] = 0.0f;
        pos[6] = xpw;
        pos[7] = ymh;
        pos[8] = 0.0f;
        pos[9] = xpw;
        pos[10] = y;
        pos[11] = 0.0f;
        float v0 = 1.0f - this.v0;
        float v1 = 1.0f - this.v1;
        tc[0] = this.u0;
        tc[1] = v0;
        tc[2] = this.u0;
        tc[3] = v1;
        tc[4] = this.u1;
        tc[5] = v1;
        tc[6] = this.u1;
        tc[7] = v0;
        colors[3] = (byte)(this.colorInt & 0xFF);
        colors[2] = (byte)(this.colorInt >> 8 & 0xFF);
        colors[1] = (byte)(this.colorInt >> 16 & 0xFF);
        colors[0] = (byte)(this.colorInt >> 24 & 0xFF);
        System.arraycopy(colors, 0, colors, 4, 4);
        System.arraycopy(colors, 0, colors, 8, 4);
        System.arraycopy(colors, 0, colors, 12, 4);
        short i0 = (short)(quadIdx * 4);
        short i1 = (short)(i0 + 1);
        short i2 = (short)(i0 + 2);
        short i3 = (short)(i0 + 3);
        idx[0] = i0;
        idx[1] = i1;
        idx[2] = i2;
        idx[3] = i0;
        idx[4] = i2;
        idx[5] = i3;
    }

    public void appendPositions(FloatBuffer fb) {
        float sx = this.x0 + this.alignX;
        float sy = this.y0 - this.alignY;
        float ex = sx + this.width;
        float ey = sy - this.height;
        fb.put(sx).put(sy).put(0.0f);
        fb.put(sx).put(ey).put(0.0f);
        fb.put(ex).put(ey).put(0.0f);
        fb.put(ex).put(sy).put(0.0f);
    }

    public void appendPositions(ShortBuffer sb) {
        float x1 = this.getX1();
        float y1 = this.getY1();
        short x = (short)this.x0;
        short y = (short)this.y0;
        short xpw = (short)x1;
        short ymh = (short)y1;
        sb.put(x).put(y).put((short)0);
        sb.put(x).put(ymh).put((short)0);
        sb.put(xpw).put(ymh).put((short)0);
        sb.put(xpw).put(y).put((short)0);
    }

    public void appendTexCoords(FloatBuffer fb) {
        float v0 = 1.0f - this.v0;
        float v1 = 1.0f - this.v1;
        fb.put(this.u0).put(v0);
        fb.put(this.u0).put(v1);
        fb.put(this.u1).put(v1);
        fb.put(this.u1).put(v0);
    }

    public void appendColors(ByteBuffer bb) {
        bb.putInt(this.colorInt);
        bb.putInt(this.colorInt);
        bb.putInt(this.colorInt);
        bb.putInt(this.colorInt);
    }

    public void appendIndices(ShortBuffer sb, int quadIndex) {
        short v0 = (short)(quadIndex * 4);
        short v1 = (short)(v0 + 1);
        short v2 = (short)(v0 + 2);
        short v3 = (short)(v0 + 3);
        sb.put(v0).put(v1).put(v2);
        sb.put(v0).put(v2).put(v3);
    }

    public String toString() {
        return String.valueOf(this.c);
    }

    void setAlignment(float alignX, float alignY) {
        this.alignX = alignX;
        this.alignY = alignY;
    }

    float getAlignX() {
        return this.alignX;
    }

    float getAlignY() {
        return this.alignY;
    }

    boolean isLineFeed() {
        return this.c == '\n';
    }

    boolean isTab() {
        return this.c == '\t';
    }
}

