/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.cinematic.KeyFrame;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.TimeLine;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.cinematic.events.CameraEvent;
import com.jme3.cinematic.events.CinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Node;
import com.jme3.scene.control.CameraControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cinematic
extends AbstractCinematicEvent
implements AppState {
    private static final Logger logger = Logger.getLogger(Cinematic.class.getName());
    private Node scene;
    protected TimeLine timeLine = new TimeLine();
    private int lastFetchedKeyFrame = -1;
    private final List<CinematicEvent> cinematicEvents = new ArrayList<CinematicEvent>();
    private Map<String, CameraNode> cameras = new HashMap<String, CameraNode>();
    private CameraNode currentCam;
    private boolean initialized = false;
    private Map<String, Map<Object, Object>> eventsData;
    private float nextEnqueue = 0.0f;
    private String id;

    protected Cinematic() {
    }

    public Cinematic(float initialDuration) {
        super(initialDuration);
    }

    public Cinematic(LoopMode loopMode) {
        super(loopMode);
    }

    public Cinematic(float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
    }

    public Cinematic(Node scene) {
        this.scene = scene;
    }

    public Cinematic(Node scene, float initialDuration) {
        super(initialDuration);
        this.scene = scene;
    }

    public Cinematic(Node scene, LoopMode loopMode) {
        super(loopMode);
        this.scene = scene;
    }

    public Cinematic(Node scene, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.scene = scene;
    }

    @Override
    public void onPlay() {
        if (this.isInitialized() && this.playState == PlayState.Paused) {
            for (int i = 0; i < this.cinematicEvents.size(); ++i) {
                CinematicEvent ce = this.cinematicEvents.get(i);
                if (ce.getPlayState() != PlayState.Paused) continue;
                ce.play();
            }
        }
    }

    @Override
    public void onStop() {
        this.time = 0.0f;
        this.lastFetchedKeyFrame = -1;
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.setTime(0.0f);
            ce.forceStop();
        }
        this.setEnableCurrentCam(false);
    }

    @Override
    public void onPause() {
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            if (ce.getPlayState() != PlayState.Playing) continue;
            ce.pause();
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.cinematicEvents.toArray(new CinematicEvent[this.cinematicEvents.size()]), "cinematicEvents", null);
        oc.writeStringSavableMap(this.cameras, "cameras", null);
        oc.write(this.timeLine, "timeLine", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        Savable[] events;
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        for (Savable c : events = ic.readSavableArray("cinematicEvents", null)) {
            this.cinematicEvents.add((CinematicEvent)c);
        }
        this.cameras = ic.readStringSavableMap("cameras", null);
        this.timeLine = (TimeLine)ic.readSavable("timeLine", null);
    }

    @Override
    public void setSpeed(float speed) {
        super.setSpeed(speed);
        for (int i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.setSpeed(speed);
        }
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        this.initEvent(app, this);
        for (CinematicEvent cinematicEvent : this.cinematicEvents) {
            cinematicEvent.initEvent(app, this);
        }
        if (!this.cameras.isEmpty()) {
            for (CameraNode n : this.cameras.values()) {
                n.setCamera(app.getCamera());
            }
        }
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.play();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.playState == PlayState.Playing;
    }

    @Override
    public void stateAttached(AppStateManager stateManager) {
    }

    @Override
    public void stateDetached(AppStateManager stateManager) {
        this.stop();
    }

    @Override
    public void update(float tpf) {
        if (this.isInitialized() && this.playState == PlayState.Playing) {
            this.internalUpdate(tpf);
        }
    }

    @Override
    public void onUpdate(float tpf) {
        int i;
        int keyFrameIndex = this.timeLine.getKeyFrameIndexFromTime(this.time);
        for (i = this.lastFetchedKeyFrame + 1; i <= keyFrameIndex; ++i) {
            KeyFrame keyFrame = (KeyFrame)this.timeLine.get(i);
            if (keyFrame == null) continue;
            keyFrame.trigger();
        }
        for (i = 0; i < this.cinematicEvents.size(); ++i) {
            CinematicEvent ce = this.cinematicEvents.get(i);
            ce.internalUpdate(tpf);
        }
        this.lastFetchedKeyFrame = keyFrameIndex;
    }

    @Override
    public void setTime(float time) {
        this.onStop();
        super.setTime(time);
        int keyFrameIndex = this.timeLine.getKeyFrameIndexFromTime(time);
        for (int i = 0; i <= keyFrameIndex; ++i) {
            KeyFrame keyFrame = (KeyFrame)this.timeLine.get(i);
            if (keyFrame == null) continue;
            for (CinematicEvent ce : keyFrame.getCinematicEvents()) {
                float t = this.time - this.timeLine.getKeyFrameTime(keyFrame);
                if (t >= 0.0f && (t <= ce.getInitialDuration() || ce.getLoopMode() != LoopMode.DontLoop)) {
                    ce.play();
                }
                ce.setTime(t);
            }
        }
        this.lastFetchedKeyFrame = keyFrameIndex;
        if (this.playState != PlayState.Playing) {
            this.pause();
        }
    }

    public KeyFrame addCinematicEvent(float timeStamp, CinematicEvent cinematicEvent) {
        KeyFrame keyFrame = this.timeLine.getKeyFrameAtTime(timeStamp);
        if (keyFrame == null) {
            keyFrame = new KeyFrame();
            this.timeLine.addKeyFrameAtTime(timeStamp, keyFrame);
        }
        keyFrame.cinematicEvents.add(cinematicEvent);
        this.cinematicEvents.add(cinematicEvent);
        if (this.isInitialized()) {
            cinematicEvent.initEvent(null, this);
        }
        return keyFrame;
    }

    public float enqueueCinematicEvent(CinematicEvent cinematicEvent) {
        float scheduleTime = this.nextEnqueue;
        this.addCinematicEvent(scheduleTime, cinematicEvent);
        this.nextEnqueue += cinematicEvent.getInitialDuration();
        return scheduleTime;
    }

    public boolean removeCinematicEvent(CinematicEvent cinematicEvent) {
        cinematicEvent.dispose();
        this.cinematicEvents.remove(cinematicEvent);
        for (KeyFrame keyFrame : this.timeLine.values()) {
            if (!keyFrame.cinematicEvents.remove(cinematicEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean removeCinematicEvent(float timeStamp, CinematicEvent cinematicEvent) {
        cinematicEvent.dispose();
        KeyFrame keyFrame = this.timeLine.getKeyFrameAtTime(timeStamp);
        return this.removeCinematicEvent(keyFrame, cinematicEvent);
    }

    public boolean removeCinematicEvent(KeyFrame keyFrame, CinematicEvent cinematicEvent) {
        cinematicEvent.dispose();
        boolean ret = keyFrame.cinematicEvents.remove(cinematicEvent);
        this.cinematicEvents.remove(cinematicEvent);
        if (keyFrame.isEmpty()) {
            this.timeLine.removeKeyFrame(keyFrame.getIndex());
        }
        return ret;
    }

    @Override
    public void render(RenderManager rm) {
    }

    @Override
    public void postRender() {
    }

    @Override
    public void cleanup() {
    }

    public void fitDuration() {
        KeyFrame kf = this.timeLine.getKeyFrameAtIndex(this.timeLine.getLastKeyFrameIndex());
        float d = 0.0f;
        for (int i = 0; i < kf.getCinematicEvents().size(); ++i) {
            CinematicEvent ce = kf.getCinematicEvents().get(i);
            float dur = this.timeLine.getKeyFrameTime(kf) + ce.getDuration() * ce.getSpeed();
            if (!(d < dur)) continue;
            d = dur;
        }
        this.initialDuration = d;
    }

    public CameraNode bindCamera(String cameraName, Camera cam) {
        if (this.cameras.containsKey(cameraName)) {
            throw new IllegalArgumentException("Camera " + cameraName + " is already binded to this cinematic");
        }
        CameraNode node = new CameraNode(cameraName, cam);
        node.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        node.getControl(CameraControl.class).setEnabled(false);
        this.cameras.put(cameraName, node);
        this.scene.attachChild(node);
        return node;
    }

    public CameraNode getCamera(String cameraName) {
        return this.cameras.get(cameraName);
    }

    private void setEnableCurrentCam(boolean enabled) {
        if (this.currentCam != null) {
            this.currentCam.getControl(CameraControl.class).setEnabled(enabled);
        }
    }

    public void setActiveCamera(String cameraName) {
        this.setEnableCurrentCam(false);
        this.currentCam = this.cameras.get(cameraName);
        if (this.currentCam == null) {
            logger.log(Level.WARNING, "{0} is not a camera bond to the cinematic, cannot activate", cameraName);
        }
        this.setEnableCurrentCam(true);
    }

    public void activateCamera(float timeStamp, String cameraName) {
        this.addCinematicEvent(timeStamp, new CameraEvent(this, cameraName));
    }

    private Map<String, Map<Object, Object>> getEventsData() {
        if (this.eventsData == null) {
            this.eventsData = new HashMap<String, Map<Object, Object>>();
        }
        return this.eventsData;
    }

    public void putEventData(String type, Object key, Object object) {
        Map<String, Map<Object, Object>> data = this.getEventsData();
        Map<Object, Object> row = data.get(type);
        if (row == null) {
            row = new HashMap<Object, Object>();
        }
        row.put(key, object);
        data.put(type, row);
    }

    public Object getEventData(String type, Object key) {
        Map<Object, Object> row;
        if (this.eventsData != null && (row = this.eventsData.get(type)) != null) {
            return row.get(key);
        }
        return null;
    }

    public void removeEventData(String type, Object key) {
        Map<Object, Object> row;
        if (this.eventsData != null && (row = this.eventsData.get(type)) != null) {
            row.remove(key);
        }
    }

    public void setScene(Node scene) {
        this.scene = scene;
        if (!this.cameras.isEmpty()) {
            for (CameraNode n : this.cameras.values()) {
                this.scene.attachChild(n);
            }
        }
    }

    public Node getScene() {
        return this.scene;
    }

    public void clear() {
        this.dispose();
        this.cinematicEvents.clear();
        this.timeLine.clear();
        if (this.eventsData != null) {
            this.eventsData.clear();
        }
    }

    @Override
    public void dispose() {
        for (CinematicEvent event : this.cinematicEvents) {
            event.dispose();
        }
    }
}

