/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class UrlAssetInfo
extends AssetInfo {
    private final URL url;
    private InputStream in;

    public static UrlAssetInfo create(AssetManager assetManager, AssetKey key, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        InputStream in = conn.getInputStream();
        if (in == null) {
            return null;
        }
        return new UrlAssetInfo(assetManager, key, url, in);
    }

    private UrlAssetInfo(AssetManager assetManager, AssetKey key, URL url, InputStream in) throws IOException {
        super(assetManager, key);
        this.url = url;
        this.in = in;
    }

    public boolean hasInitialConnection() {
        return this.in != null;
    }

    @Override
    public InputStream openStream() {
        if (this.in != null) {
            InputStream in2 = this.in;
            this.in = null;
            return in2;
        }
        try {
            URLConnection conn = this.url.openConnection();
            conn.setUseCaches(false);
            return conn.getInputStream();
        }
        catch (IOException ex) {
            throw new AssetLoadException("Failed to read URL " + this.url, ex);
        }
    }
}

