/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween;

import com.jme3.anim.tween.AbstractTween;
import com.jme3.anim.tween.ContainsTweens;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.util.Primitives;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tweens {
    private static final Logger log = Logger.getLogger(Tweens.class.getName());
    private static final CurveFunction SMOOTH = new SmoothStep();
    private static final CurveFunction SINE = new Sine();

    private Tweens() {
    }

    public static Tween sequence(Tween ... delegates) {
        return new Sequence(delegates);
    }

    public static Tween parallel(Tween ... delegates) {
        return new Parallel(delegates);
    }

    public static Tween delay(double length) {
        return new Delay(length);
    }

    public static Tween stretch(double desiredLength, Tween ... delegates) {
        if (delegates.length == 1) {
            return new Stretch(delegates[0], desiredLength);
        }
        return new Stretch(Tweens.sequence(delegates), desiredLength);
    }

    public static Tween sineStep(Tween ... delegates) {
        if (delegates.length == 1) {
            return new Curve(delegates[0], SINE);
        }
        return new Curve(Tweens.sequence(delegates), SINE);
    }

    public static Tween smoothStep(Tween ... delegates) {
        if (delegates.length == 1) {
            return new Curve(delegates[0], SMOOTH);
        }
        return new Curve(Tweens.sequence(delegates), SMOOTH);
    }

    public static Tween callMethod(Object target, String method, Object ... args) {
        return new CallMethod(target, method, args);
    }

    public static Tween callTweenMethod(double length, Object target, String method, Object ... args) {
        return new CallTweenMethod(length, target, method, args);
    }

    private static class CallTweenMethod
    extends AbstractTween {
        private Object target;
        private Method method;
        private Object[] args;
        private int tIndex = -1;
        private boolean isFloat = false;

        public CallTweenMethod(double length, Object target, String methodName, Object ... args) {
            super(length);
            if (target == null) {
                throw new IllegalArgumentException("Target cannot be null.");
            }
            this.target = target;
            this.method = this.findMethod(target.getClass(), methodName, args);
            if (this.method == null) {
                throw new IllegalArgumentException("Method not found for:" + methodName + " on type:" + target.getClass());
            }
            this.method.setAccessible(true);
            this.args = new Object[args.length + 1];
            if (this.tIndex == 0) {
                for (int i = 0; i < args.length; ++i) {
                    this.args[i + 1] = args[i];
                }
            } else {
                for (int i = 0; i < args.length; ++i) {
                    this.args[i] = args[i];
                }
            }
        }

        private static boolean isFloatType(Class type) {
            return type == Float.TYPE || type == Float.class;
        }

        private static boolean isDoubleType(Class type) {
            return type == Double.TYPE || type == Double.class;
        }

        private Method findMethod(Class type, String name, Object ... args) {
            for (Method m : type.getDeclaredMethods()) {
                if (!Objects.equals(m.getName(), name)) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != args.length + 1) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Param lengths of [" + m + "] differ.  method arg count:" + paramTypes.length + "  lookging for:" + (args.length + 1));
                    continue;
                }
                if (CallTweenMethod.isFloatType(paramTypes[0]) || CallTweenMethod.isDoubleType(paramTypes[0])) {
                    int matches = 0;
                    for (int i = 1; i < paramTypes.length; ++i) {
                        if (!paramTypes[i].isInstance(args[i - 1])) continue;
                        ++matches;
                    }
                    if (matches == args.length) {
                        this.tIndex = 0;
                        this.isFloat = CallTweenMethod.isFloatType(paramTypes[0]);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, m + " Leading float check failed because of type mismatches, for:" + m);
                    }
                }
                if (this.tIndex >= 0) {
                    return m;
                }
                int last = paramTypes.length - 1;
                if (!CallTweenMethod.isFloatType(paramTypes[last]) && !CallTweenMethod.isDoubleType(paramTypes[last])) continue;
                int matches = 0;
                for (int i = 0; i < last; ++i) {
                    if (!paramTypes[i].isInstance(args[i])) continue;
                    ++matches;
                }
                if (matches == args.length) {
                    this.tIndex = last;
                    this.isFloat = CallTweenMethod.isFloatType(paramTypes[last]);
                    return m;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Trailing float check failed because of type mismatches, for:" + m);
            }
            if (type.getSuperclass() != null) {
                return this.findMethod(type.getSuperclass(), name, args);
            }
            return null;
        }

        @Override
        protected void doInterpolate(double t) {
            try {
                this.args[this.tIndex] = this.isFloat ? (Number)Float.valueOf((float)t) : (Number)t;
                this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error running method:" + this.method + " for object:" + this.target, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[method=" + this.method + ", parms=" + Arrays.asList(this.args) + "]";
        }
    }

    private static class CallMethod
    extends AbstractTween {
        private Object target;
        private Method method;
        private Object[] args;

        public CallMethod(Object target, String methodName, Object ... args) {
            super(0.0);
            if (target == null) {
                throw new IllegalArgumentException("Target cannot be null.");
            }
            this.target = target;
            this.args = args;
            this.method = args == null ? CallMethod.findMethod(target.getClass(), methodName, new Object[0]) : CallMethod.findMethod(target.getClass(), methodName, args);
            if (this.method == null) {
                throw new IllegalArgumentException("Method not found for:" + methodName + " on type:" + target.getClass());
            }
            this.method.setAccessible(true);
        }

        private static Method findMethod(Class type, String name, Object ... args) {
            for (Method m : type.getDeclaredMethods()) {
                Class<?>[] paramTypes;
                if (!Objects.equals(m.getName(), name) || (paramTypes = m.getParameterTypes()).length != args.length) continue;
                int matches = 0;
                for (int i = 0; i < args.length; ++i) {
                    if (!paramTypes[i].isInstance(args[i]) && !Primitives.wrap(paramTypes[i]).isInstance(args[i])) continue;
                    ++matches;
                }
                if (matches != args.length) continue;
                return m;
            }
            if (type.getSuperclass() != null) {
                return CallMethod.findMethod(type.getSuperclass(), name, args);
            }
            return null;
        }

        @Override
        protected void doInterpolate(double t) {
            try {
                this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error running method:" + this.method + " for object:" + this.target, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[method=" + this.method + ", parms=" + Arrays.asList(this.args) + "]";
        }
    }

    private static class Stretch
    implements Tween,
    ContainsTweens {
        private final Tween[] delegate = new Tween[1];
        private final double length;
        private final double scale;

        public Stretch(Tween delegate, double length) {
            this.delegate[0] = delegate;
            this.length = length;
            this.scale = length != 0.0 ? delegate.getLength() / length : 0.0;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public Tween[] getTweens() {
            return this.delegate;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            t = this.length > 0.0 ? (t *= this.scale) : this.length;
            return this.delegate[0].interpolate(t);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate[0] + ", length=" + this.length + "]";
        }
    }

    private static class Delay
    extends AbstractTween {
        public Delay(double length) {
            super(length);
        }

        @Override
        protected void doInterpolate(double t) {
        }
    }

    private static class Parallel
    implements Tween,
    ContainsTweens {
        private final Tween[] delegates;
        private final boolean[] done;
        private double length;
        private double lastTime;

        public Parallel(Tween ... delegates) {
            this.delegates = delegates;
            this.done = new boolean[delegates.length];
            for (Tween t : delegates) {
                if (!(t.getLength() > this.length)) continue;
                this.length = t.getLength();
            }
        }

        @Override
        public double getLength() {
            return this.length;
        }

        protected void reset() {
            for (int i = 0; i < this.done.length; ++i) {
                this.done[i] = false;
            }
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (t < this.lastTime) {
                this.reset();
            }
            this.lastTime = t;
            int runningCount = this.delegates.length;
            for (int i = 0; i < this.delegates.length; ++i) {
                if (!this.done[i]) {
                    boolean bl = this.done[i] = !this.delegates[i].interpolate(t);
                }
                if (!this.done[i]) continue;
                --runningCount;
            }
            return runningCount > 0;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegates=" + Arrays.asList(this.delegates) + "]";
        }

        @Override
        public Tween[] getTweens() {
            return this.delegates;
        }
    }

    private static class Sequence
    implements Tween,
    ContainsTweens {
        private final Tween[] delegates;
        private int current = 0;
        private double baseTime;
        private double length;

        public Sequence(Tween ... delegates) {
            this.delegates = delegates;
            for (Tween t : delegates) {
                this.length += t.getLength();
            }
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (t < this.baseTime) {
                this.current = 0;
                this.baseTime = 0.0;
            }
            if (this.current >= this.delegates.length) {
                return false;
            }
            while (!this.delegates[this.current].interpolate(t - this.baseTime)) {
                this.baseTime += this.delegates[this.current].getLength();
                ++this.current;
                if (this.current < this.delegates.length) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegates=" + Arrays.asList(this.delegates) + "]";
        }

        @Override
        public Tween[] getTweens() {
            return this.delegates;
        }
    }

    private static class Curve
    implements Tween {
        private final Tween delegate;
        private final CurveFunction func;
        private final double length;

        public Curve(Tween delegate, CurveFunction func) {
            this.delegate = delegate;
            this.func = func;
            this.length = delegate.getLength();
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (this.length == 0.0) {
                return this.delegate.interpolate(t);
            }
            t = this.func.curve(t / this.length);
            return this.delegate.interpolate(t * this.length);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate + ", func=" + this.func + "]";
        }
    }

    private static class Sine
    implements CurveFunction {
        private Sine() {
        }

        @Override
        public double curve(double t) {
            if (t < 0.0) {
                return 0.0;
            }
            if (t > 1.0) {
                return 1.0;
            }
            double result = Math.sin(t * Math.PI - 1.5707963267948966);
            return (result + 1.0) * 0.5;
        }
    }

    private static class SmoothStep
    implements CurveFunction {
        private SmoothStep() {
        }

        @Override
        public double curve(double t) {
            if (t < 0.0) {
                return 0.0;
            }
            if (t > 1.0) {
                return 1.0;
            }
            return t * t * (3.0 - 2.0 * t);
        }
    }

    private static interface CurveFunction {
        public double curve(double var1);
    }
}

