/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimTrack;
import com.jme3.anim.interpolator.FrameInterpolator;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Geometry;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class MorphTrack
implements AnimTrack<float[]> {
    private double length;
    private Geometry target;
    private float[] weights;
    private FrameInterpolator interpolator = FrameInterpolator.DEFAULT;
    private float[] times;
    private int nbMorphTargets;

    protected MorphTrack() {
    }

    public MorphTrack(Geometry target, float[] times, float[] weights, int nbMorphTargets) {
        this.target = target;
        this.nbMorphTargets = nbMorphTargets;
        this.setKeyframes(times, weights);
    }

    public float[] getWeights() {
        return this.weights;
    }

    public float[] getTimes() {
        return this.times;
    }

    public void setTimes(float[] times) {
        if (times.length == 0) {
            throw new RuntimeException("TransformTrack with no keyframes!");
        }
        this.times = times;
        this.length = times[times.length - 1] - times[0];
    }

    public void setKeyframes(float[] times, float[] weights) {
        this.setTimes(times);
        if (weights != null) {
            if (times == null) {
                throw new RuntimeException("MorphTrack doesn't have any time for key frames, please call setTimes first");
            }
            this.weights = weights;
            assert (times.length == weights.length);
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void getDataAtTime(double t, float[] store) {
        float time = (float)t;
        int lastFrame = this.times.length - 1;
        if (time < 0.0f || lastFrame == 0) {
            if (this.weights != null) {
                System.arraycopy(this.weights, 0, store, 0, this.nbMorphTargets);
            }
            return;
        }
        int startFrame = 0;
        int endFrame = 1;
        float blend = 0.0f;
        if (time >= this.times[lastFrame]) {
            startFrame = lastFrame;
            time = time - this.times[startFrame] + this.times[startFrame - 1];
            blend = (time - this.times[startFrame - 1]) / (this.times[startFrame] - this.times[startFrame - 1]);
        } else {
            for (int i = 0; i < lastFrame && this.times[i] < time; ++i) {
                startFrame = i;
                endFrame = i + 1;
            }
            blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
        }
        this.interpolator.interpolateWeights(blend, startFrame, this.weights, this.nbMorphTargets, store);
    }

    public void setFrameInterpolator(FrameInterpolator interpolator) {
        this.interpolator = interpolator;
    }

    public Geometry getTarget() {
        return this.target;
    }

    public void setTarget(Geometry target) {
        this.target = target;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.weights, "weights", (float[])null);
        oc.write(this.times, "times", (float[])null);
        oc.write(this.target, "target", null);
        oc.write(this.nbMorphTargets, "nbMorphTargets", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.weights = ic.readFloatArray("weights", null);
        this.times = ic.readFloatArray("times", null);
        this.target = (Geometry)ic.readSavable("target", null);
        this.nbMorphTargets = ic.readInt("nbMorphTargets", 0);
        this.setTimes(this.times);
    }

    @Override
    public Object jmeClone() {
        try {
            MorphTrack clone = (MorphTrack)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.target = cloner.clone(this.target);
    }
}

