/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.tween.Tweens;
import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BaseAction;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.anim.tween.action.BlendSpace;
import com.jme3.anim.tween.action.BlendableAction;
import com.jme3.anim.tween.action.ClipAction;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AnimComposer
extends AbstractControl {
    public static final String DEFAULT_LAYER = "Default";
    private Map<String, AnimClip> animClipMap = new HashMap<String, AnimClip>();
    private Map<String, Action> actions = new HashMap<String, Action>();
    private float globalSpeed = 1.0f;
    private Map<String, Layer> layers = new LinkedHashMap<String, Layer>();

    public AnimComposer() {
        this.layers.put(DEFAULT_LAYER, new Layer(this));
    }

    public boolean hasAnimClip(String name) {
        return this.animClipMap.containsKey(name);
    }

    public AnimClip getAnimClip(String name) {
        return this.animClipMap.get(name);
    }

    public void addAnimClip(AnimClip anim) {
        this.animClipMap.put(anim.getName(), anim);
    }

    public void removeAnimClip(AnimClip anim) {
        if (!this.animClipMap.containsKey(anim.getName())) {
            throw new IllegalArgumentException("Given animation does not exist in this AnimControl");
        }
        this.animClipMap.remove(anim.getName());
    }

    public Action setCurrentAction(String name) {
        return this.setCurrentAction(name, DEFAULT_LAYER);
    }

    public Action setCurrentAction(String actionName, String layerName) {
        Layer l = this.layers.get(layerName);
        if (l == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        Action currentAction = this.action(actionName);
        l.time = 0.0;
        l.currentAction = currentAction;
        return currentAction;
    }

    public Action getCurrentAction() {
        return this.getCurrentAction(DEFAULT_LAYER);
    }

    public Action getCurrentAction(String layerName) {
        Layer l = this.layers.get(layerName);
        if (l == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        return l.currentAction;
    }

    public void removeCurrentAction() {
        this.removeCurrentAction(DEFAULT_LAYER);
    }

    public void removeCurrentAction(String layerName) {
        Layer l = this.layers.get(layerName);
        if (l == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        l.time = 0.0;
        l.currentAction = null;
    }

    public double getTime() {
        return this.getTime(DEFAULT_LAYER);
    }

    public double getTime(String layerName) {
        Layer l = this.layers.get(layerName);
        if (l == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        return l.time;
    }

    public void setTime(double time) {
        this.setTime(DEFAULT_LAYER, time);
    }

    public void setTime(String layerName, double time) {
        Layer l = this.layers.get(layerName);
        if (l == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        if (l.currentAction == null) {
            throw new RuntimeException("There is no action running in layer " + layerName);
        }
        double length = l.currentAction.getLength();
        if (time >= 0.0) {
            l.time = time % length;
        } else {
            l.time = time % length + length;
        }
    }

    public Action action(String name) {
        Action action = this.actions.get(name);
        if (action == null) {
            action = this.makeAction(name);
            this.actions.put(name, action);
        }
        return action;
    }

    public Action getAction(String name) {
        return this.actions.get(name);
    }

    public void addAction(String name, Action action) {
        this.actions.put(name, action);
    }

    public Action makeAction(String name) {
        AnimClip clip = this.animClipMap.get(name);
        if (clip == null) {
            throw new IllegalArgumentException("Cannot find clip named " + name);
        }
        ClipAction action = new ClipAction(clip);
        return action;
    }

    public boolean hasAction(String name) {
        return this.actions.containsKey(name);
    }

    public Action removeAction(String name) {
        return this.actions.remove(name);
    }

    public void makeLayer(String name, AnimationMask mask) {
        Layer l = new Layer(this);
        l.mask = mask;
        this.layers.put(name, l);
    }

    public void removeLayer(String name) {
        this.layers.remove(name);
    }

    public BaseAction actionSequence(String name, Tween ... tweens) {
        BaseAction action = new BaseAction(Tweens.sequence(tweens));
        this.actions.put(name, action);
        return action;
    }

    public BlendAction actionBlended(String name, BlendSpace blendSpace, String ... clips) {
        BlendableAction[] acts = new BlendableAction[clips.length];
        for (int i = 0; i < acts.length; ++i) {
            BlendableAction ba;
            acts[i] = ba = (BlendableAction)this.makeAction(clips[i]);
        }
        BlendAction action = new BlendAction(blendSpace, acts);
        this.actions.put(name, action);
        return action;
    }

    public void reset() {
        for (Layer layer : this.layers.values()) {
            layer.currentAction = null;
            layer.time = 0.0;
        }
    }

    public Collection<AnimClip> getAnimClips() {
        return Collections.unmodifiableCollection(this.animClipMap.values());
    }

    public Set<String> getAnimClipsNames() {
        return Collections.unmodifiableSet(this.animClipMap.keySet());
    }

    @Override
    protected void controlUpdate(float tpf) {
        for (Layer layer : this.layers.values()) {
            Action currentAction = layer.currentAction;
            if (currentAction == null) continue;
            layer.advance(tpf);
            currentAction.setMask(layer.mask);
            boolean running = currentAction.interpolate(layer.time);
            currentAction.setMask(null);
            if (running) continue;
            layer.time = 0.0;
        }
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public float getGlobalSpeed() {
        return this.globalSpeed;
    }

    public void setGlobalSpeed(float globalSpeed) {
        this.globalSpeed = globalSpeed;
    }

    public Object getLayerManager(String layerName) {
        Layer layer = this.layers.get(layerName);
        if (layer == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        return layer.manager;
    }

    public void setLayerManager(String layerName, Object manager) {
        Layer layer = this.layers.get(layerName);
        if (layer == null) {
            throw new IllegalArgumentException("Unknown layer " + layerName);
        }
        layer.manager = manager;
    }

    @Override
    public Object jmeClone() {
        try {
            AnimComposer clone = (AnimComposer)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        HashMap<String, AnimClip> clips = new HashMap<String, AnimClip>();
        for (String string : this.animClipMap.keySet()) {
            clips.put(string, cloner.clone(this.animClipMap.get(string)));
        }
        HashMap<String, Action> act = new HashMap<String, Action>();
        for (String key : this.actions.keySet()) {
            act.put(key, cloner.clone(this.actions.get(key)));
        }
        this.actions = act;
        this.animClipMap = clips;
        LinkedHashMap<String, Layer> linkedHashMap = new LinkedHashMap<String, Layer>();
        for (String key : this.layers.keySet()) {
            linkedHashMap.put(key, cloner.clone(this.layers.get(key)));
        }
        this.layers = linkedHashMap;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.animClipMap = ic.readStringSavableMap("animClipMap", new HashMap());
        this.globalSpeed = ic.readFloat("globalSpeed", 1.0f);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeStringSavableMap(this.animClipMap, "animClipMap", new HashMap());
        oc.write(this.globalSpeed, "globalSpeed", 1.0f);
    }

    private static class Layer
    implements JmeCloneable {
        private AnimComposer ac;
        private Action currentAction;
        private AnimationMask mask;
        private double time;
        private Object manager;

        public Layer(AnimComposer ac) {
            this.ac = ac;
        }

        public void advance(float tpf) {
            this.time += (double)tpf * this.currentAction.getSpeed() * (double)this.ac.globalSpeed;
            if (this.time < 0.0) {
                double length = this.currentAction.getLength();
                this.time = (this.time % length + length) % length;
            }
        }

        @Override
        public Object jmeClone() {
            try {
                Layer clone = (Layer)super.clone();
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError();
            }
        }

        @Override
        public void cloneFields(Cloner cloner, Object original) {
            this.ac = cloner.clone(this.ac);
            this.currentAction = null;
        }
    }
}

