/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.shadow.PssmShadowUtil;
import com.jme3.shadow.ShadowUtil;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class PssmShadowRenderer
implements SceneProcessor {
    protected int nbSplits = 3;
    protected float shadowMapSize;
    protected float lambda = 0.65f;
    protected float shadowIntensity = 0.7f;
    protected float zFarOverride = 0.0f;
    protected RenderManager renderManager;
    protected ViewPort viewPort;
    protected FrameBuffer[] shadowFB;
    protected Texture2D[] shadowMaps;
    protected Texture2D dummyTex;
    protected Camera shadowCam;
    protected Material preshadowMat;
    protected Material postshadowMat;
    protected GeometryList splitOccluders = new GeometryList(new OpaqueComparator());
    protected Matrix4f[] lightViewProjectionsMatrices;
    protected ColorRGBA splits;
    protected float[] splitsArray;
    protected boolean noOccluders = false;
    protected Vector3f direction = new Vector3f();
    protected AssetManager assetManager;
    protected boolean debug = false;
    protected float edgesThickness = 1.0f;
    protected FilterMode filterMode;
    protected CompareMode compareMode;
    protected Picture[] dispPic;
    protected Vector3f[] points = new Vector3f[8];
    protected boolean flushQueues = true;
    protected boolean needsfallBackMaterial = false;
    protected String postTechniqueName = "PostShadow";
    protected boolean applyHWShadows = true;
    protected boolean applyFilterMode = true;
    protected boolean applyPCFEdge = true;
    protected boolean applyShadowIntensity = true;
    protected List<Material> matCache = new ArrayList<Material>();
    protected Vector2f fadeInfo;
    protected float fadeLength;
    protected boolean applyFadeInfo = false;
    protected GeometryList lightReceivers = new GeometryList(new OpaqueComparator());
    boolean debugfrustums = false;

    public PssmShadowRenderer(AssetManager manager, int size, int nbSplits) {
        this(manager, size, nbSplits, new Material(manager, "Common/MatDefs/Shadow/PostShadow.j3md"));
    }

    protected PssmShadowRenderer(AssetManager manager, int size, int nbSplits, Material postShadowMat) {
        int i;
        this.postshadowMat = postShadowMat;
        this.assetManager = manager;
        this.nbSplits = nbSplits = Math.max(Math.min(nbSplits, 4), 1);
        this.shadowMapSize = size;
        this.shadowFB = new FrameBuffer[nbSplits];
        this.shadowMaps = new Texture2D[nbSplits];
        this.dispPic = new Picture[nbSplits];
        this.lightViewProjectionsMatrices = new Matrix4f[nbSplits];
        this.splits = new ColorRGBA();
        this.splitsArray = new float[nbSplits + 1];
        this.dummyTex = new Texture2D(size, size, Image.Format.RGBA8);
        this.preshadowMat = new Material(manager, "Common/MatDefs/Shadow/PreShadow.j3md");
        this.postshadowMat.setFloat("ShadowMapSize", size);
        for (i = 0; i < nbSplits; ++i) {
            this.lightViewProjectionsMatrices[i] = new Matrix4f();
            this.shadowFB[i] = new FrameBuffer(size, size, 1);
            this.shadowMaps[i] = new Texture2D(size, size, Image.Format.Depth);
            this.shadowFB[i].setDepthTexture(this.shadowMaps[i]);
            this.shadowFB[i].setColorTexture(this.dummyTex);
            this.postshadowMat.setTexture("ShadowMap" + i, this.shadowMaps[i]);
            this.dispPic[i] = new Picture("Picture" + i);
            this.dispPic[i].setTexture(manager, this.shadowMaps[i], false);
        }
        this.setCompareMode(CompareMode.Hardware);
        this.setFilterMode(FilterMode.Bilinear);
        this.setShadowIntensity(0.7f);
        this.shadowCam = new Camera(size, size);
        this.shadowCam.setParallelProjection(true);
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public final void setFilterMode(FilterMode filterMode) {
        if (filterMode == null) {
            throw new NullPointerException();
        }
        if (this.filterMode == filterMode) {
            return;
        }
        this.filterMode = filterMode;
        this.postshadowMat.setInt("FilterMode", filterMode.ordinal());
        this.postshadowMat.setFloat("PCFEdge", this.edgesThickness);
        if (this.compareMode == CompareMode.Hardware) {
            for (Texture2D shadowMap : this.shadowMaps) {
                if (filterMode == FilterMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
            }
        }
        this.applyFilterMode = true;
    }

    public final void setCompareMode(CompareMode compareMode) {
        if (compareMode == null) {
            throw new NullPointerException();
        }
        if (this.compareMode == compareMode) {
            return;
        }
        this.compareMode = compareMode;
        for (Texture2D shadowMap : this.shadowMaps) {
            if (compareMode == CompareMode.Hardware) {
                shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.LessOrEqual);
                if (this.filterMode == FilterMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
                continue;
            }
            shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.Off);
            shadowMap.setMagFilter(Texture.MagFilter.Nearest);
            shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
        this.postshadowMat.setBoolean("HardwareShadows", compareMode == CompareMode.Hardware);
        this.applyHWShadows = true;
    }

    private Geometry createFrustum(Vector3f[] pts, int i) {
        WireFrustum frustum = new WireFrustum(pts);
        Geometry frustumMdl = new Geometry("f", frustum);
        frustumMdl.setCullHint(Spatial.CullHint.Never);
        frustumMdl.setShadowMode(RenderQueue.ShadowMode.Off);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        frustumMdl.setMaterial(mat);
        switch (i) {
            case 0: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Pink);
                break;
            }
            case 1: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Red);
                break;
            }
            case 2: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Green);
                break;
            }
            case 3: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Blue);
                break;
            }
            default: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.White);
            }
        }
        frustumMdl.updateGeometricState();
        return frustumMdl;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
        this.postTechniqueName = "PostShadow";
    }

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set(direction).normalizeLocal();
    }

    @Override
    public void postQueue(RenderQueue rq) {
        for (Spatial scene : this.viewPort.getScenes()) {
            ShadowUtil.getGeometriesInCamFrustum(scene, this.viewPort.getCamera(), RenderQueue.ShadowMode.Receive, this.lightReceivers);
        }
        Camera viewCam = this.viewPort.getCamera();
        float zFar = this.zFarOverride;
        if (zFar == 0.0f) {
            zFar = viewCam.getFrustumFar();
        }
        float frustumNear = Math.max(viewCam.getFrustumNear(), 0.001f);
        ShadowUtil.updateFrustumPoints(viewCam, frustumNear, zFar, 1.0f, this.points);
        this.shadowCam.getRotation().lookAt(this.direction, this.shadowCam.getUp());
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
        PssmShadowUtil.updateFrustumSplits(this.splitsArray, frustumNear, zFar, this.lambda);
        switch (this.splitsArray.length) {
            case 5: {
                this.splits.a = this.splitsArray[4];
            }
            case 4: {
                this.splits.b = this.splitsArray[3];
            }
            case 3: {
                this.splits.g = this.splitsArray[2];
            }
            case 1: 
            case 2: {
                this.splits.r = this.splitsArray[1];
            }
        }
        Renderer r = this.renderManager.getRenderer();
        this.renderManager.setForcedMaterial(this.preshadowMat);
        this.renderManager.setForcedTechnique("PreShadow");
        for (int i = 0; i < this.nbSplits; ++i) {
            ShadowUtil.updateFrustumPoints(viewCam, this.splitsArray[i], this.splitsArray[i + 1], 1.0f, this.points);
            ShadowUtil.updateShadowCamera(this.viewPort, this.lightReceivers, this.shadowCam, this.points, this.splitOccluders, this.shadowMapSize);
            this.lightViewProjectionsMatrices[i].set(this.shadowCam.getViewProjectionMatrix());
            this.renderManager.setCamera(this.shadowCam, false);
            if (this.debugfrustums) {
                ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(this.points, i));
                ShadowUtil.updateFrustumPoints2(this.shadowCam, this.points);
                ((Node)this.viewPort.getScenes().get(0)).attachChild(this.createFrustum(this.points, i));
            }
            r.setFrameBuffer(this.shadowFB[i]);
            r.clearBuffers(true, true, true);
            this.viewPort.getQueue().renderShadowQueue(this.splitOccluders, this.renderManager, this.shadowCam, true);
        }
        this.debugfrustums = false;
        r.setFrameBuffer(this.viewPort.getOutputFrameBuffer());
        this.renderManager.setForcedMaterial(null);
        this.renderManager.setForcedTechnique(null);
        this.renderManager.setCamera(viewCam, false);
    }

    public void displayFrustum() {
        this.debugfrustums = true;
    }

    protected void displayShadowMap(Renderer r) {
        Camera cam = this.viewPort.getCamera();
        this.renderManager.setCamera(cam, true);
        int h = cam.getHeight();
        for (int i = 0; i < this.dispPic.length; ++i) {
            this.dispPic[i].setPosition(128 * i + (150 + 64 * (i + 1)), (float)h / 20.0f);
            this.dispPic[i].setWidth(128.0f);
            this.dispPic[i].setHeight(128.0f);
            this.dispPic[i].updateGeometricState();
            this.renderManager.renderGeometry(this.dispPic[i]);
        }
        this.renderManager.setCamera(cam, false);
    }

    public void displayDebug() {
        this.debug = true;
    }

    @Override
    public void postFrame(FrameBuffer out) {
        if (this.debug) {
            this.displayShadowMap(this.renderManager.getRenderer());
        }
        if (!this.noOccluders) {
            this.setMatParams();
            Camera cam = this.viewPort.getCamera();
            if (this.needsfallBackMaterial) {
                this.renderManager.setForcedMaterial(this.postshadowMat);
            }
            this.renderManager.setForcedTechnique(this.postTechniqueName);
            this.viewPort.getQueue().renderShadowQueue(this.lightReceivers, this.renderManager, cam, true);
            this.renderManager.setForcedTechnique(null);
            this.renderManager.setForcedMaterial(null);
            this.renderManager.setCamera(cam, false);
        }
    }

    private void setMatParams() {
        GeometryList l = this.lightReceivers;
        this.matCache.clear();
        for (int i = 0; i < l.size(); ++i) {
            Material mat = l.get(i).getMaterial();
            if (mat.getMaterialDef().getTechniqueDefs(this.postTechniqueName) != null) {
                if (this.matCache.contains(mat)) continue;
                this.matCache.add(mat);
                continue;
            }
            this.needsfallBackMaterial = true;
        }
        for (Material mat : this.matCache) {
            int j;
            mat.setColor("Splits", this.splits);
            mat.setFloat("ShadowMapSize", this.shadowMapSize);
            for (j = 0; j < this.nbSplits; ++j) {
                mat.setMatrix4("LightViewProjectionMatrix" + j, this.lightViewProjectionsMatrices[j]);
            }
            for (j = 0; j < this.nbSplits; ++j) {
                mat.setTexture("ShadowMap" + j, this.shadowMaps[j]);
            }
            mat.setBoolean("HardwareShadows", this.compareMode == CompareMode.Hardware);
            mat.setInt("FilterMode", this.filterMode.ordinal());
            mat.setFloat("PCFEdge", this.edgesThickness);
            mat.setFloat("ShadowIntensity", this.shadowIntensity);
            if (this.fadeInfo == null) continue;
            mat.setVector2("FadeInfo", this.fadeInfo);
        }
        this.applyHWShadows = false;
        this.applyFilterMode = false;
        this.applyPCFEdge = false;
        this.applyShadowIntensity = false;
        this.applyFadeInfo = false;
        if (this.needsfallBackMaterial) {
            this.setPostShadowParams();
        }
    }

    protected void setPostShadowParams() {
        this.postshadowMat.setColor("Splits", this.splits);
        for (int j = 0; j < this.nbSplits; ++j) {
            this.postshadowMat.setMatrix4("LightViewProjectionMatrix" + j, this.lightViewProjectionsMatrices[j]);
            this.postshadowMat.setTexture("ShadowMap" + j, this.shadowMaps[j]);
        }
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
    }

    public float getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
    }

    public float getShadowZExtend() {
        return this.zFarOverride;
    }

    public void setShadowZExtend(float zFar) {
        if (this.fadeInfo != null) {
            this.fadeInfo.set(zFar - this.fadeLength, 1.0f / this.fadeLength);
        }
        this.zFarOverride = zFar;
    }

    public float getShadowIntensity() {
        return this.shadowIntensity;
    }

    public final void setShadowIntensity(float shadowIntensity) {
        this.shadowIntensity = shadowIntensity;
        this.postshadowMat.setFloat("ShadowIntensity", shadowIntensity);
        this.applyShadowIntensity = true;
    }

    public int getEdgesThickness() {
        return (int)(this.edgesThickness * 10.0f);
    }

    public void setEdgesThickness(int edgesThickness) {
        this.edgesThickness = Math.max(1, Math.min(edgesThickness, 10));
        this.edgesThickness *= 0.1f;
        this.postshadowMat.setFloat("PCFEdge", edgesThickness);
        this.applyPCFEdge = true;
    }

    public boolean isFlushQueues() {
        return this.flushQueues;
    }

    public void setFlushQueues(boolean flushQueues) {
        this.flushQueues = flushQueues;
    }

    public void setShadowZFadeLength(float length) {
        if (length == 0.0f) {
            this.fadeInfo = null;
            this.fadeLength = 0.0f;
            this.postshadowMat.clearParam("FadeInfo");
        } else {
            this.fadeInfo = this.zFarOverride == 0.0f ? new Vector2f(0.0f, 0.0f) : new Vector2f(this.zFarOverride - length, 1.0f / length);
            this.fadeLength = length;
            this.postshadowMat.setVector2("FadeInfo", this.fadeInfo);
        }
    }

    public float getShadowZFadeLength() {
        if (this.fadeInfo != null) {
            return this.zFarOverride - this.fadeInfo.x;
        }
        return 0.0f;
    }

    @Deprecated
    public static enum CompareMode {
        Software,
        Hardware;

    }

    @Deprecated
    public static enum FilterMode {
        Nearest,
        Bilinear,
        Dither,
        PCF4,
        PCFPOISSON,
        PCF8;

    }
}

