/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class ShaderNodeVariable
implements Savable,
Cloneable {
    private String name;
    private String type;
    private String nameSpace;
    private String condition;
    private boolean shaderOutput = false;
    private String multiplicity;

    public ShaderNodeVariable(String type, String name) {
        this.name = name;
        this.type = type;
    }

    public ShaderNodeVariable(String type, String nameSpace, String name, String multiplicity) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
        this.multiplicity = multiplicity;
    }

    public ShaderNodeVariable(String type, String nameSpace, String name) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 29 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 29 * hash + (this.nameSpace != null ? this.nameSpace.hashCode() : 0);
        hash = 29 * hash + (this.condition != null ? this.condition.hashCode() : 0);
        hash = 29 * hash + (this.multiplicity != null ? this.multiplicity.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShaderNodeVariable other = (ShaderNodeVariable)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.nameSpace == null ? other.nameSpace != null : !this.nameSpace.equals(other.nameSpace)) {
            return false;
        }
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.multiplicity == null ? other.multiplicity != null : !this.multiplicity.equals(other.multiplicity));
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", "");
        oc.write(this.type, "type", "");
        oc.write(this.nameSpace, "nameSpace", "");
        oc.write(this.condition, "condition", null);
        oc.write(this.shaderOutput, "shaderOutput", false);
        oc.write(this.multiplicity, "multiplicity", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", "");
        this.type = ic.readString("type", "");
        this.nameSpace = ic.readString("nameSpace", "");
        this.condition = ic.readString("condition", null);
        this.shaderOutput = ic.readBoolean("shaderOutput", false);
        this.multiplicity = ic.readString("multiplicity", null);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String toString() {
        return "\n" + this.type + ' ' + (this.nameSpace != null ? this.nameSpace + '.' : "") + this.name;
    }

    public ShaderNodeVariable clone() {
        return new ShaderNodeVariable(this.type, this.nameSpace, this.name);
    }

    public boolean isShaderOutput() {
        return this.shaderOutput;
    }

    public void setShaderOutput(boolean shaderOutput) {
        this.shaderOutput = shaderOutput;
    }

    public String getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(String multiplicity) {
        this.multiplicity = multiplicity;
    }
}

