/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetManager;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.shader.Glsl100ShaderGenerator;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNodeVariable;

public class Glsl150ShaderGenerator
extends Glsl100ShaderGenerator {
    public Glsl150ShaderGenerator(AssetManager assetManager) {
        super(assetManager);
    }

    @Override
    protected String getLanguageAndVersion(Shader.ShaderType type) {
        return "GLSL150";
    }

    @Override
    protected void declareAttribute(StringBuilder source, ShaderNodeVariable var) {
        this.declareVariable(source, var, false, "in");
    }

    @Override
    protected void declareVarying(StringBuilder source, ShaderNodeVariable var, boolean input) {
        this.declareVariable(source, var, true, input ? "in" : "out");
    }

    @Override
    protected void generateStartOfMainSection(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        source.append("\n");
        if (type == Shader.ShaderType.Fragment) {
            for (ShaderNodeVariable global : info.getFragmentGlobals()) {
                this.declareVariable(source, global, null, true, "out");
            }
        }
        source.append("\n");
        this.appendIndent(source);
        source.append("void main(){\n");
        this.indent();
        if (type == Shader.ShaderType.Vertex) {
            this.declareGlobalPosition(info, source);
        } else if (type == Shader.ShaderType.Fragment) {
            for (ShaderNodeVariable global : info.getFragmentGlobals()) {
                this.initVariable(source, global, "vec4(1.0)");
            }
        }
    }

    @Override
    protected void generateEndOfMainSection(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        if (type == Shader.ShaderType.Vertex) {
            this.appendOutput(source, "gl_Position", info.getVertexGlobal());
        }
        this.unIndent();
        this.appendIndent(source);
        source.append("}\n");
    }

    protected void initVariable(StringBuilder source, ShaderNodeVariable var, String initValue) {
        this.appendIndent(source);
        source.append(var.getNameSpace());
        source.append("_");
        source.append(var.getName());
        source.append(" = ");
        source.append(initValue);
        source.append(";\n");
    }
}

