/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.shader.VarType;
import java.util.Arrays;
import java.util.List;

public final class DefineList {
    public static final int MAX_DEFINES = 64;
    private long hash;
    private final int[] vals;

    public DefineList(int numValues) {
        if (numValues < 0 || numValues > 64) {
            throw new IllegalArgumentException("numValues must be between 0 and 64");
        }
        this.vals = new int[numValues];
    }

    private DefineList(DefineList original) {
        this.hash = original.hash;
        this.vals = new int[original.vals.length];
        System.arraycopy(original.vals, 0, this.vals, 0, this.vals.length);
    }

    public void set(int id, int val) {
        assert (0 <= id && id < 64);
        this.hash = val != 0 ? (this.hash |= 1L << id) : (this.hash &= 1L << id ^ 0xFFFFFFFFFFFFFFFFL);
        this.vals[id] = val;
    }

    public void set(int id, float val) {
        this.set(id, Float.floatToIntBits(val));
    }

    public void set(int id, boolean val) {
        this.set(id, val ? 1 : 0);
    }

    public void set(int id, VarType type, Object value) {
        if (value == null) {
            this.set(id, 0);
            return;
        }
        switch (type) {
            case Int: {
                this.set(id, (Integer)value);
                break;
            }
            case Float: {
                this.set(id, ((Float)value).floatValue());
                break;
            }
            case Boolean: {
                this.set(id, (Boolean)value);
                break;
            }
            default: {
                this.set(id, 1);
            }
        }
    }

    public void setAll(DefineList other) {
        for (int i = 0; i < other.vals.length; ++i) {
            if (other.vals[i] == 0) continue;
            this.vals[i] = other.vals[i];
        }
    }

    public void clear() {
        this.hash = 0L;
        Arrays.fill(this.vals, 0);
    }

    public boolean getBoolean(int id) {
        return this.vals[id] != 0;
    }

    public float getFloat(int id) {
        return Float.intBitsToFloat(this.vals[id]);
    }

    public int getInt(int id) {
        return this.vals[id];
    }

    public int hashCode() {
        return (int)(this.hash >> 32 ^ this.hash);
    }

    public boolean equals(Object other) {
        DefineList o = (DefineList)other;
        if (this.hash == o.hash) {
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == o.vals[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public DefineList deepClone() {
        return new DefineList(this);
    }

    public void generateSource(StringBuilder sb, List<String> defineNames, List<VarType> defineTypes) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i] == 0) continue;
            String defineName = defineNames.get(i);
            sb.append("#define ");
            sb.append(defineName);
            sb.append(" ");
            if (defineTypes != null && defineTypes.get(i) == VarType.Float) {
                float val = Float.intBitsToFloat(this.vals[i]);
                if (Float.isInfinite(val) || Float.isNaN(val)) {
                    throw new IllegalArgumentException("GLSL does not support NaN or Infinite float literals");
                }
                sb.append(val);
            } else {
                sb.append(this.vals[i]);
            }
            sb.append("\n");
        }
    }

    public String generateSource(List<String> defineNames, List<VarType> defineTypes) {
        StringBuilder sb = new StringBuilder();
        this.generateSource(sb, defineNames, defineTypes);
        return sb.toString();
    }
}

