/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.instancing;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.instancing.InstancedNode;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public class InstancedGeometry
extends Geometry {
    private static final int INSTANCE_SIZE = 16;
    private VertexBuffer[] globalInstanceData;
    private VertexBuffer transformInstanceData;
    private Geometry[] geometries = new Geometry[1];
    private int firstUnusedIndex = 0;

    public InstancedGeometry() {
        this.setIgnoreTransform(true);
        this.setBatchHint(Spatial.BatchHint.Never);
        this.setMaxNumInstances(1);
    }

    public InstancedGeometry(String name) {
        super(name);
        this.setIgnoreTransform(true);
        this.setBatchHint(Spatial.BatchHint.Never);
        this.setMaxNumInstances(1);
    }

    public VertexBuffer[] getGlobalUserInstanceData() {
        return this.globalInstanceData;
    }

    public void setGlobalUserInstanceData(VertexBuffer[] globalInstanceData) {
        this.globalInstanceData = globalInstanceData;
    }

    public void setTransformUserInstanceData(VertexBuffer transformInstanceData) {
        this.transformInstanceData = transformInstanceData;
    }

    public VertexBuffer getTransformUserInstanceData() {
        return this.transformInstanceData;
    }

    private void updateInstance(Matrix4f worldMatrix, float[] store, int offset, Matrix3f tempMat3, Quaternion tempQuat) {
        worldMatrix.toRotationMatrix(tempMat3);
        tempMat3.invertLocal();
        tempQuat.fromRotationMatrix(tempMat3);
        store[offset + 0] = worldMatrix.m00;
        store[offset + 1] = worldMatrix.m10;
        store[offset + 2] = worldMatrix.m20;
        store[offset + 3] = tempQuat.getX();
        store[offset + 4] = worldMatrix.m01;
        store[offset + 5] = worldMatrix.m11;
        store[offset + 6] = worldMatrix.m21;
        store[offset + 7] = tempQuat.getY();
        store[offset + 8] = worldMatrix.m02;
        store[offset + 9] = worldMatrix.m12;
        store[offset + 10] = worldMatrix.m22;
        store[offset + 11] = tempQuat.getZ();
        store[offset + 12] = worldMatrix.m03;
        store[offset + 13] = worldMatrix.m13;
        store[offset + 14] = worldMatrix.m23;
        store[offset + 15] = tempQuat.getW();
    }

    public final void setMaxNumInstances(int maxNumInstances) {
        if (maxNumInstances < 1) {
            throw new IllegalArgumentException("maxNumInstances must be 1 or higher");
        }
        Geometry[] originalGeometries = this.geometries;
        this.geometries = new Geometry[maxNumInstances];
        if (originalGeometries != null) {
            System.arraycopy(originalGeometries, 0, this.geometries, 0, originalGeometries.length);
        }
        if (this.transformInstanceData != null) {
            BufferUtils.destroyDirectBuffer(this.transformInstanceData.getData());
            this.transformInstanceData.updateData(BufferUtils.createFloatBuffer(this.geometries.length * 16));
        } else if (this.transformInstanceData == null) {
            this.transformInstanceData = new VertexBuffer(VertexBuffer.Type.InstanceData);
            this.transformInstanceData.setInstanced(true);
            this.transformInstanceData.setupData(VertexBuffer.Usage.Stream, 16, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(this.geometries.length * 16));
        }
    }

    public int getMaxNumInstances() {
        return this.geometries.length;
    }

    public int getActualNumInstances() {
        return this.firstUnusedIndex;
    }

    private void swap(int idx1, int idx2) {
        Geometry g = this.geometries[idx1];
        this.geometries[idx1] = this.geometries[idx2];
        this.geometries[idx2] = g;
        if (this.geometries[idx1] != null) {
            InstancedNode.setGeometryStartIndex2(this.geometries[idx1], idx1);
        }
        if (this.geometries[idx2] != null) {
            InstancedNode.setGeometryStartIndex2(this.geometries[idx2], idx2);
        }
    }

    private void sanitize(boolean insideEntriesNonNull) {
        if (this.firstUnusedIndex >= this.geometries.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (i < this.firstUnusedIndex ? (this.geometries[i] == null ? insideEntriesNonNull : InstancedNode.getGeometryStartIndex2(this.geometries[i]) != i) : this.geometries[i] != null) {
                throw new AssertionError();
            }
        }
    }

    public void updateInstances() {
        FloatBuffer fb = (FloatBuffer)this.transformInstanceData.getData();
        fb.limit(fb.capacity());
        fb.position(0);
        TempVars vars = TempVars.get();
        float[] temp = vars.matrixWrite;
        for (int i = 0; i < this.firstUnusedIndex; ++i) {
            Geometry geom = this.geometries[i];
            if (geom == null) {
                geom = this.geometries[this.firstUnusedIndex - 1];
                if (geom == null) {
                    throw new AssertionError();
                }
                this.swap(i, this.firstUnusedIndex - 1);
                while (this.geometries[this.firstUnusedIndex - 1] == null) {
                    --this.firstUnusedIndex;
                }
            }
            Matrix4f worldMatrix = geom.getWorldMatrix();
            this.updateInstance(worldMatrix, temp, 0, vars.tempMat3, vars.quat1);
            fb.put(temp);
        }
        vars.release();
        fb.flip();
        if (fb.limit() / 16 != this.firstUnusedIndex) {
            throw new AssertionError();
        }
        this.transformInstanceData.updateData(fb);
    }

    public void deleteInstance(Geometry geom) {
        int idx = InstancedNode.getGeometryStartIndex2(geom);
        InstancedNode.setGeometryStartIndex2(geom, -1);
        this.geometries[idx] = null;
        if (idx == this.firstUnusedIndex - 1) {
            --this.firstUnusedIndex;
            while (this.geometries[this.firstUnusedIndex] == null) {
                --this.firstUnusedIndex;
                if (this.firstUnusedIndex >= 0) continue;
            }
            ++this.firstUnusedIndex;
        }
    }

    public void addInstance(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("geometry cannot be null");
        }
        if (this.firstUnusedIndex + 1 >= this.geometries.length) {
            this.setMaxNumInstances(this.getMaxNumInstances() * 2);
        }
        int freeIndex = this.firstUnusedIndex++;
        this.geometries[freeIndex] = geometry;
        InstancedNode.setGeometryStartIndex2(geometry, freeIndex);
    }

    public Geometry[] getGeometries() {
        return this.geometries;
    }

    public VertexBuffer[] getAllInstanceData() {
        ArrayList<VertexBuffer> allData = new ArrayList<VertexBuffer>();
        if (this.transformInstanceData != null) {
            allData.add(this.transformInstanceData);
        }
        if (this.globalInstanceData != null) {
            allData.addAll(Arrays.asList(this.globalInstanceData));
        }
        return allData.toArray(new VertexBuffer[allData.size()]);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.globalInstanceData = cloner.clone(this.globalInstanceData);
        this.transformInstanceData = cloner.clone(this.transformInstanceData);
        this.geometries = cloner.clone(this.geometries);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule(this);
        capsule.write(this.geometries, "geometries", null);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        Savable[] geometrySavables = capsule.readSavableArray("geometries", null);
        this.geometries = new Geometry[geometrySavables.length];
        for (int i = 0; i < geometrySavables.length; ++i) {
            this.geometries[i] = (Geometry)geometrySavables[i];
        }
    }
}

