/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;

public class PreDepthProcessor
implements SceneProcessor {
    private RenderManager rm;
    private ViewPort vp;
    private AssetManager assetManager;
    private Material preDepth;
    private RenderState forcedRS;

    public PreDepthProcessor(AssetManager assetManager) {
        this.assetManager = assetManager;
        this.preDepth = new Material(assetManager, "Common/MatDefs/Shadow/PreShadow.j3md");
        this.preDepth.getAdditionalRenderState().setPolyOffset(0.0f, 0.0f);
        this.preDepth.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Back);
        this.forcedRS = new RenderState();
        this.forcedRS.setDepthTest(true);
        this.forcedRS.setDepthWrite(false);
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.rm = rm;
        this.vp = vp;
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
        this.vp = vp;
    }

    @Override
    public boolean isInitialized() {
        return this.vp != null;
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
        this.rm.setForcedMaterial(this.preDepth);
        rq.renderQueue(RenderQueue.Bucket.Opaque, this.rm, this.vp.getCamera(), false);
        this.rm.setForcedMaterial(null);
        this.rm.setForcedRenderState(this.forcedRS);
    }

    @Override
    public void postFrame(FrameBuffer out) {
        this.rm.setForcedRenderState(null);
    }

    @Override
    public void cleanup() {
        this.vp = null;
    }
}

