/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.logic;

import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import java.util.ArrayList;
import java.util.EnumSet;

public final class StaticPassLightingLogic
extends DefaultTechniqueDefLogic {
    private static final String DEFINE_NUM_DIR_LIGHTS = "NUM_DIR_LIGHTS";
    private static final String DEFINE_NUM_POINT_LIGHTS = "NUM_POINT_LIGHTS";
    private static final String DEFINE_NUM_SPOT_LIGHTS = "NUM_SPOT_LIGHTS";
    private final int numDirLightsDefineId;
    private final int numPointLightsDefineId;
    private final int numSpotLightsDefineId;
    private final ArrayList<DirectionalLight> tempDirLights = new ArrayList();
    private final ArrayList<PointLight> tempPointLights = new ArrayList();
    private final ArrayList<SpotLight> tempSpotLights = new ArrayList();
    private final ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f tempPosition = new Vector3f();
    private final Vector3f tempDirection = new Vector3f();

    public StaticPassLightingLogic(TechniqueDef techniqueDef) {
        super(techniqueDef);
        this.numDirLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NUM_DIR_LIGHTS, VarType.Int);
        this.numPointLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NUM_POINT_LIGHTS, VarType.Int);
        this.numSpotLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NUM_SPOT_LIGHTS, VarType.Int);
    }

    @Override
    public Shader makeCurrent(AssetManager assetManager, RenderManager renderManager, EnumSet<Caps> rendererCaps, LightList lights, DefineList defines) {
        this.tempDirLights.clear();
        this.tempPointLights.clear();
        this.tempSpotLights.clear();
        for (Light light : lights) {
            switch (light.getType()) {
                case Directional: {
                    this.tempDirLights.add((DirectionalLight)light);
                    break;
                }
                case Point: {
                    this.tempPointLights.add((PointLight)light);
                    break;
                }
                case Spot: {
                    this.tempSpotLights.add((SpotLight)light);
                }
            }
        }
        defines.set(this.numDirLightsDefineId, this.tempDirLights.size());
        defines.set(this.numPointLightsDefineId, this.tempPointLights.size());
        defines.set(this.numSpotLightsDefineId, this.tempSpotLights.size());
        return this.techniqueDef.getShader(assetManager, rendererCaps, defines);
    }

    private void transformDirection(Matrix4f viewMatrix, Vector3f direction) {
        viewMatrix.multNormal(direction, direction);
    }

    private void transformPosition(Matrix4f viewMatrix, Vector3f location) {
        viewMatrix.mult(location, location);
    }

    private void updateLightListUniforms(Matrix4f viewMatrix, Shader shader, LightList lights) {
        ColorRGBA color;
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        ambientColor.setValue(VarType.Vector4, StaticPassLightingLogic.getAmbientColor(lights, true, this.ambientLightColor));
        Uniform lightData = shader.getUniform("g_LightData");
        int totalSize = this.tempDirLights.size() * 2 + this.tempPointLights.size() * 2 + this.tempSpotLights.size() * 3;
        lightData.setVector4Length(totalSize);
        int index = 0;
        for (DirectionalLight directionalLight : this.tempDirLights) {
            color = directionalLight.getColor();
            this.tempDirection.set(directionalLight.getDirection());
            this.transformDirection(viewMatrix, this.tempDirection);
            lightData.setVector4InArray(color.r, color.g, color.b, 1.0f, index++);
            lightData.setVector4InArray(this.tempDirection.x, this.tempDirection.y, this.tempDirection.z, 1.0f, index++);
        }
        for (PointLight pointLight : this.tempPointLights) {
            color = pointLight.getColor();
            this.tempPosition.set(pointLight.getPosition());
            float invRadius = pointLight.getInvRadius();
            this.transformPosition(viewMatrix, this.tempPosition);
            lightData.setVector4InArray(color.r, color.g, color.b, 1.0f, index++);
            lightData.setVector4InArray(this.tempPosition.x, this.tempPosition.y, this.tempPosition.z, invRadius, index++);
        }
        for (SpotLight spotLight : this.tempSpotLights) {
            color = spotLight.getColor();
            Vector3f pos = spotLight.getPosition();
            Vector3f dir = spotLight.getDirection();
            this.tempPosition.set(spotLight.getPosition());
            this.tempDirection.set(spotLight.getDirection());
            this.transformPosition(viewMatrix, this.tempPosition);
            this.transformDirection(viewMatrix, this.tempDirection);
            float invRange = spotLight.getInvSpotRange();
            float spotAngleCos = spotLight.getPackedAngleCos();
            lightData.setVector4InArray(color.r, color.g, color.b, 1.0f, index++);
            lightData.setVector4InArray(this.tempPosition.x, this.tempPosition.y, this.tempPosition.z, invRange, index++);
            lightData.setVector4InArray(this.tempDirection.x, this.tempDirection.y, this.tempDirection.z, spotAngleCos, index++);
        }
    }

    @Override
    public void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights) {
        Renderer renderer = renderManager.getRenderer();
        Matrix4f viewMatrix = renderManager.getCurrentCamera().getViewMatrix();
        this.updateLightListUniforms(viewMatrix, shader, lights);
        renderer.setShader(shader);
        StaticPassLightingLogic.renderMeshFromGeometry(renderer, geometry);
    }
}

