/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.logic;

import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.RenderState;
import com.jme3.material.TechniqueDef;
import com.jme3.material.logic.DefaultTechniqueDefLogic;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.scene.Geometry;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.shader.VarType;
import com.jme3.util.TempVars;
import java.util.EnumSet;

public final class SinglePassLightingLogic
extends DefaultTechniqueDefLogic {
    private static final String DEFINE_SINGLE_PASS_LIGHTING = "SINGLE_PASS_LIGHTING";
    private static final String DEFINE_NB_LIGHTS = "NB_LIGHTS";
    private static final RenderState ADDITIVE_LIGHT = new RenderState();
    private final ColorRGBA ambientLightColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private final int singlePassLightingDefineId;
    private final int nbLightsDefineId;

    public SinglePassLightingLogic(TechniqueDef techniqueDef) {
        super(techniqueDef);
        this.singlePassLightingDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_SINGLE_PASS_LIGHTING, VarType.Boolean);
        this.nbLightsDefineId = techniqueDef.addShaderUnmappedDefine(DEFINE_NB_LIGHTS, VarType.Int);
    }

    @Override
    public Shader makeCurrent(AssetManager assetManager, RenderManager renderManager, EnumSet<Caps> rendererCaps, LightList lights, DefineList defines) {
        defines.set(this.nbLightsDefineId, renderManager.getSinglePassLightBatchSize() * 3);
        defines.set(this.singlePassLightingDefineId, true);
        return super.makeCurrent(assetManager, renderManager, rendererCaps, lights, defines);
    }

    protected int updateLightListUniforms(Shader shader, Geometry g, LightList lightList, int numLights, RenderManager rm, int startIndex) {
        int curIndex;
        if (numLights == 0) {
            return 0;
        }
        Uniform lightData = shader.getUniform("g_LightData");
        lightData.setVector4Length(numLights * 3);
        Uniform ambientColor = shader.getUniform("g_AmbientLightColor");
        if (startIndex != 0) {
            rm.getRenderer().applyRenderState(ADDITIVE_LIGHT);
            ambientColor.setValue(VarType.Vector4, ColorRGBA.Black);
        } else {
            ambientColor.setValue(VarType.Vector4, SinglePassLightingLogic.getAmbientColor(lightList, true, this.ambientLightColor));
        }
        int lightDataIndex = 0;
        TempVars vars = TempVars.get();
        Vector4f tmpVec = vars.vect4f1;
        int endIndex = numLights + startIndex;
        block5: for (curIndex = startIndex; curIndex < endIndex && curIndex < lightList.size(); ++curIndex) {
            Light l = lightList.get(curIndex);
            if (l.getType() == Light.Type.Ambient) {
                ++endIndex;
                continue;
            }
            ColorRGBA color = l.getColor();
            lightData.setVector4InArray(color.getRed(), color.getGreen(), color.getBlue(), l.getType().getId(), lightDataIndex);
            ++lightDataIndex;
            switch (l.getType()) {
                case Directional: {
                    DirectionalLight dl = (DirectionalLight)l;
                    Vector3f dir = dl.getDirection();
                    tmpVec.set(dir.getX(), dir.getY(), dir.getZ(), 0.0f);
                    rm.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), -1.0f, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Point: {
                    PointLight pl = (PointLight)l;
                    Vector3f pos = pl.getPosition();
                    float invRadius = pl.getInvRadius();
                    tmpVec.set(pos.getX(), pos.getY(), pos.getZ(), 1.0f);
                    rm.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRadius, lightDataIndex);
                    lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, ++lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                case Spot: {
                    SpotLight sl = (SpotLight)l;
                    Vector3f pos2 = sl.getPosition();
                    Vector3f dir2 = sl.getDirection();
                    float invRange = sl.getInvSpotRange();
                    float spotAngleCos = sl.getPackedAngleCos();
                    tmpVec.set(pos2.getX(), pos2.getY(), pos2.getZ(), 1.0f);
                    rm.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), invRange, lightDataIndex);
                    ++lightDataIndex;
                    tmpVec.set(dir2.getX(), dir2.getY(), dir2.getZ(), 0.0f);
                    rm.getCurrentCamera().getViewMatrix().mult(tmpVec, tmpVec);
                    tmpVec.normalizeLocal();
                    lightData.setVector4InArray(tmpVec.getX(), tmpVec.getY(), tmpVec.getZ(), spotAngleCos, lightDataIndex);
                    ++lightDataIndex;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown type of light: " + (Object)((Object)l.getType()));
                }
            }
        }
        vars.release();
        while (lightDataIndex < numLights * 3) {
            lightData.setVector4InArray(0.0f, 0.0f, 0.0f, 0.0f, lightDataIndex);
            ++lightDataIndex;
        }
        return curIndex;
    }

    @Override
    public void render(RenderManager renderManager, Shader shader, Geometry geometry, LightList lights) {
        int nbRenderedLights = 0;
        Renderer renderer = renderManager.getRenderer();
        int batchSize = renderManager.getSinglePassLightBatchSize();
        if (lights.size() == 0) {
            this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, 0);
            renderer.setShader(shader);
            SinglePassLightingLogic.renderMeshFromGeometry(renderer, geometry);
        } else {
            while (nbRenderedLights < lights.size()) {
                nbRenderedLights = this.updateLightListUniforms(shader, geometry, lights, batchSize, renderManager, nbRenderedLights);
                renderer.setShader(shader);
                SinglePassLightingLogic.renderMeshFromGeometry(renderer, geometry);
            }
        }
    }

    static {
        ADDITIVE_LIGHT.setBlendMode(RenderState.BlendMode.AlphaAdditive);
        ADDITIVE_LIGHT.setDepthWrite(false);
    }
}

