/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.RenderState;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.logic.TechniqueDefLogic;
import com.jme3.renderer.Caps;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderGenerator;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public class TechniqueDef
implements Savable {
    public static final int SAVABLE_VERSION = 1;
    public static final String DEFAULT_TECHNIQUE_NAME = "Default";
    private final EnumSet<Caps> requiredCaps = EnumSet.noneOf(Caps.class);
    private String name;
    private int sortId;
    private EnumMap<Shader.ShaderType, String> shaderLanguages;
    private EnumMap<Shader.ShaderType, String> shaderNames;
    private String shaderPrologue;
    private ArrayList<String> defineNames;
    private ArrayList<VarType> defineTypes;
    private HashMap<String, Integer> paramToDefineId;
    private final HashMap<DefineList, Shader> definesToShaderMap;
    private boolean usesNodes = false;
    private List<ShaderNode> shaderNodes;
    private ShaderGenerationInfo shaderGenerationInfo;
    private boolean noRender = false;
    private RenderState renderState;
    private RenderState forcedRenderState;
    private LightMode lightMode = LightMode.Disable;
    private ShadowMode shadowMode = ShadowMode.Disable;
    private TechniqueDefLogic logic;
    private ArrayList<UniformBinding> worldBinds;

    public TechniqueDef(String name, int sortId) {
        this();
        this.sortId = sortId;
        this.name = name;
    }

    public TechniqueDef() {
        this.shaderLanguages = new EnumMap(Shader.ShaderType.class);
        this.shaderNames = new EnumMap(Shader.ShaderType.class);
        this.defineNames = new ArrayList();
        this.defineTypes = new ArrayList();
        this.paramToDefineId = new HashMap();
        this.definesToShaderMap = new HashMap();
    }

    public int getSortId() {
        return this.sortId;
    }

    public String getName() {
        return this.name;
    }

    public LightMode getLightMode() {
        return this.lightMode;
    }

    public void setLightMode(LightMode lightMode) {
        this.lightMode = lightMode;
    }

    public void setLogic(TechniqueDefLogic logic) {
        this.logic = logic;
    }

    public TechniqueDefLogic getLogic() {
        return this.logic;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public void setShadowMode(ShadowMode shadowMode) {
        this.shadowMode = shadowMode;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public void setRenderState(RenderState renderState) {
        this.renderState = renderState;
    }

    public void setNoRender(boolean noRender) {
        this.noRender = noRender;
    }

    public boolean isNoRender() {
        return this.noRender;
    }

    public boolean isUsingShaderNodes() {
        return this.usesNodes;
    }

    public EnumSet<Caps> getRequiredCaps() {
        return this.requiredCaps;
    }

    public void setShaderFile(String vertexShader, String fragmentShader, String vertLanguage, String fragLanguage) {
        this.shaderLanguages.put(Shader.ShaderType.Vertex, vertLanguage);
        this.shaderNames.put(Shader.ShaderType.Vertex, vertexShader);
        this.shaderLanguages.put(Shader.ShaderType.Fragment, fragLanguage);
        this.shaderNames.put(Shader.ShaderType.Fragment, fragmentShader);
        this.requiredCaps.clear();
        Caps vertCap = Caps.valueOf(vertLanguage);
        this.requiredCaps.add(vertCap);
        Caps fragCap = Caps.valueOf(fragLanguage);
        this.requiredCaps.add(fragCap);
    }

    public void setShaderPrologue(String shaderPrologue) {
        this.shaderPrologue = shaderPrologue;
    }

    public String getShaderPrologue() {
        return this.shaderPrologue;
    }

    public String getShaderParamDefine(String paramName) {
        Integer defineId = this.paramToDefineId.get(paramName);
        if (defineId != null) {
            return this.defineNames.get(defineId);
        }
        return null;
    }

    public Integer getShaderParamDefineId(String paramName) {
        return this.paramToDefineId.get(paramName);
    }

    public VarType getDefineIdType(int defineId) {
        return defineId < this.defineTypes.size() ? this.defineTypes.get(defineId) : null;
    }

    public void addShaderParamDefine(String paramName, VarType paramType, String defineName) {
        int defineId = this.defineNames.size();
        if (defineId >= 64) {
            throw new IllegalStateException("Cannot have more than 64 defines on a technique.");
        }
        this.paramToDefineId.put(paramName, defineId);
        this.defineNames.add(defineName);
        this.defineTypes.add(paramType);
    }

    public int addShaderUnmappedDefine(String defineName, VarType defineType) {
        int defineId = this.defineNames.size();
        if (defineId >= 64) {
            throw new IllegalStateException("Cannot have more than 64 defines on a technique.");
        }
        this.defineNames.add(defineName);
        this.defineTypes.add(defineType);
        return defineId;
    }

    public String[] getDefineNames() {
        return this.defineNames.toArray(new String[0]);
    }

    public VarType[] getDefineTypes() {
        return this.defineTypes.toArray(new VarType[0]);
    }

    public DefineList createDefineList() {
        return new DefineList(this.defineNames.size());
    }

    private Shader loadShader(AssetManager assetManager, EnumSet<Caps> rendererCaps, DefineList defines) {
        Shader shader;
        StringBuilder sb = new StringBuilder();
        sb.append(this.shaderPrologue);
        defines.generateSource(sb, this.defineNames, this.defineTypes);
        String definesSourceCode = sb.toString();
        if (this.isUsingShaderNodes()) {
            ShaderGenerator shaderGenerator = assetManager.getShaderGenerator(rendererCaps);
            if (shaderGenerator == null) {
                throw new UnsupportedOperationException("ShaderGenerator was not initialized, make sure assetManager.getGenerator(caps) has been called");
            }
            shaderGenerator.initialize(this);
            shader = shaderGenerator.generateShader(definesSourceCode);
        } else {
            shader = new Shader();
            for (Shader.ShaderType type : Shader.ShaderType.values()) {
                String language = this.shaderLanguages.get((Object)type);
                String shaderSourceAssetName = this.shaderNames.get((Object)type);
                if (language == null || shaderSourceAssetName == null) continue;
                String shaderSourceCode = (String)assetManager.loadAsset(shaderSourceAssetName);
                shader.addSource(type, shaderSourceAssetName, shaderSourceCode, definesSourceCode, language);
            }
        }
        if (this.getWorldBindings() != null) {
            for (UniformBinding binding : this.getWorldBindings()) {
                shader.addUniformBinding(binding);
            }
        }
        return shader;
    }

    public Shader getShader(AssetManager assetManager, EnumSet<Caps> rendererCaps, DefineList defines) {
        Shader shader = this.definesToShaderMap.get(defines);
        if (shader == null) {
            shader = this.loadShader(assetManager, rendererCaps, defines);
            this.definesToShaderMap.put(defines.deepClone(), shader);
        }
        return shader;
    }

    public void setShaderFile(EnumMap<Shader.ShaderType, String> shaderNames, EnumMap<Shader.ShaderType, String> shaderLanguages) {
        this.requiredCaps.clear();
        for (Shader.ShaderType shaderType : shaderNames.keySet()) {
            String language = shaderLanguages.get((Object)shaderType);
            String shaderFile = shaderNames.get((Object)shaderType);
            this.shaderLanguages.put(shaderType, language);
            this.shaderNames.put(shaderType, shaderFile);
            Caps vertCap = Caps.valueOf(language);
            this.requiredCaps.add(vertCap);
            if (shaderType.equals((Object)Shader.ShaderType.Geometry)) {
                this.requiredCaps.add(Caps.GeometryShader);
                continue;
            }
            if (!shaderType.equals((Object)Shader.ShaderType.TessellationControl)) continue;
            this.requiredCaps.add(Caps.TesselationShader);
        }
    }

    public String getFragmentShaderName() {
        return this.shaderNames.get((Object)Shader.ShaderType.Fragment);
    }

    public String getVertexShaderName() {
        return this.shaderNames.get((Object)Shader.ShaderType.Vertex);
    }

    public String getFragmentShaderLanguage() {
        return this.shaderLanguages.get((Object)Shader.ShaderType.Fragment);
    }

    public String getVertexShaderLanguage() {
        return this.shaderLanguages.get((Object)Shader.ShaderType.Vertex);
    }

    public String getShaderProgramLanguage(Shader.ShaderType shaderType) {
        return this.shaderLanguages.get((Object)shaderType);
    }

    public String getShaderProgramName(Shader.ShaderType shaderType) {
        return this.shaderNames.get((Object)shaderType);
    }

    public boolean addWorldParam(String name) {
        if (this.worldBinds == null) {
            this.worldBinds = new ArrayList();
        }
        try {
            this.worldBinds.add(UniformBinding.valueOf(name));
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public RenderState getForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setForcedRenderState(RenderState forcedRenderState) {
        this.forcedRenderState = forcedRenderState;
    }

    public List<UniformBinding> getWorldBindings() {
        return this.worldBinds;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Vertex), "vertName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Fragment), "fragName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.Geometry), "geomName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.TessellationControl), "tsctrlName", null);
        oc.write(this.shaderNames.get((Object)Shader.ShaderType.TessellationEvaluation), "tsevalName", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Vertex), "vertLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Fragment), "fragLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.Geometry), "geomLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.TessellationControl), "tsctrlLanguage", null);
        oc.write(this.shaderLanguages.get((Object)Shader.ShaderType.TessellationEvaluation), "tsevalLanguage", null);
        oc.write(this.shaderPrologue, "shaderPrologue", null);
        oc.write(this.lightMode, "lightMode", LightMode.Disable);
        oc.write(this.shadowMode, "shadowMode", ShadowMode.Disable);
        oc.write(this.renderState, "renderState", null);
        oc.write(this.noRender, "noRender", false);
        oc.write(this.usesNodes, "usesNodes", false);
        oc.writeSavableArrayList((ArrayList)this.shaderNodes, "shaderNodes", null);
        oc.write(this.shaderGenerationInfo, "shaderGenerationInfo", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.shaderNames.put(Shader.ShaderType.Vertex, ic.readString("vertName", null));
        this.shaderNames.put(Shader.ShaderType.Fragment, ic.readString("fragName", null));
        this.shaderNames.put(Shader.ShaderType.Geometry, ic.readString("geomName", null));
        this.shaderNames.put(Shader.ShaderType.TessellationControl, ic.readString("tsctrlName", null));
        this.shaderNames.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tsevalName", null));
        this.shaderPrologue = ic.readString("shaderPrologue", null);
        this.lightMode = ic.readEnum("lightMode", LightMode.class, LightMode.Disable);
        this.shadowMode = ic.readEnum("shadowMode", ShadowMode.class, ShadowMode.Disable);
        this.renderState = (RenderState)ic.readSavable("renderState", null);
        this.noRender = ic.readBoolean("noRender", false);
        if (ic.getSavableVersion(TechniqueDef.class) == 0) {
            this.shaderLanguages.put(Shader.ShaderType.Vertex, ic.readString("shaderLang", null));
            this.shaderLanguages.put(Shader.ShaderType.Fragment, this.shaderLanguages.get((Object)Shader.ShaderType.Vertex));
        } else {
            this.shaderLanguages.put(Shader.ShaderType.Vertex, ic.readString("vertLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.Fragment, ic.readString("fragLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.Geometry, ic.readString("geomLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.TessellationControl, ic.readString("tsctrlLanguage", null));
            this.shaderLanguages.put(Shader.ShaderType.TessellationEvaluation, ic.readString("tsevalLanguage", null));
        }
        this.usesNodes = ic.readBoolean("usesNodes", false);
        this.shaderNodes = ic.readSavableArrayList("shaderNodes", null);
        this.shaderGenerationInfo = (ShaderGenerationInfo)ic.readSavable("shaderGenerationInfo", null);
    }

    public List<ShaderNode> getShaderNodes() {
        return this.shaderNodes;
    }

    public void setShaderNodes(List<ShaderNode> shaderNodes) {
        this.shaderNodes = shaderNodes;
        this.usesNodes = true;
    }

    public EnumMap<Shader.ShaderType, String> getShaderProgramNames() {
        return this.shaderNames;
    }

    public EnumMap<Shader.ShaderType, String> getShaderProgramLanguages() {
        return this.shaderLanguages;
    }

    public ShaderGenerationInfo getShaderGenerationInfo() {
        return this.shaderGenerationInfo;
    }

    public void setShaderGenerationInfo(ShaderGenerationInfo shaderGenerationInfo) {
        this.shaderGenerationInfo = shaderGenerationInfo;
    }

    public String toString() {
        return "TechniqueDef[name=" + this.name + ", requiredCaps=" + this.requiredCaps + ", noRender=" + this.noRender + ", lightMode=" + (Object)((Object)this.lightMode) + ", usesNodes=" + this.usesNodes + ", renderState=" + this.renderState + ", forcedRenderState=" + this.forcedRenderState + "]";
    }

    public static enum ShadowMode {
        Disable,
        InPass,
        PostPass;

    }

    public static enum LightMode {
        Disable,
        SinglePass,
        MultiPass,
        FixedPipeline,
        StaticPass;

    }
}

