/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.AssetManager;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.VarType;
import com.jme3.texture.image.ColorSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialDef {
    private static final Logger logger = Logger.getLogger(MaterialDef.class.getName());
    private String name;
    private String assetName;
    private AssetManager assetManager;
    private Map<String, List<TechniqueDef>> techniques;
    private Map<String, MatParam> matParams;

    public MaterialDef() {
    }

    public MaterialDef(AssetManager assetManager, String name) {
        this.assetManager = assetManager;
        this.name = name;
        this.techniques = new HashMap<String, List<TechniqueDef>>();
        this.matParams = new HashMap<String, MatParam>();
        logger.log(Level.FINE, "Loaded material definition: {0}", name);
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public String getName() {
        return this.name;
    }

    public void addMaterialParam(VarType type, String name, Object value) {
        this.matParams.put(name, new MatParam(type, name, value));
    }

    public void addMaterialParamTexture(VarType type, String name, ColorSpace colorSpace) {
        this.matParams.put(name, new MatParamTexture(type, name, null, colorSpace));
    }

    public MatParam getMaterialParam(String name) {
        return this.matParams.get(name);
    }

    public Collection<MatParam> getMaterialParams() {
        return this.matParams.values();
    }

    public void addTechniqueDef(TechniqueDef technique) {
        List<TechniqueDef> list = this.techniques.get(technique.getName());
        if (list == null) {
            list = new ArrayList<TechniqueDef>();
            this.techniques.put(technique.getName(), list);
        }
        list.add(technique);
    }

    public List<TechniqueDef> getTechniqueDefs(String name) {
        return this.techniques.get(name);
    }
}

