/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.MatParam;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;

public class MatParamTexture
extends MatParam {
    private Texture texture;
    private ColorSpace colorSpace;

    public MatParamTexture(VarType type, String name, Texture texture, ColorSpace colorSpace) {
        super(type, name, texture);
        this.texture = texture;
        this.colorSpace = colorSpace;
    }

    public MatParamTexture() {
    }

    public Texture getTextureValue() {
        return this.texture;
    }

    public void setTextureValue(Texture value) {
        this.value = value;
        this.texture = value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Texture)) {
            throw new IllegalArgumentException("value must be a texture object");
        }
        this.value = value;
        this.texture = (Texture)value;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(0, "texture_unit", -1);
        oc.write(this.texture, "texture", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.texture = (Texture)this.value;
    }
}

