/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.renderer.RenderManager;
import com.jme3.util.SafeArrayList;
import java.util.Arrays;
import java.util.List;

public class AppStateManager {
    private final SafeArrayList<AppState> initializing = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> states = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> terminating = new SafeArrayList<AppState>(AppState.class);
    private final Application app;
    private AppState[] stateArray;

    public AppStateManager(Application app) {
        this.app = app;
    }

    public Application getApplication() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getInitializing() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.initializing.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getTerminating() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.terminating.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getStates() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            if (!this.states.contains(state) && !this.initializing.contains(state)) {
                state.stateAttached(this);
                this.initializing.add(state);
                return true;
            }
            return false;
        }
    }

    public void attachAll(AppState ... states) {
        this.attachAll(Arrays.asList(states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAll(Iterable<AppState> states) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            for (AppState state : states) {
                this.attach(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            if (this.states.contains(state)) {
                state.stateDetached(this);
                this.states.remove(state);
                this.terminating.add(state);
                return true;
            }
            if (this.initializing.contains(state)) {
                state.stateDetached(this);
                this.initializing.remove(state);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasState(AppState state) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.contains(state) || this.initializing.contains(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AppState> T getState(Class<T> stateClass) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            AppState[] array;
            for (AppState state : array = this.getStates()) {
                if (!stateClass.isAssignableFrom(state.getClass())) continue;
                return (T)state;
            }
            for (AppState state : array = this.getInitializing()) {
                if (!stateClass.isAssignableFrom(state.getClass())) continue;
                return (T)state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePending() {
        AppState[] array = this.getInitializing();
        if (array.length == 0) {
            return;
        }
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            List<AppState> transfer = Arrays.asList(array);
            this.states.addAll(transfer);
            this.initializing.removeAll(transfer);
        }
        for (AppState state : array) {
            state.initialize(this, this.app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminatePending() {
        AppState[] array = this.getTerminating();
        if (array.length == 0) {
            return;
        }
        for (AppState state : array) {
            state.cleanup();
        }
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            this.terminating.removeAll(Arrays.asList(array));
        }
    }

    public void update(float tpf) {
        AppState[] array;
        this.terminatePending();
        this.initializePending();
        for (AppState state : array = this.getStates()) {
            if (!state.isEnabled()) continue;
            state.update(tpf);
        }
    }

    public void render(RenderManager rm) {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            if (!state.isEnabled()) continue;
            state.render(rm);
        }
    }

    public void postRender() {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            if (!state.isEnabled()) continue;
            state.postRender();
        }
    }

    public void cleanup() {
        AppState[] array;
        for (AppState state : array = this.getStates()) {
            state.cleanup();
        }
    }
}

