/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppTask<V>
implements Future<V> {
    private static final Logger logger = Logger.getLogger(AppTask.class.getName());
    private final Callable<V> callable;
    private V result;
    private ExecutionException exception;
    private boolean cancelled;
    private boolean finished;
    private final ReentrantLock stateLock = new ReentrantLock();
    private final Condition finishedCondition = this.stateLock.newCondition();

    public AppTask(Callable<V> callable) {
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.stateLock.lock();
        try {
            if (this.result != null) {
                boolean bl = false;
                return bl;
            }
            this.cancelled = true;
            this.finishedCondition.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.stateLock.lock();
        try {
            while (!this.isDone()) {
                this.finishedCondition.await();
            }
            if (this.exception != null) {
                throw this.exception;
            }
            V v = this.result;
            return v;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.stateLock.lock();
        try {
            if (!this.isDone()) {
                this.finishedCondition.await(timeout, unit);
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.result == null) {
                throw new TimeoutException("Object not returned in time allocated.");
            }
            V v = this.result;
            return v;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this.stateLock.lock();
        try {
            boolean bl = this.cancelled;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        this.stateLock.lock();
        try {
            boolean bl = this.finished || this.cancelled || this.exception != null;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            V tmpResult = this.callable.call();
            this.stateLock.lock();
            try {
                this.result = tmpResult;
                this.finished = true;
                this.finishedCondition.signalAll();
            }
            finally {
                this.stateLock.unlock();
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "invoke()", "Exception", e);
            this.stateLock.lock();
            try {
                this.exception = new ExecutionException(e);
                this.finishedCondition.signalAll();
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }
}

