/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.BitSet;

public final class BoneTrack
implements Track {
    private int targetBoneIndex;
    private CompactVector3Array translations;
    private CompactQuaternionArray rotations;
    private CompactVector3Array scales;
    private float[] times;

    public BoneTrack() {
    }

    public BoneTrack(int targetBoneIndex, float[] times, Vector3f[] translations, Quaternion[] rotations) {
        this.targetBoneIndex = targetBoneIndex;
        this.setKeyframes(times, translations, rotations);
    }

    public BoneTrack(int targetBoneIndex, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.targetBoneIndex = targetBoneIndex;
        this.setKeyframes(times, translations, rotations, scales);
    }

    public BoneTrack(int targetBoneIndex) {
        this.targetBoneIndex = targetBoneIndex;
    }

    public int getTargetBoneIndex() {
        return this.targetBoneIndex;
    }

    public Quaternion[] getRotations() {
        return (Quaternion[])this.rotations.toObjectArray();
    }

    public Vector3f[] getScales() {
        return this.scales == null ? null : (Vector3f[])this.scales.toObjectArray();
    }

    public float[] getTimes() {
        return this.times;
    }

    public Vector3f[] getTranslations() {
        return (Vector3f[])this.translations.toObjectArray();
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations) {
        if (times.length == 0) {
            throw new RuntimeException("BoneTrack with no keyframes!");
        }
        assert (times.length == translations.length && times.length == rotations.length);
        this.times = times;
        this.translations = new CompactVector3Array();
        this.translations.add(translations);
        this.translations.freeze();
        this.rotations = new CompactQuaternionArray();
        this.rotations.add(rotations);
        this.rotations.freeze();
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.setKeyframes(times, translations, rotations);
        assert (times.length == scales.length);
        if (scales != null) {
            this.scales = new CompactVector3Array();
            this.scales.add(scales);
            this.scales.freeze();
        }
    }

    @Override
    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        BitSet affectedBones = channel.getAffectedBones();
        if (affectedBones != null && !affectedBones.get(this.targetBoneIndex)) {
            return;
        }
        Bone target = control.getSkeleton().getBone(this.targetBoneIndex);
        Vector3f tempV = vars.vect1;
        Vector3f tempS = vars.vect2;
        Quaternion tempQ = vars.quat1;
        Vector3f tempV2 = vars.vect3;
        Vector3f tempS2 = vars.vect4;
        Quaternion tempQ2 = vars.quat2;
        int lastFrame = this.times.length - 1;
        if (time < 0.0f || lastFrame == 0) {
            this.rotations.get(0, tempQ);
            this.translations.get(0, tempV);
            if (this.scales != null) {
                this.scales.get(0, tempS);
            }
        } else if (time >= this.times[lastFrame]) {
            this.rotations.get(lastFrame, tempQ);
            this.translations.get(lastFrame, tempV);
            if (this.scales != null) {
                this.scales.get(lastFrame, tempS);
            }
        } else {
            int startFrame = 0;
            int endFrame = 1;
            for (int i = 0; i < lastFrame && this.times[i] < time; ++i) {
                startFrame = i;
                endFrame = i + 1;
            }
            float blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
            this.rotations.get(startFrame, tempQ);
            this.translations.get(startFrame, tempV);
            if (this.scales != null) {
                this.scales.get(startFrame, tempS);
            }
            this.rotations.get(endFrame, tempQ2);
            this.translations.get(endFrame, tempV2);
            if (this.scales != null) {
                this.scales.get(endFrame, tempS2);
            }
            tempQ.nlerp(tempQ2, blend);
            tempV.interpolateLocal(tempV2, blend);
            tempS.interpolateLocal(tempS2, blend);
        }
        target.blendAnimTransforms(tempV, tempQ, this.scales != null ? tempS : null, weight);
    }

    @Override
    public float getLength() {
        return this.times == null ? 0.0f : this.times[this.times.length - 1] - this.times[0];
    }

    @Override
    public float[] getKeyFrameTimes() {
        return this.times;
    }

    @Override
    public BoneTrack clone() {
        int tablesLength = this.times.length;
        float[] times = (float[])this.times.clone();
        Vector3f[] sourceTranslations = this.getTranslations();
        Quaternion[] sourceRotations = this.getRotations();
        Vector3f[] sourceScales = this.getScales();
        Vector3f[] translations = new Vector3f[tablesLength];
        Quaternion[] rotations = new Quaternion[tablesLength];
        Vector3f[] scales = new Vector3f[tablesLength];
        for (int i = 0; i < tablesLength; ++i) {
            translations[i] = sourceTranslations[i].clone();
            rotations[i] = sourceRotations[i].clone();
            scales[i] = sourceScales != null ? sourceScales[i].clone() : new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return new BoneTrack(this.targetBoneIndex, times, translations, rotations, scales);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.targetBoneIndex, "boneIndex", 0);
        oc.write(this.translations, "translations", null);
        oc.write(this.rotations, "rotations", null);
        oc.write(this.times, "times", (float[])null);
        oc.write(this.scales, "scales", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.targetBoneIndex = ic.readInt("boneIndex", 0);
        this.translations = (CompactVector3Array)ic.readSavable("translations", null);
        this.rotations = (CompactQuaternionArray)ic.readSavable("rotations", null);
        this.times = ic.readFloatArray("times", null);
        this.scales = (CompactVector3Array)ic.readSavable("scales", null);
        if (im.getFormatVersion() == 0) {
            Savable[] sav;
            if (this.translations == null && (sav = ic.readSavableArray("translations", null)) != null) {
                this.translations = new CompactVector3Array();
                Vector3f[] transCopy = new Vector3f[sav.length];
                System.arraycopy(sav, 0, transCopy, 0, sav.length);
                this.translations.add(transCopy);
                this.translations.freeze();
            }
            if (this.rotations == null && (sav = ic.readSavableArray("rotations", null)) != null) {
                this.rotations = new CompactQuaternionArray();
                Quaternion[] rotCopy = new Quaternion[sav.length];
                System.arraycopy(sav, 0, rotCopy, 0, sav.length);
                this.rotations.add(rotCopy);
                this.rotations.freeze();
            }
        }
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

