/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.ClonableTrack;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class Animation
implements Savable,
Cloneable,
JmeCloneable {
    private String name;
    private float length;
    private SafeArrayList<Track> tracks = new SafeArrayList<Track>(Track.class);

    public Animation() {
    }

    public Animation(String name, float length) {
        this.name = name;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public float getLength() {
        return this.length;
    }

    void setTime(float time, float blendAmount, AnimControl control, AnimChannel channel, TempVars vars) {
        if (this.tracks == null) {
            return;
        }
        for (Track track : this.tracks) {
            track.setTime(time, blendAmount, control, channel, vars);
        }
    }

    public void setTracks(Track[] tracksArray) {
        for (Track track : tracksArray) {
            this.tracks.add(track);
        }
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
    }

    public void removeTrack(Track track) {
        this.tracks.remove(track);
        if (track instanceof ClonableTrack) {
            ((ClonableTrack)track).cleanUp();
        }
    }

    public Track[] getTracks() {
        return this.tracks.getArray();
    }

    public Animation clone() {
        try {
            Animation result = (Animation)super.clone();
            result.tracks = new SafeArrayList<Track>(Track.class);
            for (Track track : this.tracks) {
                result.tracks.add(track.clone());
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public Animation cloneForSpatial(Spatial spat) {
        try {
            Animation result = (Animation)super.clone();
            result.tracks = new SafeArrayList<Track>(Track.class);
            for (Track track : this.tracks) {
                if (track instanceof ClonableTrack) {
                    result.tracks.add(((ClonableTrack)track).cloneForSpatial(spat));
                    continue;
                }
                result.tracks.add(track);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        SafeArrayList<Track> newTracks = new SafeArrayList<Track>(Track.class);
        for (Track track : this.tracks) {
            if (track instanceof ClonableTrack) {
                newTracks.add(cloner.clone(track));
                continue;
            }
            newTracks.add(track);
        }
        this.tracks = newTracks;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ", length=" + this.length + ']';
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.name, "name", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.tracks.getArray(), "tracks", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.name = in.readString("name", null);
        this.length = in.readFloat("length", 0.0f);
        Savable[] arr = in.readSavableArray("tracks", null);
        if (arr != null) {
            this.tracks = new SafeArrayList<Track>(Track.class);
            for (Savable savable : arr) {
                this.tracks.add((Track)savable);
            }
        }
    }
}

