/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "polyDiscriminator", "", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "forceNull", "", "position", "", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "absenceIsNull", "descriptor", "index", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "coerceInputValue", "tag", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "decodeElementIndex", "decodeNotNullMark", "elementName", "desc", "endStructure", "", "kotlinx-serialization-json"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final String polyDiscriminator;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(@NotNull Json json, @NotNull JsonObject value, @Nullable String polyDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(json, value, null);
        this.value = value;
        this.polyDiscriminator = polyDiscriminator;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index, String tag) {
        void $this$tryCoerceValue_u24default$iv;
        void elementDescriptor$iv;
        Json json = this.getJson();
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) return false;
        String string = JsonElementKt.getContentOrNull(jsonPrimitive);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue_u24default$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        return true;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        while (this.position < descriptor2.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor2, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor2, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index, name)) continue;
            return index;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor descriptor2, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor2.isElementOptional(index) && descriptor2.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @NotNull
    protected String elementName(@NotNull SerialDescriptor desc, int index) {
        String nameInObject;
        String string;
        Object v1;
        String mainName;
        block4: {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            mainName = desc.getElementName(index);
            if (!this.configuration.getUseAlternativeNames()) {
                return mainName;
            }
            if (this.getValue().keySet().contains(mainName)) {
                return mainName;
            }
            Map<String, Integer> alternativeNamesMap2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).getOrPut(desc, JsonNamesMapKt.getJsonAlternativeNamesKey(), (Function0)new Function0<Map<String, ? extends Integer>>((Object)desc){

                @NotNull
                public final Map<String, Integer> invoke() {
                    return JsonNamesMapKt.buildAlternativeNamesMap((SerialDescriptor)this.receiver);
                }
            });
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = alternativeNamesMap2.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((string = (nameInObject = (String)v1)) == null) {
            string = mainName;
        }
        return string;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)tag);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 == this.polyDescriptor) {
            return this;
        }
        return super.beginStructure(descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor2.getKind() instanceof PolymorphicKind) {
            return;
        }
        if (!this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor2);
        } else {
            Set set2 = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor2);
            Map<String, Integer> map = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor2, JsonNamesMapKt.getJsonAlternativeNamesKey());
            Set set3 = map != null ? map.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus((Set)set2, (Iterable)set3);
        }
        Set names = set;
        for (String key : this.getValue().keySet()) {
            if (names.contains(key) || Intrinsics.areEqual((Object)key, (Object)this.polyDiscriminator)) continue;
            throw JsonExceptionsKt.UnknownKeyException(key, this.getValue().toString());
        }
    }
}

