/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.SerialReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0016J\b\u0010(\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/SerialReader;", "_source", "", "(Lkotlinx/serialization/json/internal/SerialReader;[C)V", "<set-?>", "", "source", "getSource", "()Ljava/lang/CharSequence;", "setSource", "(Ljava/lang/CharSequence;)V", "threshold", "", "appendRange", "", "fromIndex", "toIndex", "canConsumeValue", "", "consumeKeyString", "", "consumeLeadingMatchingValue", "keyToMatch", "isLenient", "consumeNextToken", "", "ensureHaveChars", "indexOf", "char", "", "startPos", "prefetchOrEof", "position", "preload", "spaceLeft", "substring", "endPos", "tryConsumeComma", "kotlinx-serialization-json"})
public final class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final SerialReader reader;
    @NotNull
    private char[] _source;
    private int threshold;
    @NotNull
    private CharSequence source;

    public ReaderJsonLexer(@NotNull SerialReader reader, @NotNull char[] _source) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)_source, (String)"_source");
        this.reader = reader;
        this._source = _source;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this._source);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(SerialReader serialReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = new char[16384];
        }
        this(serialReader, cArray);
    }

    @Override
    @NotNull
    protected CharSequence getSource() {
        return this.source;
    }

    public void setSource(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<set-?>");
        this.source = charSequence;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int spaceLeft) {
        int actual;
        char[] buffer = this._source;
        ArraysKt.copyInto((char[])buffer, (char[])buffer, (int)0, (int)this.currentPosition, (int)(this.currentPosition + spaceLeft));
        int sizeTotal = this._source.length;
        for (int read = spaceLeft; read != sizeTotal; read += actual) {
            actual = this.reader.read(buffer, read, sizeTotal - read);
            if (actual != -1) continue;
            char[] cArray = Arrays.copyOf(this._source, read);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOf(this, newSize)");
            this._source = cArray;
            this.setSource(new ArrayAsSequence(this._source));
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || this.getSource().length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void ensureHaveChars() {
        int oldSize = this._source.length;
        int cur = this.currentPosition;
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                this.fail$kotlinx_serialization_json((byte)1);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        char[] src = this._source;
        int n = src.length;
        for (int i = startPos; i < n; ++i) {
            if (src[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return StringsKt.concatToString((char[])this._source, (int)startPos, (int)endPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(this._source, fromIndex, toIndex - fromIndex), (String)"this.append(value, start\u2026x, endIndex - startIndex)");
    }

    @Override
    @Nullable
    public String consumeLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter((Object)keyToMatch, (String)"keyToMatch");
        return null;
    }
}

