/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/json/internal/StringJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "source", "", "(Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "canConsumeValue", "", "consumeKeyString", "consumeNextToken", "", "", "expected", "", "prefetchOrEof", "", "position", "skipWhitespaces", "tryConsumeComma", "kotlinx-serialization-json"})
public final class StringJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final String source;

    public StringJsonLexer(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    @NotNull
    protected String getSource() {
        return this.source;
    }

    @Override
    public int prefetchOrEof(int position) {
        return position < this.getSource().length() ? position : -1;
    }

    @Override
    public byte consumeNextToken() {
        String source = this.getSource();
        while (this.currentPosition != -1 && this.currentPosition < source.length()) {
            byte by = this.currentPosition;
            this.currentPosition = by + 1;
            char ch = source.charAt(by);
            if ((by = (byte)AbstractJsonLexerKt.charToTokenClass(ch)) == 3) continue;
            return by;
        }
        return 10;
    }

    @Override
    public boolean tryConsumeComma() {
        int current = this.skipWhitespaces();
        if (current == this.getSource().length() || current == -1) {
            return false;
        }
        if (this.getSource().charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.currentPosition;
        if (current == -1) {
            return false;
        }
        while (current < this.getSource().length()) {
            char c = this.getSource().charAt(current);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    @Override
    public int skipWhitespaces() {
        char c;
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        while (current < this.getSource().length() && ((c = this.getSource().charAt(current)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void consumeNextToken(char expected) {
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        String source = this.getSource();
        while (this.currentPosition < source.length()) {
            int n = this.currentPosition;
            this.currentPosition = n + 1;
            char c = source.charAt(n);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') continue;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.unexpectedToken(expected);
    }

    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = StringsKt.indexOf$default((CharSequence)this.getSource(), (char)'\"', (int)current, (boolean)false, (int)4, null);
        if (closingQuote == -1) {
            this.fail$kotlinx_serialization_json((byte)1);
            throw new KotlinNothingValueException();
        }
        int n = current;
        while (n < closingQuote) {
            int i = n++;
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        String string = this.getSource().substring(current, closingQuote);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }
}

