/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.streams;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractInput;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.pool.ObjectPool;
import kotlinx.io.streams.ByteArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lkotlinx/io/streams/InputStreamAsInput;", "Lkotlinx/io/core/AbstractInput;", "stream", "Ljava/io/InputStream;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Lkotlinx/io/core/IoBuffer;", "(Ljava/io/InputStream;Lkotlinx/io/pool/ObjectPool;)V", "closeSource", "", "fill", "kotlinx-io"})
public final class InputStreamAsInput
extends AbstractInput {
    private final InputStream stream;

    @Override
    @Nullable
    protected IoBuffer fill() {
        byte[] buffer = ByteArraysKt.getByteArrayPool().borrow();
        try {
            IoBuffer ioBuffer;
            int rc = this.stream.read(buffer, 0, 4096 - IoBuffer.Companion.getReservedSize());
            if (rc >= 0) {
                IoBuffer ioBuffer2 = this.getPool().borrow();
                boolean bl = false;
                boolean bl2 = false;
                IoBuffer it = ioBuffer2;
                boolean bl3 = false;
                it.reserveEndGap(IoBuffer.Companion.getReservedSize());
                it.writeFully(buffer, 0, rc);
                ioBuffer = ioBuffer2;
            } else {
                ioBuffer = null;
            }
            IoBuffer result = ioBuffer;
            ByteArraysKt.getByteArrayPool().recycle(buffer);
            return result;
        }
        catch (Throwable t) {
            ByteArraysKt.getByteArrayPool().recycle(buffer);
            throw t;
        }
    }

    @Override
    protected void closeSource() {
        this.stream.close();
    }

    public InputStreamAsInput(@NotNull InputStream stream, @NotNull ObjectPool<IoBuffer> pool) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        super(null, 0L, pool, 3, null);
        this.stream = stream;
    }
}

