/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.pool;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0016\u001a\u00020\u00122\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lkotlinx/io/pool/SingleInstancePool;", "T", "", "Lkotlinx/io/pool/ObjectPool;", "()V", "borrowed", "Lkotlinx/atomicfu/AtomicInt;", "capacity", "", "getCapacity", "()I", "disposed", "Lkotlinx/atomicfu/AtomicBoolean;", "instance", "Ljava/lang/Object;", "borrow", "()Ljava/lang/Object;", "dispose", "", "disposeInstance", "(Ljava/lang/Object;)V", "produceInstance", "recycle", "kotlinx-io"})
public abstract class SingleInstancePool<T>
implements ObjectPool<T> {
    private volatile int borrowed = 0;
    private static final AtomicIntegerFieldUpdater borrowed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "borrowed");
    private volatile int disposed = 0;
    private static final AtomicIntegerFieldUpdater disposed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "disposed");
    private volatile T instance;

    @NotNull
    protected abstract T produceInstance();

    protected abstract void disposeInstance(@NotNull T var1);

    @Override
    public final int getCapacity() {
        return 1;
    }

    @Override
    @NotNull
    public final T borrow() {
        int upd$iv;
        int cur$iv;
        SingleInstancePool $receiver$iv = this;
        boolean $i$f$update = false;
        do {
            int it = cur$iv = $receiver$iv.borrowed;
            boolean bl = false;
            if (it == 0) continue;
            throw (Throwable)new IllegalStateException("Instance is already consumed");
        } while (!borrowed$FU.compareAndSet($receiver$iv, cur$iv, upd$iv = 1));
        T instance = this.produceInstance();
        this.instance = instance;
        return instance;
    }

    @Override
    public final void recycle(@NotNull T instance) {
        Intrinsics.checkParameterIsNotNull(instance, (String)"instance");
        if (this.instance != instance) {
            if (this.instance == null && this.borrowed != 0) {
                throw (Throwable)new IllegalStateException("Already recycled or an irrelevant instance tried to be recycled");
            }
            throw (Throwable)new IllegalStateException("Unable to recycle irrelevant instance");
        }
        this.instance = null;
        if (!disposed$FU.compareAndSet(this, 0, 1)) {
            throw (Throwable)new IllegalStateException("An instance is already disposed");
        }
        this.disposeInstance(instance);
    }

    @Override
    public final void dispose() {
        if (disposed$FU.compareAndSet(this, 0, 1)) {
            T t = this.instance;
            if (t == null) {
                return;
            }
            T instance = t;
            this.instance = null;
            this.disposeInstance(instance);
        }
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }
}

