/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawProjectionComputer;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypesKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.LazyWrappedType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaTypeResolver {
    @NotNull
    private final LazyJavaResolverContext c;
    @NotNull
    private final TypeParameterResolver typeParameterResolver;
    @NotNull
    private final RawProjectionComputer projectionComputer;
    @NotNull
    private final TypeParameterUpperBoundEraser typeParameterUpperBoundEraser;

    public JavaTypeResolver(@NotNull LazyJavaResolverContext c, @NotNull TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)typeParameterResolver, (String)"typeParameterResolver");
        this.c = c;
        this.typeParameterResolver = typeParameterResolver;
        this.projectionComputer = new RawProjectionComputer();
        this.typeParameterUpperBoundEraser = new TypeParameterUpperBoundEraser(this.projectionComputer, null, 2, null);
    }

    @NotNull
    public final KotlinType transformJavaType(@Nullable JavaType javaType, @NotNull JavaTypeAttributes attr) {
        Object object;
        block5: {
            JavaType javaType2;
            block8: {
                block9: {
                    block7: {
                        block6: {
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
                                javaType2 = javaType;
                                if (!(javaType2 instanceof JavaPrimitiveType)) break block4;
                                PrimitiveType primitiveType = ((JavaPrimitiveType)javaType).getType();
                                SimpleType simpleType2 = primitiveType != null ? this.c.getModule().getBuiltIns().getPrimitiveKotlinType(primitiveType) : this.c.getModule().getBuiltIns().getUnitType();
                                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"{\n                val pr\u2026ns.unitType\n            }");
                                object = simpleType2;
                                break block5;
                            }
                            if (!(javaType2 instanceof JavaClassifierType)) break block6;
                            object = this.transformJavaClassifierType((JavaClassifierType)javaType, attr);
                            break block5;
                        }
                        if (!(javaType2 instanceof JavaArrayType)) break block7;
                        object = JavaTypeResolver.transformArrayType$default(this, (JavaArrayType)javaType, attr, false, 4, null);
                        break block5;
                    }
                    if (!(javaType2 instanceof JavaWildcardType)) break block8;
                    object = ((JavaWildcardType)javaType).getBound();
                    if (object == null) break block9;
                    Object it = object;
                    boolean bl = false;
                    KotlinType kotlinType = this.transformJavaType((JavaType)it, attr);
                    object = kotlinType;
                    if (kotlinType != null) break block5;
                }
                SimpleType simpleType3 = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"c.module.builtIns.defaultBound");
                object = simpleType3;
                break block5;
            }
            if (javaType2 == null) {
                SimpleType simpleType4 = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"c.module.builtIns.defaultBound");
                object = simpleType4;
            } else {
                throw new UnsupportedOperationException("Unsupported type: " + javaType);
            }
        }
        return object;
    }

    @NotNull
    public final KotlinType transformArrayType(@NotNull JavaArrayType arrayType, @NotNull JavaTypeAttributes attr, boolean isVararg) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        JavaType javaComponentType = arrayType.getComponentType();
        JavaPrimitiveType javaPrimitiveType = javaComponentType instanceof JavaPrimitiveType ? (JavaPrimitiveType)javaComponentType : null;
        PrimitiveType primitiveType = javaPrimitiveType != null ? javaPrimitiveType.getType() : null;
        LazyJavaAnnotations annotations2 = new LazyJavaAnnotations(this.c, arrayType, true);
        if (primitiveType != null) {
            SimpleType simpleType2 = this.c.getModule().getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"c.module.builtIns.getPri\u2026KotlinType(primitiveType)");
            SimpleType jetType = simpleType2;
            TypeUtilsKt.replaceAnnotations(jetType, Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Iterable)jetType.getAnnotations())));
            return attr.isForAnnotationParameter() ? (KotlinType)jetType : (KotlinType)KotlinTypeFactory.flexibleType(jetType, jetType.makeNullableAsSpecified(true));
        }
        KotlinType componentType = this.transformJavaType(javaComponentType, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, attr.isForAnnotationParameter(), false, null, 6, null));
        if (attr.isForAnnotationParameter()) {
            Variance projectionKind = isVararg ? Variance.OUT_VARIANCE : Variance.INVARIANT;
            SimpleType simpleType3 = this.c.getModule().getBuiltIns().getArrayType(projectionKind, componentType, annotations2);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"c.module.builtIns.getArr\u2026mponentType, annotations)");
            return simpleType3;
        }
        SimpleType simpleType4 = this.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, componentType, annotations2);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"c.module.builtIns.getArr\u2026mponentType, annotations)");
        return KotlinTypeFactory.flexibleType(simpleType4, this.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, componentType, annotations2).makeNullableAsSpecified(true));
    }

    public static /* synthetic */ KotlinType transformArrayType$default(JavaTypeResolver javaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    private final KotlinType transformJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr) {
        boolean useFlexible = !attr.isForAnnotationParameter() && attr.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
        boolean isRaw = javaType.isRaw();
        if (!isRaw && !useFlexible) {
            SimpleType simpleType2 = this.computeSimpleJavaClassifierType(javaType, attr, null);
            return simpleType2 != null ? (KotlinType)simpleType2 : (KotlinType)JavaTypeResolver.transformJavaClassifierType$errorType(javaType);
        }
        SimpleType simpleType3 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND), null);
        if (simpleType3 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaType);
        }
        SimpleType lower = simpleType3;
        SimpleType simpleType4 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND), lower);
        if (simpleType4 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaType);
        }
        SimpleType upper = simpleType4;
        return isRaw ? (KotlinType)new RawTypeImpl(lower, upper) : (KotlinType)KotlinTypeFactory.flexibleType(lower, upper);
    }

    private final SimpleType computeSimpleJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr, SimpleType lowerResult) {
        Object object = lowerResult;
        if (object == null || (object = ((KotlinType)object).getAttributes()) == null) {
            object = TypeAttributesKt.toDefaultAttributes(new LazyJavaAnnotations(this.c, javaType, false, 4, null));
        }
        Object attributes = object;
        TypeConstructor typeConstructor2 = this.computeTypeConstructor(javaType, attr);
        if (typeConstructor2 == null) {
            return null;
        }
        TypeConstructor constructor = typeConstructor2;
        boolean isNullable = this.isNullable(attr);
        SimpleType simpleType2 = lowerResult;
        if (Intrinsics.areEqual((Object)(simpleType2 != null ? simpleType2.getConstructor() : null), (Object)constructor) && !javaType.isRaw() && isNullable) {
            return lowerResult.makeNullableAsSpecified(true);
        }
        List<TypeProjection> arguments2 = this.computeArguments(javaType, attr, constructor);
        return KotlinTypeFactory.simpleType$default((TypeAttributes)attributes, constructor, arguments2, isNullable, null, 16, null);
    }

    private final TypeConstructor computeTypeConstructor(JavaClassifierType javaType, JavaTypeAttributes attr) {
        Object object;
        JavaClassifier javaClassifier = javaType.getClassifier();
        if (javaClassifier == null) {
            return this.createNotFoundClass(javaType);
        }
        JavaClassifier classifier2 = javaClassifier;
        JavaClassifier javaClassifier2 = classifier2;
        if (javaClassifier2 instanceof JavaClass) {
            ClassDescriptor classData;
            FqName $this$sure$iv = ((JavaClass)classifier2).getFqName();
            boolean $i$f$sure = false;
            FqName fqName2 = $this$sure$iv;
            if (fqName2 == null) {
                boolean bl = false;
                String string = "Class type should have a FQ name: " + classifier2;
                throw new AssertionError((Object)string);
            }
            FqName fqName3 = fqName2;
            ClassDescriptor classDescriptor = this.mapKotlinClass(javaType, attr, fqName3);
            if (classDescriptor == null) {
                classDescriptor = this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)classifier2);
            }
            if ((object = (classData = classDescriptor)) == null || (object = object.getTypeConstructor()) == null) {
                object = this.createNotFoundClass(javaType);
            }
        } else if (javaClassifier2 instanceof JavaTypeParameter) {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)classifier2);
            object = typeParameterDescriptor != null ? typeParameterDescriptor.getTypeConstructor() : null;
        } else {
            throw new IllegalStateException("Unknown classifier kind: " + classifier2);
        }
        return object;
    }

    private final TypeConstructor createNotFoundClass(JavaClassifierType javaType) {
        ClassId classId = ClassId.topLevel(new FqName(javaType.getClassifierQualifiedName()));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(javaType.classifierQualifiedName))");
        ClassId classId2 = classId;
        TypeConstructor typeConstructor2 = this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses().getClass(classId2, CollectionsKt.listOf((Object)0)).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"c.components.deserialize\u2026istOf(0)).typeConstructor");
        return typeConstructor2;
    }

    private final ClassDescriptor mapKotlinClass(JavaClassifierType javaType, JavaTypeAttributes attr, FqName fqName2) {
        if (attr.isForAnnotationParameter() && Intrinsics.areEqual((Object)fqName2, (Object)JavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p())) {
            return this.c.getComponents().getReflectionTypes().getKClass();
        }
        JavaToKotlinClassMapper javaToKotlin = JavaToKotlinClassMapper.INSTANCE;
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(javaToKotlin, fqName2, this.c.getModule().getBuiltIns(), null, 4, null);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor kotlinDescriptor = classDescriptor;
        if (javaToKotlin.isReadOnly(kotlinDescriptor) && (attr.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND || attr.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE || this.argumentsMakeSenseOnlyForMutableContainer(javaType, kotlinDescriptor))) {
            return javaToKotlin.convertReadOnlyToMutable(kotlinDescriptor);
        }
        return kotlinDescriptor;
    }

    private final boolean argumentsMakeSenseOnlyForMutableContainer(JavaClassifierType $this$argumentsMakeSenseOnlyForMutableContainer, ClassDescriptor readOnlyContainer) {
        if (!JavaTypesKt.isSuperWildcard((JavaType)CollectionsKt.lastOrNull($this$argumentsMakeSenseOnlyForMutableContainer.getTypeArguments()))) {
            return false;
        }
        List<TypeParameterDescriptor> list = JavaToKotlinClassMapper.INSTANCE.convertReadOnlyToMutable(readOnlyContainer).getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"JavaToKotlinClassMapper.\u2026ypeConstructor.parameters");
        Object object = (TypeParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (object == null || (object = object.getVariance()) == null) {
            return false;
        }
        Object mutableLastParameterVariance = object;
        return mutableLastParameterVariance != Variance.OUT_VARIANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> computeRawTypeArguments(JavaClassifierType javaType, List<? extends TypeParameterDescriptor> typeParameters2, TypeConstructor constructor, JavaTypeAttributes attr) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = typeParameters2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeProjection typeProjection;
            void parameter;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (TypeUtilsKt.hasTypeParameterRecursiveBounds((TypeParameterDescriptor)parameter, null, attr.getVisitedTypeParameters())) {
                typeProjection = TypeUtils.makeStarProjection((TypeParameterDescriptor)parameter, attr);
            } else {
                LazyWrappedType erasedUpperBound2 = new LazyWrappedType(this.c.getStorageManager(), (Function0<? extends KotlinType>)((Function0)new Function0<KotlinType>(this, (TypeParameterDescriptor)parameter, attr, constructor, javaType){
                    final /* synthetic */ JavaTypeResolver this$0;
                    final /* synthetic */ TypeParameterDescriptor $parameter;
                    final /* synthetic */ JavaTypeAttributes $attr;
                    final /* synthetic */ TypeConstructor $constructor;
                    final /* synthetic */ JavaClassifierType $javaType;
                    {
                        this.this$0 = $receiver;
                        this.$parameter = $parameter;
                        this.$attr = $attr;
                        this.$constructor = $constructor;
                        this.$javaType = $javaType;
                        super(0);
                    }

                    @NotNull
                    public final KotlinType invoke() {
                        ClassifierDescriptor classifierDescriptor = this.$constructor.getDeclarationDescriptor();
                        return JavaTypeResolver.access$getTypeParameterUpperBoundEraser$p(this.this$0).getErasedUpperBound(this.$parameter, this.$attr.withDefaultType(classifierDescriptor != null ? classifierDescriptor.getDefaultType() : null).markIsRaw(this.$javaType.isRaw()));
                    }
                }));
                typeProjection = this.projectionComputer.computeProjection((TypeParameterDescriptor)parameter, attr.markIsRaw(javaType.isRaw()), this.typeParameterUpperBoundEraser, erasedUpperBound2);
            }
            collection.add(typeProjection);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeProjection> computeArguments(JavaClassifierType javaType, JavaTypeAttributes attr, TypeConstructor constructor) {
        isRaw = javaType.isRaw();
        if (isRaw) ** GOTO lbl-1000
        if (javaType.getTypeArguments().isEmpty()) {
            v0 = constructor.getParameters();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"constructor.parameters");
            ** if (!(((Collection)v0).isEmpty() == false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl11
        }
lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
lbl11:
        // 2 sources

        eraseTypeParameters = v1;
        v2 = constructor.getParameters();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"constructor.parameters");
        typeParameters = v2;
        if (eraseTypeParameters) {
            return this.computeRawTypeArguments(javaType, typeParameters, constructor, attr);
        }
        if (typeParameters.size() != javaType.getTypeArguments().size()) {
            $this$map$iv = typeParameters;
            $i$f$map = false;
            var9_11 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var14_21 = (TypeParameterDescriptor)item$iv$iv;
                var20_27 = destination$iv$iv;
                $i$a$-map-JavaTypeResolver$computeArguments$1 = false;
                var16_25 = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)p.getName().asString(), (String)"p.name.asString()");
                var20_27.add(new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.MISSED_TYPE_ARGUMENT_FOR_TYPE_PARAMETER, var16_25)));
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        $this$map$iv = CollectionsKt.withIndex((Iterable)javaType.getTypeArguments());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            p = (IndexedValue)item$iv$iv;
            var20_28 = destination$iv$iv;
            $i$a$-map-JavaTypeResolver$computeArguments$2 = false;
            i = indexedArgument.component1();
            javaTypeArgument = (JavaType)indexedArgument.component2();
            v3 = var18_31 = i < typeParameters.size();
            if (_Assertions.ENABLED && !var18_31) {
                $i$a$-assert-JavaTypeResolver$computeArguments$2$1 = false;
                var19_33 = "Argument index should be less then type parameters count, but " + i + " > " + typeParameters.size();
                throw new AssertionError((Object)var19_33);
            }
            parameter = typeParameters.get(i);
            v4 = JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null);
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            var20_28.add(this.transformToTypeProjection(javaTypeArgument, v4, parameter));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final TypeProjection transformToTypeProjection(JavaType javaType, JavaTypeAttributes attr, TypeParameterDescriptor typeParameter) {
        TypeProjection typeProjection;
        if (javaType instanceof JavaWildcardType) {
            JavaType bound = ((JavaWildcardType)javaType).getBound();
            Variance projectionKind = ((JavaWildcardType)javaType).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            TypeProjection typeProjection2 = bound == null || this.isConflictingArgumentFor(projectionKind, typeParameter) ? TypeUtils.makeStarProjection(typeParameter, attr) : TypeUtilsKt.createProjection(this.transformJavaType(bound, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null)), projectionKind, typeParameter);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"{\n                val bo\u2026          }\n            }");
            typeProjection = typeProjection2;
        } else {
            typeProjection = new TypeProjectionImpl(Variance.INVARIANT, this.transformJavaType(javaType, attr));
        }
        return typeProjection;
    }

    private final boolean isConflictingArgumentFor(Variance $this$isConflictingArgumentFor, TypeParameterDescriptor typeParameter) {
        if (typeParameter.getVariance() == Variance.INVARIANT) {
            return false;
        }
        return $this$isConflictingArgumentFor != typeParameter.getVariance();
    }

    private final boolean isNullable(JavaTypeAttributes $this$isNullable) {
        if ($this$isNullable.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) {
            return false;
        }
        return !$this$isNullable.isForAnnotationParameter() && $this$isNullable.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
    }

    private static final ErrorType transformJavaClassifierType$errorType(JavaClassifierType $javaType) {
        String[] stringArray = new String[]{$javaType.getPresentableText()};
        return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_JAVA_CLASS, stringArray);
    }

    public static final /* synthetic */ TypeParameterUpperBoundEraser access$getTypeParameterUpperBoundEraser$p(JavaTypeResolver $this) {
        return $this.typeParameterUpperBoundEraser;
    }
}

