/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationConfiguration;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmPackageTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_14 = i$iv;
                    void var24_17 = i$iv++;
                    int[] nArray = result$iv;
                    nArray[var24_17] = n3 = stream.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                Object packageParts;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result = new LinkedHashMap();
                for (JvmPackageTable.PackageParts proto : table.getPackagePartsList()) {
                    String partShortName;
                    Object object;
                    IndexedValue $receiver$iv2;
                    String packageFqName = proto.getPackageFqName();
                    Map map2 = result;
                    String string = packageFqName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName");
                    Iterator key$iv = string;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    packageParts = (PackageParts)object;
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex((Iterable)proto.getShortClassNameList())) {
                        String string2;
                        String facadeShortName;
                        String string3;
                        ProtocolStringList protocolStringList;
                        Integer multifileFacadeId;
                        int index = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        Integer n = (Integer)CollectionsKt.getOrNull(proto.getMultifileFacadeShortNameIdList(), (int)index);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            protocolStringList = proto.getMultifileFacadeShortNameList();
                            int p1 = ((Number)n5).intValue();
                            string3 = (String)CollectionsKt.getOrNull((List)protocolStringList, (int)p1);
                        } else {
                            string3 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it = protocolStringList;
                            string2 = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
                        } else {
                            string2 = null;
                        }
                        String facadeInternalName = string2;
                        String string4 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string4), facadeInternalName);
                    }
                    if (!configuration.isJvmPackageNameSupported()) continue;
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex((Iterable)proto.getClassWithJvmPackageNameShortNameList())) {
                        String jvmPackageName;
                        int index = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        Integer n = (Integer)CollectionsKt.getOrNull(proto.getClassWithJvmPackageNamePackageIdList(), (int)index);
                        if (n == null) {
                            n = (Integer)CollectionsKt.lastOrNull(proto.getClassWithJvmPackageNamePackageIdList());
                        }
                        if (n == null) {
                            continue;
                        }
                        int packageId = n;
                        if ((String)CollectionsKt.getOrNull((List)table.getJvmPackageNameList(), (int)packageId) == null) {
                            continue;
                        }
                        String string5 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string5), null);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object;
                    String key$iv;
                    Iterable $receiver$iv;
                    packageParts = result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)proto.getPackageFqName(), (String)"proto.packageFqName");
                    Object value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    PackageParts packageParts2 = (PackageParts)object;
                    $receiver$iv = proto.getShortClassNameList();
                    for (Object element$iv : $receiver$iv) {
                        String p1 = (String)element$iv;
                        packageParts2.addMetadataPart(p1);
                    }
                }
                return new ModuleMapping(result, debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

