/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.serialization.ProtoBuf;

public class Flags {
    public static final FlagField<Boolean> HAS_ANNOTATIONS = FlagField.booleanFirst();
    public static final FlagField<ProtoBuf.Visibility> VISIBILITY = FlagField.after(HAS_ANNOTATIONS, (Internal.EnumLite[])ProtoBuf.Visibility.values());
    public static final FlagField<ProtoBuf.Modality> MODALITY = FlagField.after(VISIBILITY, (Internal.EnumLite[])ProtoBuf.Modality.values());
    public static final FlagField<ProtoBuf.Class.Kind> CLASS_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.Class.Kind.values());
    public static final FlagField<Boolean> INNER = FlagField.booleanAfter(CLASS_KIND);
    public static final FlagField<ProtoBuf.Callable.CallableKind> CALLABLE_KIND = FlagField.after(MODALITY, (Internal.EnumLite[])ProtoBuf.Callable.CallableKind.values());
    public static final FlagField<ProtoBuf.Callable.MemberKind> MEMBER_KIND = FlagField.after(CALLABLE_KIND, (Internal.EnumLite[])ProtoBuf.Callable.MemberKind.values());
    public static final FlagField<Boolean> HAS_GETTER = FlagField.booleanAfter(MEMBER_KIND);
    public static final FlagField<Boolean> HAS_SETTER = FlagField.booleanAfter(HAS_GETTER);
    public static final FlagField<Boolean> HAS_CONSTANT = FlagField.booleanAfter(HAS_SETTER);
    public static final FlagField<Boolean> DECLARES_DEFAULT_VALUE = FlagField.booleanAfter(HAS_ANNOTATIONS);
    public static final FlagField<Boolean> IS_NOT_DEFAULT = FlagField.booleanAfter(MODALITY);

    private Flags() {
    }

    private static <E> int bitWidth(@NotNull E[] enumEntries) {
        int length = enumEntries.length - 1;
        if (length == 0) {
            return 1;
        }
        for (int i = 31; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            return i + 1;
        }
        throw new IllegalStateException("Empty enum: " + enumEntries.getClass());
    }

    public static int getClassFlags(boolean hasAnnotations, Visibility visibility, Modality modality, ClassKind kind, boolean inner, boolean isCompanionObject) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | CLASS_KIND.toFlags(Flags.classKind(kind, isCompanionObject)) | INNER.toFlags(inner);
    }

    private static ProtoBuf.Class.Kind classKind(ClassKind kind, boolean isCompanionObject) {
        if (isCompanionObject) {
            return ProtoBuf.Class.Kind.CLASS_OBJECT;
        }
        switch (kind) {
            case CLASS: {
                return ProtoBuf.Class.Kind.CLASS;
            }
            case TRAIT: {
                return ProtoBuf.Class.Kind.TRAIT;
            }
            case ENUM_CLASS: {
                return ProtoBuf.Class.Kind.ENUM_CLASS;
            }
            case ENUM_ENTRY: {
                return ProtoBuf.Class.Kind.ENUM_ENTRY;
            }
            case ANNOTATION_CLASS: {
                return ProtoBuf.Class.Kind.ANNOTATION_CLASS;
            }
            case OBJECT: {
                return ProtoBuf.Class.Kind.OBJECT;
            }
        }
        throw new IllegalArgumentException("Unknown class kind: " + (Object)((Object)kind));
    }

    public static int getCallableFlags(boolean hasAnnotations, @NotNull Visibility visibility, @NotNull Modality modality, @NotNull CallableMemberDescriptor.Kind memberKind, @NotNull ProtoBuf.Callable.CallableKind callableKind, boolean hasGetter, boolean hasSetter, boolean hasConstant) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | MEMBER_KIND.toFlags(Flags.memberKind(memberKind)) | CALLABLE_KIND.toFlags(callableKind) | HAS_GETTER.toFlags(hasGetter) | HAS_SETTER.toFlags(hasSetter) | HAS_CONSTANT.toFlags(hasConstant);
    }

    public static int getAccessorFlags(boolean hasAnnotations, @NotNull Visibility visibility, @NotNull Modality modality, boolean isNotDefault) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | MODALITY.toFlags(Flags.modality(modality)) | VISIBILITY.toFlags(Flags.visibility(visibility)) | IS_NOT_DEFAULT.toFlags(isNotDefault);
    }

    @NotNull
    private static ProtoBuf.Visibility visibility(@NotNull Visibility visibility) {
        if (visibility == Visibilities.INTERNAL) {
            return ProtoBuf.Visibility.INTERNAL;
        }
        if (visibility == Visibilities.PUBLIC) {
            return ProtoBuf.Visibility.PUBLIC;
        }
        if (visibility == Visibilities.PRIVATE) {
            return ProtoBuf.Visibility.PRIVATE;
        }
        if (visibility == Visibilities.PRIVATE_TO_THIS) {
            return ProtoBuf.Visibility.PRIVATE_TO_THIS;
        }
        if (visibility == Visibilities.PROTECTED) {
            return ProtoBuf.Visibility.PROTECTED;
        }
        if (visibility == Visibilities.LOCAL) {
            return ProtoBuf.Visibility.LOCAL;
        }
        throw new IllegalArgumentException("Unknown visibility: " + visibility);
    }

    @NotNull
    private static ProtoBuf.Modality modality(@NotNull Modality modality) {
        switch (modality) {
            case FINAL: {
                return ProtoBuf.Modality.FINAL;
            }
            case OPEN: {
                return ProtoBuf.Modality.OPEN;
            }
            case ABSTRACT: {
                return ProtoBuf.Modality.ABSTRACT;
            }
        }
        throw new IllegalArgumentException("Unknown modality: " + (Object)((Object)modality));
    }

    @NotNull
    private static ProtoBuf.Callable.MemberKind memberKind(@NotNull CallableMemberDescriptor.Kind kind) {
        switch (kind) {
            case DECLARATION: {
                return ProtoBuf.Callable.MemberKind.DECLARATION;
            }
            case FAKE_OVERRIDE: {
                return ProtoBuf.Callable.MemberKind.FAKE_OVERRIDE;
            }
            case DELEGATION: {
                return ProtoBuf.Callable.MemberKind.DELEGATION;
            }
            case SYNTHESIZED: {
                return ProtoBuf.Callable.MemberKind.SYNTHESIZED;
            }
        }
        throw new IllegalArgumentException("Unknown member kind: " + (Object)((Object)kind));
    }

    public static int getValueParameterFlags(boolean hasAnnotations, boolean declaresDefaultValue) {
        return HAS_ANNOTATIONS.toFlags(hasAnnotations) | DECLARES_DEFAULT_VALUE.toFlags(declaresDefaultValue);
    }

    private static class EnumLiteFlagField<E extends Internal.EnumLite>
    extends FlagField<E> {
        public EnumLiteFlagField(int offset, E[] values) {
            super(offset, values);
        }

        @Override
        protected int getIntValue(E value) {
            return value.getNumber();
        }
    }

    private static class BooleanFlagField
    extends FlagField<Boolean> {
        private static final Boolean[] BOOLEAN = new Boolean[]{false, true};

        public BooleanFlagField(int offset) {
            super(offset, BOOLEAN);
        }

        @Override
        protected int getIntValue(Boolean value) {
            return value != false ? 1 : 0;
        }
    }

    public static abstract class FlagField<E> {
        private final int offset;
        private final int bitWidth;
        private final E[] values;

        public static <E extends Internal.EnumLite> FlagField<E> after(FlagField<?> previousField, E[] values) {
            int offset = previousField.offset + previousField.bitWidth;
            return new EnumLiteFlagField(offset, values);
        }

        public static <E extends Internal.EnumLite> FlagField<E> first(E[] values) {
            return new EnumLiteFlagField(0, values);
        }

        public static FlagField<Boolean> booleanFirst() {
            return new BooleanFlagField(0);
        }

        public static FlagField<Boolean> booleanAfter(FlagField<?> previousField) {
            int offset = previousField.offset + previousField.bitWidth;
            return new BooleanFlagField(offset);
        }

        private FlagField(int offset, E[] values) {
            this.offset = offset;
            this.bitWidth = Flags.bitWidth(values);
            this.values = values;
        }

        public E get(int flags) {
            int maskUnshifted = (1 << this.bitWidth) - 1;
            int mask = maskUnshifted << this.offset;
            int value = (flags & mask) >> this.offset;
            for (E e : this.values) {
                if (this.getIntValue(e) != value) continue;
                return e;
            }
            throw new IllegalStateException("Flag not found: " + value);
        }

        public int toFlags(E value) {
            return this.getIntValue(value) << this.offset;
        }

        protected abstract int getIntValue(E var1);
    }
}

