/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.JetType;

public class StringValue
extends CompileTimeConstant<String> {
    public StringValue(String value, boolean canBeUsedInAnnotations, boolean usesVariableAsConstant) {
        super(value, canBeUsedInAnnotations, false, usesVariableAsConstant);
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return kotlinBuiltIns.getStringType();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitStringValue(this, data2);
    }

    public String toString() {
        return "\"" + (String)this.value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return !(this.value != null ? !((String)this.value).equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? ((String)this.value).hashCode() : 0;
    }
}

