/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.types.JetType;

public abstract class CompileTimeConstant<T> {
    protected final T value;
    private final int flags;
    private static final int IS_PURE_MASK = 1;
    private static final int CAN_BE_USED_IN_ANNOTATIONS_MASK = 2;
    private static final int USES_VARIABLE_AS_CONSTANT_MASK = 4;

    protected CompileTimeConstant(T value, boolean canBeUsedInAnnotations, boolean isPure, boolean usesVariableAsConstant) {
        this.value = value;
        this.flags = (isPure ? 1 : 0) | (canBeUsedInAnnotations ? 2 : 0) | (usesVariableAsConstant ? 4 : 0);
    }

    public boolean canBeUsedInAnnotations() {
        return (this.flags & 2) != 0;
    }

    public boolean isPure() {
        return (this.flags & 1) != 0;
    }

    public boolean usesVariableAsConstant() {
        return (this.flags & 4) != 0;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @NotNull
    public abstract JetType getType(@NotNull KotlinBuiltIns var1);

    public abstract <R, D> R accept(AnnotationArgumentVisitor<R, D> var1, D var2);
}

