/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class JavaVisibilities {
    public static final Visibility PACKAGE_VISIBILITY = new Visibility("package", false){

        @Override
        protected boolean isVisible(@NotNull ReceiverValue receiver, @NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            return JavaVisibilities.areInSamePackage(what, from);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }

        @Override
        protected Integer compareTo(@NotNull Visibility visibility) {
            if (this == visibility) {
                return 0;
            }
            if (Visibilities.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "public/*package*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.INTERNAL;
        }
    };
    public static final Visibility PROTECTED_STATIC_VISIBILITY = new Visibility("protected_static", true){

        @Override
        protected boolean isVisible(@NotNull ReceiverValue receiver, @NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            if (JavaVisibilities.areInSamePackage(what, from)) {
                return true;
            }
            ClassDescriptor fromClass = DescriptorUtils.getParentOfType(from, ClassDescriptor.class, false);
            if (fromClass == null) {
                return false;
            }
            DeclarationDescriptor containingDeclaration = what.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : "Only class members can have protected_static visibility";
            ClassDescriptor whatClass = (ClassDescriptor)containingDeclaration;
            if (DescriptorUtils.isSubclass(fromClass, whatClass)) {
                return true;
            }
            return this.isVisible(receiver, what, fromClass.getContainingDeclaration());
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        public String toString() {
            return "protected/*protected static*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.PROTECTED;
        }
    };
    public static final Visibility PROTECTED_AND_PACKAGE = new Visibility("protected_and_package", true){

        @Override
        protected boolean isVisible(@NotNull ReceiverValue receiver, @NotNull DeclarationDescriptorWithVisibility what, @NotNull DeclarationDescriptor from) {
            if (JavaVisibilities.areInSamePackage(what, from)) {
                return true;
            }
            ClassDescriptor whatClass = DescriptorUtils.getParentOfType(what, ClassDescriptor.class, false);
            if (whatClass == null) {
                return false;
            }
            ClassDescriptor fromClass = DescriptorUtils.getParentOfType(from, ClassDescriptor.class, false);
            if (fromClass == null) {
                return false;
            }
            if (DescriptorUtils.isSubclass(fromClass, whatClass)) {
                return true;
            }
            return this.isVisible(receiver, what, fromClass.getContainingDeclaration());
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        protected Integer compareTo(@NotNull Visibility visibility) {
            if (this == visibility) {
                return 0;
            }
            if (visibility == Visibilities.INTERNAL) {
                return null;
            }
            if (Visibilities.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        public String toString() {
            return "protected/*protected and package*/";
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.PROTECTED;
        }
    };

    private JavaVisibilities() {
    }

    private static boolean areInSamePackage(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        PackageFragmentDescriptor whatPackage = DescriptorUtils.getParentOfType(first, PackageFragmentDescriptor.class, false);
        PackageFragmentDescriptor fromPackage = DescriptorUtils.getParentOfType(second, PackageFragmentDescriptor.class, false);
        return fromPackage != null && whatPackage != null && whatPackage.getFqName().equals(fromPackage.getFqName());
    }
}

