/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Iterator;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.InlineOption;
import org.jetbrains.kotlin.builtins.InlineStrategy;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.EnumValue;

public class InlineUtil {
    public static boolean hasNoinlineAnnotation(@NotNull CallableDescriptor valueParameterDescriptor) {
        return KotlinBuiltIns.containsAnnotation(valueParameterDescriptor, KotlinBuiltIns.getNoinlineClassAnnotationFqName());
    }

    @NotNull
    public static InlineStrategy getInlineType(@NotNull DeclarationDescriptor descriptor2) {
        ClassDescriptor inlineAnnotation = KotlinBuiltIns.getInstance().getInlineClassAnnotation();
        AnnotationDescriptor annotation = descriptor2.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(inlineAnnotation));
        if (annotation == null) {
            return InlineStrategy.NOT_INLINE;
        }
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor2, inlineAnnotation);
        if (argument == null) {
            return InlineStrategy.AS_FUNCTION;
        }
        assert (argument instanceof EnumValue) : "Inline annotation parameter should be enum entry but was: " + argument;
        String name = ((EnumValue)argument).getValue().getName().asString();
        return name.equals(InlineStrategy.IN_PLACE.name()) ? InlineStrategy.IN_PLACE : InlineStrategy.AS_FUNCTION;
    }

    public static boolean hasOnlyLocalContinueAndBreak(@NotNull ValueParameterDescriptor descriptor2) {
        return InlineUtil.hasInlineOption(descriptor2, InlineOption.LOCAL_CONTINUE_AND_BREAK);
    }

    public static boolean hasOnlyLocalReturn(@NotNull ValueParameterDescriptor descriptor2) {
        return InlineUtil.hasInlineOption(descriptor2, InlineOption.ONLY_LOCAL_RETURN);
    }

    private static boolean hasInlineOption(@NotNull ValueParameterDescriptor descriptor2, @NotNull InlineOption option) {
        CompileTimeConstant<?> argument = InlineUtil.getAnnotationSingleArgument(descriptor2, KotlinBuiltIns.getInstance().getInlineOptionsClassAnnotation());
        if (argument instanceof ArrayValue) {
            Object values = ((ArrayValue)argument).getValue();
            Iterator i$ = values.iterator();
            while (i$.hasNext()) {
                CompileTimeConstant value = (CompileTimeConstant)i$.next();
                if (!(value instanceof EnumValue) || !((EnumValue)value).getValue().getName().asString().equals(option.name())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static CompileTimeConstant<?> getAnnotationSingleArgument(@NotNull Annotated annotated, @NotNull ClassDescriptor annotationClass) {
        AnnotationDescriptor annotation = annotated.getAnnotations().findAnnotation(DescriptorUtils.getFqNameSafe(annotationClass));
        if (annotation != null) {
            return (CompileTimeConstant)KotlinPackage.firstOrNull(annotation.getAllValueArguments().values());
        }
        return null;
    }
}

