/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import com.intellij.openapi.util.io.JarUtil;
import java.io.File;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/CommonVersionReader;", "", "()V", "CLASS_SUFFIX", "", "REQUIRE_KOTLIN_VERSION", "Ljava/util/jar/Attributes$Name;", "canSupportInlineClasses", "", "currentVersion", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/RuntimeVersions;", "computeRuntimeVersions", "sourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getVersionsFromManifest", "runtimeLibraryPath", "Ljava/io/File;", "kotlin-maven-serialization"})
@SourceDebugExtension(value={"SMAP\nRuntimeVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeVersions.kt\norg/jetbrains/kotlinx/serialization/compiler/diagnostic/CommonVersionReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class CommonVersionReader {
    @NotNull
    public static final CommonVersionReader INSTANCE = new CommonVersionReader();
    @NotNull
    private static final Attributes.Name REQUIRE_KOTLIN_VERSION = new Attributes.Name("Require-Kotlin-Version");
    @NotNull
    private static final String CLASS_SUFFIX = "!/kotlinx/serialization/KSerializer.class";

    private CommonVersionReader() {
    }

    @Nullable
    public final RuntimeVersions computeRuntimeVersions(@Nullable SourceElement sourceElement) {
        Object object = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
        if (object == null || (object = object.getBinaryClass()) == null || (object = object.getLocation()) == null) {
            return null;
        }
        Object location = object;
        String jarFile = StringsKt.removeSuffix((String)location, (CharSequence)CLASS_SUFFIX);
        if (!StringsKt.endsWith$default((String)jarFile, (String)".jar", (boolean)false, (int)2, null)) {
            return null;
        }
        File file = new File(jarFile);
        if (!file.exists()) {
            return null;
        }
        return this.getVersionsFromManifest(file);
    }

    @NotNull
    public final RuntimeVersions getVersionsFromManifest(@NotNull File runtimeLibraryPath) {
        ApiVersion apiVersion;
        ApiVersion apiVersion2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)runtimeLibraryPath, (String)"runtimeLibraryPath");
        String string = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string != null) {
            String string2 = string;
            object = ApiVersion.Companion;
            String p0 = string2;
            boolean bl = false;
            apiVersion2 = object.parse(p0);
        } else {
            apiVersion2 = null;
        }
        ApiVersion version = apiVersion2;
        String string3 = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)REQUIRE_KOTLIN_VERSION);
        if (string3 != null) {
            object = string3;
            ApiVersion.Companion companion2 = ApiVersion.Companion;
            Object p0 = object;
            boolean bl = false;
            apiVersion = companion2.parse((String)p0);
        } else {
            apiVersion = null;
        }
        ApiVersion kotlinVersion = apiVersion;
        return new RuntimeVersions(version, kotlinVersion);
    }

    public final boolean canSupportInlineClasses(@Nullable RuntimeVersions currentVersion2) {
        if (currentVersion2 == null) {
            return true;
        }
        ApiVersion apiVersion = currentVersion2.getImplementationVersion();
        if (apiVersion == null) {
            return false;
        }
        ApiVersion implVersion = apiVersion;
        return implVersion.compareTo(RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES()) >= 0;
    }
}

