/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportContextHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.RuntimeVersions;
import org.jetbrains.kotlinx.serialization.compiler.fir.AnnotationParameterNames;
import org.jetbrains.kotlinx.serialization.compiler.fir.FirSerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.fir.FirSerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.fir.SerializationFirUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.FirSerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.ContextualSerializersProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.DependencySerializationInfoProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.FirSerializablePropertiesProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.FirVersionReaderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J6\u0010!\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J*\u0010*\u001a\u0004\u0018\u00010+2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J(\u0010-\u001a\u00020\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u00020\fH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J \u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0016J(\u00104\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J6\u00106\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J:\u00107\u001a\u00020\"2\b\u00108\u001a\u0004\u0018\u00010\u001d2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u00109\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:JB\u0010;\u001a\u00020\"2\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\r2\b\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u0010=\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J(\u0010?\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J(\u0010@\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J(\u0010A\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J6\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00152\b\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ(\u0010E\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J.\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020\u00152\b\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ.\u0010I\u001a\u00020\"2\u0006\u0010G\u001a\u00020\u00152\b\u00108\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ(\u0010J\u001a\u00020\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010'\u001a\u00020(H\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020MH\u0002J \u0010N\u001a\u00020\f*\u00020O2\u0006\u0010P\u001a\u00020OH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ \u0010R\u001a\u00020\f*\u00020S2\u0006\u0010P\u001a\u00020SH\u0002R\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R)\u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\u0011R)\u0010\u0012\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u0011R%\u0010\u0014\u001a\u00020\f*\u00020\u00158BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0018R)\u0010\u0019\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u001b\u0010\u0011R+\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u0006\u0012\u0002\b\u00030\r8BX\u0082\u0004b\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "JAVA_SERIALIZABLE_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "NA", "", "TOO_LOW", "UNKNOWN", "isAnonymousObjectOrInsideIt", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isAnonymousObjectOrInsideIt$annotations", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)V", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Z", "isSerializableEnumWithMissingSerializer", "isSerializableEnumWithMissingSerializer$annotations", "isUnsupportedInlineType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isUnsupportedInlineType$annotations", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "serializableAnnotationIsUseless", "getSerializableAnnotationIsUseless$annotations", "getSerializableAnnotationIsUseless", "serializableOrMetaAnnotationSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "getSerializableOrMetaAnnotationSource$annotations", "getSerializableOrMetaAnnotationSource", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Lorg/jetbrains/kotlin/KtSourceElement;", "analyzePropertiesSerializers", "", "classSymbol", "properties", "", "Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperty;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperties;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperties;", "canBeSerializedInternally", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)Z", "canSupportInlineClasses", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "check", "declaration", "context", "checkClassWithCustomSerializer", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkCorrectTransientAnnotationIsUsed", "checkCustomSerializerIsNotLocal", "source", "serializerType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkCustomSerializerMatch", "containingClassSymbol", "declarationType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkEnum", "checkExternalSerializer", "checkInheritedAnnotations", "checkSerializerNullability", "classType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkTransients", "checkType", "type", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkTypeArguments", "checkVersions", "declarationHasInitializer", "propertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasSameArguments", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "other", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Z", "isEqualTo", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "kotlin-maven-serialization"})
@SourceDebugExtension(value={"SMAP\nFirSerializationPluginClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSerializationPluginClassChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n47#2:511\n47#2:512\n37#2:562\n34#2:563\n1722#3,3:513\n1743#3,3:516\n288#3,2:523\n1743#3,3:525\n800#3,11:530\n1743#3,3:544\n766#3:549\n857#3,2:550\n1603#3,9:552\n1851#3:561\n1852#3:565\n1612#3:566\n64#4:519\n66#4:520\n129#4:521\n129#4:528\n42#4:541\n129#4:542\n37#5:522\n37#5:529\n37#5:543\n37#5:548\n1#6:547\n1#6:564\n*S KotlinDebug\n*F\n+ 1 FirSerializationPluginClassChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginClassChecker\n*L\n137#1:511\n142#1:512\n83#1:562\n83#1:563\n146#1:513,3\n182#1:516,3\n245#1:523,2\n269#1:525,3\n322#1:530,11\n489#1:544,3\n82#1:549\n82#1:550,2\n83#1:552,9\n83#1:561\n83#1:565\n83#1:566\n215#1:519\n220#1:520\n242#1:521\n275#1:528\n323#1:541\n486#1:542\n242#1:522\n275#1:529\n486#1:543\n504#1:548\n83#1:564\n*E\n"})
public final class FirSerializationPluginClassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSerializationPluginClassChecker INSTANCE = new FirSerializationPluginClassChecker();
    @NotNull
    private static final ClassId JAVA_SERIALIZABLE_ID;
    @NotNull
    private static final String TOO_LOW = "too low";
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String NA = "N/A";

    private FirSerializationPluginClassChecker() {
    }

    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CheckerContext $this$check_u24lambda_u240 = context;
        boolean bl = false;
        FirClassSymbol classSymbol = declaration.getSymbol();
        INSTANCE.checkEnum($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.checkExternalSerializer($this$check_u24lambda_u240, classSymbol, reporter);
        if (!INSTANCE.canBeSerializedInternally($this$check_u24lambda_u240, classSymbol, reporter)) {
            return;
        }
        if (!(classSymbol instanceof FirRegularClassSymbol)) {
            return;
        }
        FirSerializableProperties firSerializableProperties = INSTANCE.buildSerializableProperties($this$check_u24lambda_u240, classSymbol, reporter);
        if (firSerializableProperties == null) {
            return;
        }
        FirSerializableProperties properties = firSerializableProperties;
        INSTANCE.checkCorrectTransientAnnotationIsUsed($this$check_u24lambda_u240, classSymbol, properties.getSerializableProperties(), reporter);
        INSTANCE.checkTransients($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.analyzePropertiesSerializers($this$check_u24lambda_u240, classSymbol, properties.getSerializableProperties(), reporter);
        INSTANCE.checkInheritedAnnotations($this$check_u24lambda_u240, classSymbol, reporter);
        INSTANCE.checkVersions($this$check_u24lambda_u240, classSymbol, reporter);
    }

    private final void checkExternalSerializer(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializerForClass(classSymbol);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializableKType = coneKotlinType;
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)serializableKType, (FirSession)checkerContext.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol serializableClassSymbol = firRegularClassSymbol;
        FirSerializableProperties properties = FirSerializablePropertiesProviderKt.getSerializablePropertiesProvider(checkerContext.getSession()).getSerializablePropertiesForClass(classSymbol);
        if (!properties.isExternallySerializable()) {
            FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation(classSymbol);
            if (firAnnotation == null || (firAnnotation = firAnnotation.getSource()) == null) {
                firAnnotation = classSymbol.getSource();
            }
            FirAnnotation source = firAnnotation;
            KtDiagnosticFactory2<FirClassSymbol<?>, ConeKotlinType> error = Intrinsics.areEqual((Object)serializableClassSymbol.getModuleData(), (Object)FirModuleDataKt.getModuleData((FirSession)checkerContext.getSession())) ? FirSerializationErrors.INSTANCE.getEXTERNAL_CLASS_NOT_SERIALIZABLE() : FirSerializationErrors.INSTANCE.getEXTERNAL_CLASS_IN_ANOTHER_MODULE();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), error, (Object)serializableClassSymbol, (Object)serializableKType, null, (int)32, null);
        }
    }

    private final void checkInheritedAnnotations(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        Map map = MapsKt.createMapBuilder();
        Map $this$checkInheritedAnnotations_u24lambda_u244 = map;
        boolean bl = false;
        MapsKt.putAll((Map)$this$checkInheritedAnnotations_u24lambda_u244, (Iterable)FirSerializationPluginClassChecker.checkInheritedAnnotations$annotationsFilter(checkerContext, classSymbol.getResolvedAnnotationsWithClassIds()));
        Map annotationByClassId = MapsKt.build((Map)map);
        for (ConeKotlinType superType : classSymbol.getResolvedSuperTypes()) {
            FirRegularClassSymbol superSymbol;
            if (TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)superType, (FirSession)checkerContext.getSession()) == null) continue;
            List<Pair<ClassId, FirAnnotation>> superAnnotations = FirSerializationPluginClassChecker.checkInheritedAnnotations$annotationsFilter(checkerContext, superSymbol.getResolvedAnnotationsWithClassIds());
            for (Pair<ClassId, FirAnnotation> pair : superAnnotations) {
                FirAnnotation existingAnnotation;
                ClassId classId = (ClassId)pair.component1();
                FirAnnotation superAnnotation = (FirAnnotation)pair.component2();
                if ((FirAnnotation)annotationByClassId.get(classId) == null || this.hasSameArguments(checkerContext, existingAnnotation, superAnnotation)) continue;
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)existingAnnotation.getSource()), FirSerializationErrors.INSTANCE.getINCONSISTENT_INHERITABLE_SERIALINFO(), (Object)FirTypeUtilsKt.getConeType((FirTypeRef)existingAnnotation.getAnnotationTypeRef()), (Object)ScopeUtilsKt.defaultType(classSymbol), null, (int)32, null);
            }
        }
    }

    private final boolean hasSameArguments(CheckerContext checkerContext, FirAnnotation $this$hasSameArguments, FirAnnotation other) {
        Map m1 = $this$hasSameArguments.getArgumentMapping().getMapping();
        Map m2 = other.getArgumentMapping().getMapping();
        if (!Intrinsics.areEqual(m1.keySet(), m2.keySet())) {
            return false;
        }
        for (Map.Entry entry : m1.entrySet()) {
            FirExpression v2;
            Name key = (Name)entry.getKey();
            FirExpression v1 = (FirExpression)entry.getValue();
            if (this.isEqualTo(checkerContext, v1, v2 = (FirExpression)MapsKt.getValue((Map)m2, (Object)key))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEqualTo(CheckerContext checkerContext, FirExpression $this$isEqualTo, FirExpression other) {
        boolean bl;
        if ($this$isEqualTo instanceof FirConstExpression && other instanceof FirConstExpression) {
            if (!Intrinsics.areEqual((Object)((FirConstExpression)$this$isEqualTo).getKind(), (Object)((FirConstExpression)other).getKind())) return false;
            if (!Intrinsics.areEqual((Object)((FirConstExpression)$this$isEqualTo).getValue(), (Object)((FirConstExpression)other).getValue())) return false;
            return true;
        }
        if ($this$isEqualTo instanceof FirGetClassCall && other instanceof FirGetClassCall) {
            bl = AbstractTypeChecker.equalTypes$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)((TypeCheckerProviderContext)TypeComponentsKt.getTypeContext((FirSession)checkerContext.getSession())), (KotlinTypeMarker)((KotlinTypeMarker)FirTypeUtilsKt.getConeType((FirTypeRef)$this$isEqualTo.getTypeRef())), (KotlinTypeMarker)((KotlinTypeMarker)FirTypeUtilsKt.getConeType((FirTypeRef)other.getTypeRef())), (boolean)false, (int)8, null);
            return bl;
        } else if ($this$isEqualTo instanceof FirPropertyAccessExpression && other instanceof FirPropertyAccessExpression) {
            FirResolvedNamedReference firResolvedNamedReference = FirExpressionUtilKt.toResolvedCallableReference((FirExpression)$this$isEqualTo);
            FirResolvedNamedReference firResolvedNamedReference2 = FirExpressionUtilKt.toResolvedCallableReference((FirExpression)other);
            bl = Intrinsics.areEqual((Object)(firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null), (Object)(firResolvedNamedReference2 != null ? firResolvedNamedReference2.getResolvedSymbol() : null));
            return bl;
        } else {
            FirExpression b;
            Pair pair;
            FirExpression a;
            List list;
            List list2;
            FirExpression firExpression = $this$isEqualTo;
            if (firExpression instanceof FirVarargArgumentsExpression) {
                list2 = ((FirVarargArgumentsExpression)$this$isEqualTo).getArguments();
            } else {
                if (!(firExpression instanceof FirArrayOfCall)) return false;
                FirCall firCall = (FirCall)$this$isEqualTo;
                boolean $i$f$getArguments = false;
                list2 = firCall.getArgumentList().getArguments();
            }
            List argumentsIfArray1 = list2;
            FirExpression firExpression2 = other;
            if (firExpression2 instanceof FirVarargArgumentsExpression) {
                list = ((FirVarargArgumentsExpression)other).getArguments();
            } else {
                if (!(firExpression2 instanceof FirArrayOfCall)) return false;
                FirCall $this$arguments$iv = (FirCall)other;
                boolean $i$f$getArguments = false;
                list = $this$arguments$iv.getArgumentList().getArguments();
            }
            List argumentsIfArray2 = list;
            if (argumentsIfArray1.size() != argumentsIfArray2.size()) return false;
            Iterable iterable = CollectionsKt.zip((Iterable)argumentsIfArray1, (Iterable)argumentsIfArray2);
            boolean $i$f$all = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                return true;
            }
            Iterator iterator = iterable.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                pair = (Pair)element$iv;
                boolean bl2 = false;
            } while (INSTANCE.isEqualTo(checkerContext, a = (FirExpression)pair.component1(), b = (FirExpression)pair.component2()));
            return false;
        }
    }

    private final void checkVersions(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(checkerContext.getSession()).getRuntimeVersions();
        if (runtimeVersions2 == null) {
            return;
        }
        RuntimeVersions currentVersions = runtimeVersions2;
        if (!currentVersions.implementationVersionMatchSupported()) {
            Object object;
            DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol);
            KtDiagnosticFactory3<String, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getPROVIDED_RUNTIME_TOO_LOW();
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = TOO_LOW;
            }
            if ((object = currentVersions.getImplementationVersion()) == null || (object = object.toString()) == null) {
                object = UNKNOWN;
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, (Object)string, (Object)object, (Object)RuntimeVersions.Companion.getMINIMAL_SUPPORTED_VERSION().toString(), null, (int)64, null);
        }
        if (!currentVersions.currentCompilerMatchRequired()) {
            Object object;
            Object object2;
            DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol);
            KtDiagnosticFactory3<String, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getREQUIRED_KOTLIN_TOO_HIGH();
            String string = KotlinCompilerVersion.getVersion();
            if (string == null) {
                string = TOO_LOW;
            }
            if ((object2 = currentVersions.getImplementationVersion()) == null || (object2 = object2.toString()) == null) {
                object2 = UNKNOWN;
            }
            if ((object = currentVersions.getRequireKotlinVersion()) == null || (object = object.toString()) == null) {
                object = NA;
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, (Object)string, (Object)object2, (Object)object, null, (int)64, null);
        }
    }

    private final void checkCorrectTransientAnnotationIsUsed(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, List<FirSerializableProperty> properties, DiagnosticReporter reporter) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = classSymbol.getResolvedSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)it), (Object)JAVA_SERIALIZABLE_ID)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (FirSerializableProperty property2 : properties) {
            FirAnnotation incorrectTransient;
            if (property2.getTransient() || (incorrectTransient = FirAnnotationUtilsKt.getAnnotationByClassId((List)property2.getPropertySymbol().getAnnotations(), (ClassId)JvmAnnotationUtilKt.TRANSIENT_ANNOTATION_CLASS_ID)) == null) continue;
            DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
            KtSourceElement ktSourceElement = incorrectTransient.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = property2.getPropertySymbol().getSource();
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getINCORRECT_TRANSIENT(), null, (int)8, null);
        }
    }

    private final boolean canBeSerializedInternally(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        FirRegularClassSymbol superClassSymbol;
        if (DependencySerializationInfoProviderKt.getDependencySerializationInfoProvider(checkerContext.getSession()).getUseGeneratedEnumSerializer() && this.isSerializableEnumWithMissingSerializer(checkerContext, classSymbol)) {
            KtDiagnosticReportContextHelpersKt.reportOn((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)classSymbol.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getEXPLICIT_SERIALIZABLE_IS_REQUIRED(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getENUM_MODIFIER()));
            return false;
        }
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotation(checkerContext, classSymbol)) {
            return false;
        }
        if (this.isAnonymousObjectOrInsideIt(checkerContext, classSymbol)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getANONYMOUS_OBJECTS_NOT_SUPPORTED(), null, (int)8, null);
            return false;
        }
        FirClassSymbol<?> $this$isInner$iv = classSymbol;
        boolean $i$f$isInner = false;
        if ($this$isInner$iv.getRawStatus().isInner()) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getINNER_CLASSES_NOT_SUPPORTED(), null, (int)8, null);
            return false;
        }
        FirClassSymbol<?> $this$isInline$iv = classSymbol;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getRawStatus().isInline() && !FirVersionReaderKt.getVersionReader(checkerContext.getSession()).getCanSupportInlineClasses()) {
            RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(checkerContext.getSession()).getRuntimeVersions();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), FirSerializationErrors.INSTANCE.getINLINE_CLASSES_NOT_SUPPORTED(), (Object)RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES().toString(), (Object)String.valueOf(runtimeVersions2 != null ? runtimeVersions2.getImplementationVersion() : null), null, (int)32, null);
            return false;
        }
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotationWithoutArgs(checkerContext, classSymbol)) {
            this.checkClassWithCustomSerializer(checkerContext, classSymbol, reporter);
            return false;
        }
        if (this.getSerializableAnnotationIsUseless(checkerContext, classSymbol)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getSERIALIZABLE_ANNOTATION_IGNORED(), null, (int)8, null);
            return false;
        }
        FirClassSymbol<?> $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) && !SerializationFirUtilsKt.isInternalSerializable((FirClassSymbol)(superClassSymbol = SerializationFirUtilsKt.getSuperClassOrAny(classSymbol, checkerContext.getSession())))) {
            Object v1;
            block10: {
                Iterable $this$firstOrNull$iv = superClassSymbol.getDeclarationSymbols();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirBasedSymbol it = (FirBasedSymbol)element$iv;
                    boolean bl = false;
                    if (!(it instanceof FirConstructorSymbol && ((FirConstructorSymbol)it).getValueParameterSymbols().isEmpty())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            FirBasedSymbol noArgConstructorSymbol = v1;
            if (noArgConstructorSymbol == null) {
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getNON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR(), null, (int)8, null);
                return false;
            }
        }
        return true;
    }

    private final void checkClassWithCustomSerializer(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)classSymbol);
        if (coneKotlinType == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)checkerContext.getSession())) == null) {
            return;
        }
        ConeKotlinType serializerType = coneKotlinType;
        this.checkCustomSerializerMatch(checkerContext, classSymbol, null, (ConeKotlinType)ScopeUtilsKt.defaultType(classSymbol), serializerType, reporter);
        this.checkCustomSerializerIsNotLocal(checkerContext, null, classSymbol, serializerType, reporter);
    }

    private final boolean isAnonymousObjectOrInsideIt(CheckerContext checkerContext, FirClassSymbol<?> $this$isAnonymousObjectOrInsideIt) {
        boolean bl;
        block4: {
            if ($this$isAnonymousObjectOrInsideIt instanceof FirAnonymousObjectSymbol) {
                return true;
            }
            Iterable $this$any$iv = checkerContext.getContainingDeclarations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirDeclaration it = (FirDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof FirAnonymousObject)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static /* synthetic */ void isAnonymousObjectOrInsideIt$annotations(FirClassSymbol firClassSymbol) {
    }

    private final void checkEnum(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        FirClassSymbol<?> $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        Map entryBySerialName = new LinkedHashMap();
        for (FirEnumEntrySymbol enumEntrySymbol : DeclarationUtilsKt.collectEnumEntries(classSymbol)) {
            Object serialName;
            FirEnumEntrySymbol firstEntry;
            FirAnnotation serialNameAnnotation = SerializationFirUtilsKt.getSerialNameAnnotation((FirBasedSymbol)enumEntrySymbol);
            Object object = serialNameAnnotation;
            if (object == null || (object = FirAnnotationUtilsKt.getStringArgument((FirAnnotation)object, (Name)AnnotationParameterNames.INSTANCE.getVALUE())) == null) {
                String string = enumEntrySymbol.getName().asString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"enumEntrySymbol.name.asString()");
            }
            if ((firstEntry = (FirEnumEntrySymbol)entryBySerialName.get(serialName = object)) != null) {
                DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
                Object object2 = serialNameAnnotation;
                if (object2 == null || (object2 = object2.getSource()) == null) {
                    FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerialNameAnnotation((FirBasedSymbol)firstEntry);
                    object2 = firAnnotation != null ? firAnnotation.getSource() : null;
                    if (object2 == null) {
                        object2 = enumEntrySymbol.getSource();
                    }
                }
                AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)object2;
                KtDiagnosticFactory3<FirClassSymbol<?>, String, String> ktDiagnosticFactory3 = FirSerializationErrors.INSTANCE.getDUPLICATE_SERIAL_NAME_ENUM();
                String string = enumEntrySymbol.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"enumEntrySymbol.name.asString()");
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, classSymbol, (Object)serialName, (Object)string, null, (int)64, null);
                continue;
            }
            entryBySerialName.put(serialName, enumEntrySymbol);
        }
    }

    private final FirSerializableProperties buildSerializableProperties(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        if (!SerializationFirUtilsKt.getHasSerializableOrMetaAnnotation(checkerContext, classSymbol)) {
            return null;
        }
        if (!SerializationFirUtilsKt.isInternalSerializable(classSymbol)) {
            return null;
        }
        if (SerializationFirUtilsKt.getHasCompanionObjectAsSerializer(classSymbol)) {
            return null;
        }
        FirSerializableProperties properties = FirSerializablePropertiesProviderKt.getSerializablePropertiesProvider(checkerContext.getSession()).getSerializablePropertiesForClass(classSymbol);
        if (!properties.isExternallySerializable()) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY(), null, (int)8, null);
        }
        Set namesSet = new LinkedHashSet();
        for (FirSerializableProperty property2 : properties.getSerializableProperties()) {
            String name = property2.getName();
            if (namesSet.add(name)) continue;
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol)), FirSerializationErrors.INSTANCE.getDUPLICATE_SERIAL_NAME(), (Object)name, null, (int)16, null);
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTransients(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, DiagnosticReporter reporter) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = classSymbol.getDeclarationSymbols();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (FirPropertySymbol propertySymbol : (List)destination$iv$iv) {
            boolean isInitialized;
            FirCallableSymbol $this$isLateInit$iv = (FirCallableSymbol)propertySymbol;
            boolean $i$f$isLateInit = false;
            boolean bl = isInitialized = $this$isLateInit$iv.getRawStatus().isLateInit() || this.declarationHasInitializer(propertySymbol);
            if (SerializationFirUtilsKt.getSerialTransientAnnotation((FirBasedSymbol)propertySymbol) == null) continue;
            boolean hasBackingField = DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)propertySymbol);
            if (!hasBackingField) {
                FirAnnotation transientAnnotation;
                DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
                KtSourceElement ktSourceElement = transientAnnotation.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = propertySymbol.getSource();
                }
                KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getTRANSIENT_IS_REDUNDANT(), null, (int)8, null);
                continue;
            }
            if (isInitialized) continue;
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)propertySymbol.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getTRANSIENT_MISSING_INITIALIZER(), null, (int)8, null);
        }
    }

    private final boolean declarationHasInitializer(FirPropertySymbol propertySymbol) {
        boolean bl;
        if (DeclarationAttributesKt.getFromPrimaryConstructor((FirPropertySymbol)propertySymbol)) {
            FirValueParameterSymbol firValueParameterSymbol = DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirPropertySymbol)propertySymbol);
            bl = firValueParameterSymbol != null ? firValueParameterSymbol.getHasDefaultValue() : false;
        } else {
            bl = propertySymbol.getHasInitializer() || propertySymbol.getHasDelegate();
        }
        return bl;
    }

    private final void analyzePropertiesSerializers(CheckerContext checkerContext, FirClassSymbol<?> classSymbol, List<FirSerializableProperty> properties, DiagnosticReporter reporter) {
        for (FirSerializableProperty property2 : properties) {
            KtSourceElement source;
            ConeKotlinType serializerType;
            ConeKotlinType coneKotlinType = serializerType = property2.getSerializableWith();
            FirRegularClassSymbol serializerSymbol = coneKotlinType != null ? TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)coneKotlinType, (FirSession)checkerContext.getSession()) : null;
            FirPropertySymbol propertySymbol = property2.getPropertySymbol();
            FirResolvedTypeRef typeRef = propertySymbol.getResolvedReturnTypeRef();
            ConeKotlinType propertyType = FirTypeUtilsKt.getConeType((FirTypeRef)((FirTypeRef)typeRef));
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = source = propertySymbol.getSource();
            }
            if (serializerType != null && serializerSymbol != null) {
                KtSourceElement ktSourceElement2 = typeRef.getSource();
                if (ktSourceElement2 == null) {
                    ktSourceElement2 = propertySymbol.getSource();
                }
                this.checkCustomSerializerMatch(checkerContext, classSymbol, ktSourceElement2, propertyType, serializerType, reporter);
                FirAnnotation firAnnotation = SerializationFirUtilsKt.serializableAnnotation((FirBasedSymbol)propertySymbol, false);
                this.checkCustomSerializerIsNotLocal(checkerContext, (KtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null), classSymbol, serializerType, reporter);
                this.checkSerializerNullability(checkerContext, propertyType, serializerType, source, reporter);
                continue;
            }
            this.checkType(checkerContext, propertyType, source, reporter);
        }
    }

    private final void checkTypeArguments(CheckerContext checkerContext, ConeKotlinType type, KtSourceElement source, DiagnosticReporter reporter) {
        for (ConeTypeProjection typeArgument : type.getTypeArguments()) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)typeArgument);
            if (coneKotlinType == null) continue;
            this.checkType(checkerContext, coneKotlinType, source, reporter);
        }
    }

    private final boolean canSupportInlineClasses(CheckerContext checkerContext) {
        return FirVersionReaderKt.getVersionReader(checkerContext.getSession()).getCanSupportInlineClasses();
    }

    private final boolean isUnsupportedInlineType(CheckerContext checkerContext, ConeKotlinType $this$isUnsupportedInlineType) {
        return FirHelpersKt.isInlineClass((ConeKotlinType)$this$isUnsupportedInlineType, (FirSession)checkerContext.getSession()) && !ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive((ConeKotlinType)$this$isUnsupportedInlineType);
    }

    private static /* synthetic */ void isUnsupportedInlineType$annotations(ConeKotlinType coneKotlinType) {
    }

    private final void checkType(CheckerContext checkerContext, ConeKotlinType type, KtSourceElement source, DiagnosticReporter reporter) {
        FirClassSymbol<?> serializer2;
        if (SerializationFirUtilsKt.isTypeParameter((ConeKotlinType)ConeTypeUtilsKt.lowerBoundIfFlexible((ConeKotlinType)type))) {
            return;
        }
        if (this.isUnsupportedInlineType(checkerContext, type) && !this.canSupportInlineClasses(checkerContext)) {
            RuntimeVersions runtimeVersions2 = FirVersionReaderKt.getVersionReader(checkerContext.getSession()).getRuntimeVersions();
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getINLINE_CLASSES_NOT_SUPPORTED(), (Object)RuntimeVersions.Companion.getMINIMAL_VERSION_FOR_INLINE_CLASSES().toString(), (Object)String.valueOf(runtimeVersions2 != null ? runtimeVersions2.getImplementationVersion() : null), null, (int)32, null);
        }
        if ((serializer2 = ContextualSerializersProviderKt.findTypeSerializerOrContextUnchecked(checkerContext, type)) != null) {
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)type, (FirSession)checkerContext.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol classSymbol = firRegularClassSymbol;
            ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializableWith(checkerContext, type);
            if (coneKotlinType != null && (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)checkerContext.getSession())) != null) {
                ConeKotlinType serializerType = coneKotlinType;
                boolean bl = false;
                INSTANCE.checkCustomSerializerMatch(checkerContext, (FirClassSymbol)classSymbol, source, type, serializerType, reporter);
                INSTANCE.checkCustomSerializerIsNotLocal(checkerContext, source, (FirClassSymbol)classSymbol, serializerType, reporter);
                INSTANCE.checkSerializerNullability(checkerContext, type, serializerType, source, reporter);
            }
            this.checkTypeArguments(checkerContext, type, source, reporter);
        } else {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getSERIALIZER_NOT_FOUND(), (Object)type, null, (int)16, null);
        }
    }

    private final void checkCustomSerializerMatch(CheckerContext checkerContext, FirClassSymbol<?> containingClassSymbol, KtSourceElement source, ConeKotlinType declarationType, ConeKotlinType serializerType, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.serializerForType(serializerType, checkerContext.getSession());
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializerForType = coneKotlinType;
        ClassId declarationTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)declarationType);
        if (declarationTypeClassId == null || !Intrinsics.areEqual((Object)declarationTypeClassId, (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)serializerForType))) {
            DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                ktSourceElement = this.getSerializableOrMetaAnnotationSource(checkerContext, containingClassSymbol);
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), FirSerializationErrors.INSTANCE.getSERIALIZER_TYPE_INCOMPATIBLE(), (Object)ScopeUtilsKt.defaultType(containingClassSymbol), (Object)serializerType, (Object)serializerForType, null, (int)64, null);
        }
    }

    private final void checkCustomSerializerIsNotLocal(CheckerContext checkerContext, KtSourceElement source, FirClassSymbol<?> classSymbol, ConeKotlinType serializerType, DiagnosticReporter reporter) {
        ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)serializerType);
        if (classId == null) {
            return;
        }
        ClassId serializerClassId = classId;
        if (serializerClassId.isLocal()) {
            DiagnosticContext diagnosticContext = (DiagnosticContext)checkerContext;
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                ktSourceElement = this.getSerializableOrMetaAnnotationSource(checkerContext, classSymbol);
            }
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), FirSerializationErrors.INSTANCE.getLOCAL_SERIALIZER_USAGE(), (Object)serializerType, null, (int)16, null);
        }
    }

    private final void checkSerializerNullability(CheckerContext checkerContext, ConeKotlinType classType, ConeKotlinType serializerType, KtSourceElement source, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.serializerForType(serializerType, checkerContext.getSession());
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType serializerForType = coneKotlinType;
        if (!ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)classType) && ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)serializerForType)) {
            KtDiagnosticReportContextHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)checkerContext), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirSerializationErrors.INSTANCE.getSERIALIZER_NULLABILITY_INCOMPATIBLE(), (Object)serializerType, (Object)classType, null, (int)32, null);
        }
    }

    private final boolean isSerializableEnumWithMissingSerializer(CheckerContext checkerContext, FirClassSymbol<?> $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            FirClassSymbol<?> $this$isEnumClass$iv = $this$isSerializableEnumWithMissingSerializer;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                return false;
            }
            if (SerializationFirUtilsKt.getHasSerializableOrMetaAnnotation(checkerContext, $this$isSerializableEnumWithMissingSerializer)) {
                return false;
            }
            if (SerializationFirUtilsKt.getHasAnySerialAnnotation(checkerContext, (FirBasedSymbol)$this$isSerializableEnumWithMissingSerializer)) {
                return true;
            }
            Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                    boolean bl2 = false;
                    if (!SerializationFirUtilsKt.getHasAnySerialAnnotation(checkerContext, (FirBasedSymbol)it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static /* synthetic */ void isSerializableEnumWithMissingSerializer$annotations(FirClassSymbol firClassSymbol) {
    }

    private final KtSourceElement getSerializableOrMetaAnnotationSource(CheckerContext checkerContext, FirClassSymbol<?> $this$serializableOrMetaAnnotationSource) {
        FirAnnotation firAnnotation = SerializationFirUtilsKt.serializableAnnotation((FirBasedSymbol)$this$serializableOrMetaAnnotationSource, false);
        if (firAnnotation != null && (firAnnotation = firAnnotation.getSource()) != null) {
            FirAnnotation it = firAnnotation;
            boolean bl = false;
            return it;
        }
        FirAnnotation firAnnotation2 = SerializationFirUtilsKt.metaSerializableAnnotation(checkerContext, $this$serializableOrMetaAnnotationSource, false);
        if (firAnnotation2 != null && (firAnnotation2 = firAnnotation2.getSource()) != null) {
            FirAnnotation it = firAnnotation2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static /* synthetic */ void getSerializableOrMetaAnnotationSource$annotations(FirClassSymbol firClassSymbol) {
    }

    private final boolean getSerializableAnnotationIsUseless(CheckerContext checkerContext, FirClassSymbol<?> $this$serializableAnnotationIsUseless) {
        ClassKind $this$isEnumClass$iv = $this$serializableAnnotationIsUseless.getClassKind();
        boolean $i$f$isEnumClass = false;
        return !($this$isEnumClass$iv == ClassKind.ENUM_CLASS) && SerializationFirUtilsKt.getHasSerializableOrMetaAnnotationWithoutArgs(checkerContext, $this$serializableAnnotationIsUseless) && !SerializationFirUtilsKt.isInternalSerializable($this$serializableAnnotationIsUseless) && !SerializationFirUtilsKt.getHasCompanionObjectAsSerializer($this$serializableAnnotationIsUseless) && !SerializationFirUtilsKt.isSealedSerializableInterface($this$serializableAnnotationIsUseless);
    }

    private static /* synthetic */ void getSerializableAnnotationIsUseless$annotations(FirClassSymbol firClassSymbol) {
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<ClassId, FirAnnotation>> checkInheritedAnnotations$annotationsFilter(CheckerContext $this, List<? extends FirAnnotation> annotations) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirAnnotation it = (FirAnnotation)element$iv$iv;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol((FirTypeRef)it.getAnnotationTypeRef(), (FirSession)$this.getSession());
            boolean bl2 = firRegularClassSymbol != null ? SerializationFirUtilsKt.isInheritableSerialInfoAnnotation((FirBasedSymbol)firRegularClassSymbol) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FirAnnotation annotation = (FirAnnotation)element$iv$iv;
            boolean bl3 = false;
            FirAnnotation $this$classId$iv = annotation;
            boolean $i$f$getClassId = false;
            FirAnnotation $this$coneClassLikeType$iv$iv = $this$classId$iv;
            boolean $i$f$getConeClassLikeType = false;
            FirTypeRef firTypeRef = $this$coneClassLikeType$iv$iv.getAnnotationTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            Object object = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            ConeClassLikeType coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if ((coneClassLikeType != null && (coneClassLikeType = coneClassLikeType.getLookupTag()) != null ? coneClassLikeType.getClassId() : null) != null) {
                ClassId it;
                it = it;
                boolean bl4 = false;
                pair = TuplesKt.to((Object)it, (Object)annotation);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        ClassId classId = ClassId.topLevel((FqName)new FqName("java.io.Serializable"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(\"java.io.Serializable\"))");
        JAVA_SERIALIZABLE_ID = classId;
    }
}

