/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.fir.SerializationFirUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.services.ContextualSerializersProviderKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializableProperty;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/fir/FirSerializableProperty;", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/ISerializableProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "propertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isConstructorParameterWithDefault", "", "declaresDefaultValue", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;ZZ)V", "()Z", "name", "", "getName", "()Ljava/lang/String;", "optional", "getOptional", "originalDescriptorName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalDescriptorName", "()Lorg/jetbrains/kotlin/name/Name;", "getPropertySymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "serializableWith", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSerializableWith", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "transient", "getTransient", "kotlin-maven-serialization"})
public final class FirSerializableProperty
implements ISerializableProperty {
    @NotNull
    private final FirPropertySymbol propertySymbol;
    private final boolean isConstructorParameterWithDefault;
    @NotNull
    private final String name;
    private final boolean optional;
    private final boolean transient;
    @Nullable
    private final ConeKotlinType serializableWith;

    public FirSerializableProperty(@NotNull FirSession session, @NotNull FirPropertySymbol propertySymbol, boolean isConstructorParameterWithDefault, boolean declaresDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)propertySymbol, (String)"propertySymbol");
        this.propertySymbol = propertySymbol;
        this.isConstructorParameterWithDefault = isConstructorParameterWithDefault;
        String string = SerializationFirUtilsKt.getSerialNameValue((FirBasedSymbol)this.propertySymbol);
        if (string == null) {
            String string2 = this.propertySymbol.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"propertySymbol.name.asString()");
        }
        this.name = string;
        this.optional = !SerializationFirUtilsKt.getSerialRequired((FirBasedSymbol)this.propertySymbol) && declaresDefaultValue;
        this.transient = SerializationFirUtilsKt.getHasSerialTransient((FirBasedSymbol)this.propertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)this.propertySymbol);
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)this.propertySymbol);
        if (coneKotlinType == null) {
            FirClassSymbol<?> firClassSymbol = ContextualSerializersProviderKt.analyzeSpecialSerializers(session, this.propertySymbol.getResolvedAnnotationsWithArguments());
            coneKotlinType = (ConeKotlinType)(firClassSymbol != null ? ScopeUtilsKt.defaultType(firClassSymbol) : null);
        }
        this.serializableWith = coneKotlinType;
    }

    @NotNull
    public final FirPropertySymbol getPropertySymbol() {
        return this.propertySymbol;
    }

    @Override
    public boolean isConstructorParameterWithDefault() {
        return this.isConstructorParameterWithDefault;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Name getOriginalDescriptorName() {
        return this.propertySymbol.getName();
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public boolean getTransient() {
        return this.transient;
    }

    @Nullable
    public final ConeKotlinType getSerializableWith() {
        return this.serializableWith;
    }
}

