/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.BaseIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrPredicatesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrSerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrSerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SERIALIZATION_PLUGIN_ORIGIN;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializationBaseContext;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerSearchUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationPluginContext;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/BaseIrGenerator;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generate", "", "preGenerateDeserializationConstructorIfNeeded", "preGenerateWriteSelfMethodIfNeeded", "makeNullableIfNotPrimitive", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Companion", "kotlin-maven-serialization"})
@SourceDebugExtension(value={"SMAP\nIrPreGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrPreGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator\n+ 2 IrPredicates.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPredicatesKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n251#2:137\n191#3:138\n185#3:139\n179#3,10:140\n229#3:161\n223#3,13:162\n1549#4:150\n1620#4,3:151\n1549#4:154\n1620#4,3:155\n1860#4,3:158\n*S KotlinDebug\n*F\n+ 1 IrPreGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator\n*L\n46#1:137\n48#1:138\n48#1:139\n48#1:140,10\n102#1:161\n102#1:162,13\n59#1:150\n59#1:151,3\n64#1:154\n64#1:155,3\n85#1:158,3\n*E\n"})
public final class IrPreGenerator
extends BaseIrGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;

    public IrPreGenerator(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
        super(irClass, compilerContext);
        this.irClass = irClass;
    }

    @NotNull
    public final IrClass getIrClass() {
        return this.irClass;
    }

    private final void generate() {
        this.preGenerateWriteSelfMethodIfNeeded();
        this.preGenerateDeserializationConstructorIfNeeded();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void preGenerateWriteSelfMethodIfNeeded() {
        Collection collection;
        void $this$mapTo$iv$iv;
        IrSimpleFunction irSimpleFunction;
        if (!IrPredicatesKt.isInternalSerializable(this.irClass)) {
            return;
        }
        IrClassSymbol irClassSymbol = SerializerSearchUtilKt.classSerializer(this.irClass, this.getCompilerContext());
        IrClassSymbol irClassSymbol2 = irClassSymbol;
        if (irClassSymbol == null) return;
        if ((irClassSymbol2 = (IrClass)irClassSymbol2.getOwner()) == null) {
            return;
        }
        IrClassSymbol serializerDescriptor = irClassSymbol2;
        IrClass $this$shouldHaveSpecificSyntheticMethods$iv = this.irClass;
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        if ($this$shouldHaveSpecificSyntheticMethods$iv.isValue()) return;
        if (!IrPredicatesKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
            boolean bl = false;
            if (IrPredicatesKt.findPluginGeneratedMethod((IrClass)serializerDescriptor, "serialize") == null) return;
        }
        boolean bl = true;
        if (!bl) {
            return;
        }
        if (IrPredicatesKt.findWriteSelfMethod(this.irClass) != null) {
            return;
        }
        IrClass $this$addFunction$iv = this.irClass;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction22 = false;
        IrFactory irFactory = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2418$iv$iv$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241 = $this$buildFun_u24lambda_u2418$iv$iv$iv;
        boolean bl3 = false;
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setName(SerialEntityNames.INSTANCE.getWRITE_SELF_NAME());
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setReturnType(this.getCompilerContext().getIrBuiltIns().getUnitType());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setVisibility(descriptorVisibility);
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setModality(Modality.FINAL);
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setOrigin((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE);
        IrSimpleFunction function$iv$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)irFactory, (IrFunctionBuilder)$this$buildFun_u24lambda_u2418$iv$iv$iv);
        boolean bl4 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
        function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
        IrSimpleFunction method = irSimpleFunction;
        IrClass $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u242 = $this$addFunction$iv = method;
        boolean bl5 = false;
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u242.setDispatchReceiverParameter(null);
        Iterable $this$map$iv = this.irClass.getTypeParameters();
        boolean $i$f$map = false;
        Iterable $i$f$addFunction22 = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241 = (IrTypeParameter)item$iv$iv;
            collection = collection2;
            boolean bl6 = false;
            IrTypeParametersContainer irTypeParametersContainer = (IrTypeParametersContainer)method;
            String string = it.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name.asString()");
            collection.add(DeclarationBuildersKt.addTypeParameter$default((IrTypeParametersContainer)irTypeParametersContainer, (String)string, (IrType)this.getCompilerContext().getIrBuiltIns().getAnyNType(), null, (int)4, null));
        }
        List typeParams = (List)collection2;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable) {
            void it;
            IrTypeParameter bl6 = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            collection.add(IrTypesKt.getDefaultType((IrTypeParameter)it));
        }
        List typeParamsAsArguments = (List)destination$iv$iv;
        IrFunction irFunction = (IrFunction)method;
        Name name = Name.identifier((String)"self");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"self\")");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction, (Name)name, (IrType)((IrType)IrTypesKt.typeWith((IrClass)this.irClass, (List)typeParamsAsArguments)), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        IrFunction irFunction2 = (IrFunction)method;
        Name name2 = Name.identifier((String)"output");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"output\")");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction2, (Name)name2, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "CompositeEncoder", new FqName[0]))), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        IrClassSymbol serialDescriptorSymbol = SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "SerialDescriptor", new FqName[0]);
        IrFunction irFunction3 = (IrFunction)method;
        Name name3 = Name.identifier((String)"serialDesc");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(\"serialDesc\")");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction3, (Name)name3, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)serialDescriptorSymbol)), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        IrClassSymbol kSerializerSymbol = SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "KSerializer", new FqName[0]);
        Iterable iterable2 = typeParamsAsArguments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            void it;
            int n;
            Object item$iv = iterator.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrType bl7 = (IrType)item$iv;
            int i = n;
            boolean bl8 = false;
            IrFunction irFunction4 = (IrFunction)method;
            Name name4 = Name.identifier((String)("typeSerial" + i));
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(\"${SerialEntityNames.typeArgPrefix}$i\")");
            IrType[] irTypeArray = new IrType[]{it};
            DeclarationBuildersKt.addValueParameter((IrFunction)irFunction4, (Name)name4, (IrType)((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)kSerializerSymbol), (IrType[])irTypeArray)), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        }
    }

    private final void preGenerateDeserializationConstructorIfNeeded() {
        IrClass irClass;
        if (!IrPredicatesKt.isInternalSerializable(this.irClass)) {
            return;
        }
        if (IrPredicatesKt.getHasCompanionObjectAsSerializer(this.irClass) && ((irClass = AdditionalIrUtilsKt.companionObject((IrClass)this.irClass)) != null ? IrPredicatesKt.findPluginGeneratedMethod(irClass, "deserialize") : null) == null) {
            return;
        }
        if (this.irClass.isValue()) {
            return;
        }
        if (IrPredicatesKt.findSerializableSyntheticConstructor(this.irClass) != null) {
            return;
        }
        IrClass $this$addConstructor$iv = this.irClass;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2423$iv = $this$buildConstructor_u24lambda_u2422$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246 = $this$addConstructor_u24lambda_u2423$iv;
        boolean bl3 = false;
        $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246.setOrigin((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
        $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2423$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2422$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrFactory ctor = $this$buildConstructor$iv$iv;
        SerializationBaseContext serializationBaseContext = this.getCompilerContext();
        String string = SerialEntityNames.INSTANCE.getSERIAL_CTOR_MARKER_NAME().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SerialEntityNames.SERIAL\u2026OR_MARKER_NAME.asString()");
        IrClassSymbol markerClassSymbol = SerializerSearchUtilKt.getClassFromInternalSerializationPackage(serializationBaseContext, string);
        List<IrSerializableProperty> serializableProperties2 = IrSerializablePropertiesKt.serializablePropertiesForIrBackend$default(this.irClass, null, null, 6, null).getSerializableProperties();
        int bitMaskSlotsCount = ISerializablePropertiesKt.bitMaskSlotCount(serializableProperties2);
        int n = 0;
        while (n < bitMaskSlotsCount) {
            int it = n++;
            boolean bl5 = false;
            IrFunction irFunction = (IrFunction)ctor;
            Name name = Name.identifier((String)("seen" + it));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"seen$it\")");
            DeclarationBuildersKt.addValueParameter((IrFunction)irFunction, (Name)name, (IrType)this.getCompilerContext().getIrBuiltIns().getIntType(), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        }
        for (IrSerializableProperty prop : serializableProperties2) {
            DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)ctor), (String)prop.getName(), (IrType)this.makeNullableIfNotPrimitive((IrType)prop.getType()), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
        }
        DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)ctor), (Name)SerialEntityNames.INSTANCE.getDummyParamName(), (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)markerClassSymbol)), (IrDeclarationOrigin)((IrDeclarationOrigin)SERIALIZATION_PLUGIN_ORIGIN.INSTANCE));
    }

    private final IrType makeNullableIfNotPrimitive(IrType $this$makeNullableIfNotPrimitive) {
        return IrTypePredicatesKt.isPrimitiveType((IrType)$this$makeNullableIfNotPrimitive, (boolean)false) ? $this$makeNullableIfNotPrimitive : IrTypesKt.makeNullable((IrType)$this$makeNullableIfNotPrimitive);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator$Companion;", "", "()V", "generate", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "kotlin-maven-serialization"})
    public static final class Companion {
        private Companion() {
        }

        public final void generate(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
            if (!IrPredicatesKt.isInternalSerializable(irClass)) {
                return;
            }
            new IrPreGenerator(irClass, compilerContext).generate();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

