/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.CreationListener;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactory;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;
import org.jetbrains.kotlin.com.google.inject.spi.PrivateElements;

final class ExposedKeyFactory<T>
implements CreationListener,
InternalFactory<T> {
    private final Key<T> key;
    private final PrivateElements privateElements;
    private BindingImpl<T> delegate;

    ExposedKeyFactory(Key<T> key, PrivateElements privateElements) {
        this.key = key;
        this.privateElements = privateElements;
    }

    @Override
    public void notify(Errors errors) {
        InjectorImpl privateInjector = (InjectorImpl)this.privateElements.getInjector();
        BindingImpl<T> explicitBinding = privateInjector.getBindingData().getExplicitBinding(this.key);
        if (explicitBinding.getInternalFactory() == this) {
            errors.withSource(explicitBinding.getSource()).exposedButNotBound(this.key);
            return;
        }
        this.delegate = explicitBinding;
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        return this.delegate.getInternalFactory().get(context, dependency, linked);
    }
}

