/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect;

import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.jetbrains.kotlin.org.eclipse.aether.impl.DependencyCollector;
import org.jetbrains.kotlin.org.eclipse.aether.impl.RemoteRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.impl.VersionRangeResolver;
import org.jetbrains.kotlin.org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DependencyCollectorDelegate
implements DependencyCollector {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RemoteRepositoryManager remoteRepositoryManager;
    protected ArtifactDescriptorReader descriptorReader;
    protected VersionRangeResolver versionRangeResolver;

    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
    }

    public DependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository manager cannot be null");
        return this;
    }

    public DependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.descriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }
}

