/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerDependency;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.NonTargetedCommonizerDependency;
import org.jetbrains.kotlin.commonizer.ParseCommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.TargetedCommonizerDependency;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\n"}, d2={"identityString", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerDependency;", "getIdentityString", "(Lorg/jetbrains/kotlin/commonizer/CommonizerDependency;)Ljava/lang/String;", "parseCommonizerDependency", "parseTargetedCommonizerDependencyOrNull", "Lorg/jetbrains/kotlin/commonizer/TargetedCommonizerDependency;", "commonizerTarget", "canonicalFilePath", "kotlin-klib-commonizer-api"})
public final class CommonizerDependencyKt {
    @NotNull
    public static final String getIdentityString(@NotNull CommonizerDependency $this$identityString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$identityString, (String)"<this>");
        CommonizerDependency commonizerDependency = $this$identityString;
        if (commonizerDependency instanceof NonTargetedCommonizerDependency) {
            String string2 = $this$identityString.getFile().getCanonicalPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.file.canonicalPath");
        } else if (commonizerDependency instanceof TargetedCommonizerDependency) {
            string = CommonizerTargetKt.getIdentityString(((TargetedCommonizerDependency)$this$identityString).getTarget()) + "::" + $this$identityString.getFile().getCanonicalPath();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final CommonizerDependency parseCommonizerDependency(@NotNull String identityString) {
        Intrinsics.checkNotNullParameter((Object)identityString, (String)"identityString");
        Object object = new String[]{"::"};
        List split = StringsKt.split$default((CharSequence)identityString, (String[])object, (boolean)false, (int)2, (int)2, null);
        if (split.size() == 2 && (object = CommonizerDependencyKt.parseTargetedCommonizerDependencyOrNull((String)split.get(0), (String)split.get(1))) != null) {
            Object it = object;
            boolean bl = false;
            return (CommonizerDependency)it;
        }
        return new NonTargetedCommonizerDependency(new File(identityString));
    }

    private static final TargetedCommonizerDependency parseTargetedCommonizerDependencyOrNull(String commonizerTarget, String canonicalFilePath) {
        CommonizerTarget commonizerTarget2 = ParseCommonizerTargetKt.parseCommonizerTargetOrNull(commonizerTarget);
        if (commonizerTarget2 == null) {
            return null;
        }
        return new TargetedCommonizerDependency(commonizerTarget2, new File(canonicalFilePath));
    }
}

