/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatformAnalyzerServices;", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "()V", "defaultLowPriorityImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getDefaultLowPriorityImports", "()Ljava/util/List;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "computePlatformSpecificDefaultImports", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "result", "", "frontend.java"})
public final class JvmPlatformAnalyzerServices
extends PlatformDependentAnalyzerServices {
    @NotNull
    public static final JvmPlatformAnalyzerServices INSTANCE = new JvmPlatformAnalyzerServices();
    @NotNull
    private static final List<ImportPath> defaultLowPriorityImports = CollectionsKt.listOf((Object)ImportPath.Companion.fromString("java.lang.*"));
    @NotNull
    private static final PlatformConfigurator platformConfigurator = (PlatformConfigurator)JvmPlatformConfigurator.INSTANCE;

    private JvmPlatformAnalyzerServices() {
    }

    public void computePlatformSpecificDefaultImports(@NotNull StorageManager storageManager, @NotNull List<ImportPath> result) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        result.add(ImportPath.Companion.fromString("kotlin.jvm.*"));
        for (PackageViewDescriptor builtInPackage : new JvmBuiltIns(storageManager, JvmBuiltIns.Kind.FALLBACK).getBuiltInPackagesImportedByDefault()) {
            JvmPlatformAnalyzerServices.computePlatformSpecificDefaultImports$addAllClassifiersFromScope(result, builtInPackage.getMemberScope());
        }
    }

    @NotNull
    public List<ImportPath> getDefaultLowPriorityImports() {
        return defaultLowPriorityImports;
    }

    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    private static final void computePlatformSpecificDefaultImports$addAllClassifiersFromScope(List<ImportPath> $result, MemberScope scope2) {
        for (DeclarationDescriptor descriptor2 : scope2.getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER())) {
            FqName fqName2 = DescriptorUtils.getFqNameSafe(descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameSafe(...)");
            $result.add(new ImportPath(fqName2, false, null, 4, null));
        }
    }
}

