/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/TypeParameterBoundIsNotArrayChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class TypeParameterBoundIsNotArrayChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        List<TypeParameterDescriptor> list;
        Object object;
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor2 = callableDescriptor = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null;
        if (callableDescriptor == null) {
            Object object2 = object = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
            if (object == null) {
                return;
            }
            list = object.getDeclaredTypeParameters();
        } else {
            list = callableDescriptor.getTypeParameters();
        }
        List<TypeParameterDescriptor> list2 = list;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"(descriptor as? Callable\u2026ers\n            ?: return");
        List<TypeParameterDescriptor> typeParameters = list2;
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            boolean bl;
            block7: {
                object = typeParameter.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeParameter.upperBounds");
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!(KotlinBuiltIns.isArray(it) || KotlinBuiltIns.isPrimitiveArray(it))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            Intrinsics.checkNotNullExpressionValue((Object)typeParameter, (String)"typeParameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)typeParameter);
            PsiElement element = psiElement == null ? (PsiElement)declaration : psiElement;
            context.getTrace().report((Diagnostic)ErrorsJvm.UPPER_BOUND_CANNOT_BE_ARRAY.on(element));
        }
    }
}

