/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/ConstantsChecker;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "containsKotlinConstVals", "", "getContainsKotlinConstVals", "()Z", "setContainsKotlinConstVals", "(Z)V", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "frontend.java"})
final class ConstantsChecker
extends KtVisitorVoid {
    @NotNull
    private final BindingContext bindingContext;
    private boolean containsKotlinConstVals;

    public ConstantsChecker(@NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.bindingContext = bindingContext;
    }

    public final boolean getContainsKotlinConstVals() {
        return this.containsKotlinConstVals;
    }

    public final void setContainsKotlinConstVals(boolean bl) {
        this.containsKotlinConstVals = bl;
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.bindingContext);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor && !(callableDescriptor instanceof JavaPropertyDescriptor) && ((PropertyDescriptor)callableDescriptor).isConst()) {
            this.containsKotlinConstVals = true;
        }
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.containsKotlinConstVals) {
            element.acceptChildren((PsiElementVisitor)this);
        }
    }
}

