/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.BigArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongBigArrays;

public final class DoubleBigArrays {
    public static final double[][] EMPTY_BIG_ARRAY = new double[0][];
    public static final double[][] DEFAULT_EMPTY_BIG_ARRAY = new double[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    private static final int RADIXSORT_NO_REC = 1024;

    private DoubleBigArrays() {
    }

    @Deprecated
    public static double get(double[][] array2, long index) {
        return array2[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    @Deprecated
    public static void set(double[][] array2, long index, double value2) {
        array2[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value2;
    }

    @Deprecated
    public static void swap(double[][] array2, long first, long second) {
        double t = array2[BigArrays.segment(first)][BigArrays.displacement(first)];
        array2[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array2[BigArrays.segment(second)][BigArrays.displacement(second)];
        array2[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    @Deprecated
    public static void add(double[][] array2, long index, double incr) {
        double[] dArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + incr;
    }

    @Deprecated
    public static void mul(double[][] array2, long index, double factor) {
        double[] dArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] * factor;
    }

    @Deprecated
    public static void incr(double[][] array2, long index) {
        double[] dArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] + 1.0;
    }

    @Deprecated
    public static void decr(double[][] array2, long index) {
        double[] dArray = array2[BigArrays.segment(index)];
        int n = BigArrays.displacement(index);
        dArray[n] = dArray[n] - 1.0;
    }

    @Deprecated
    public static long length(double[][] array2) {
        int length = array2.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array2[length - 1].length;
    }

    @Deprecated
    public static void copy(double[][] srcArray, long srcPos, double[][] destArray, long destPos, long length) {
        BigArrays.copy(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyFromBig(double[][] srcArray, long srcPos, double[] destArray, int destPos, int length) {
        BigArrays.copyFromBig(srcArray, srcPos, destArray, destPos, length);
    }

    @Deprecated
    public static void copyToBig(double[] srcArray, int srcPos, double[][] destArray, long destPos, long length) {
        BigArrays.copyToBig(srcArray, srcPos, destArray, destPos, length);
    }

    public static double[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = new double[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new double[0x8000000];
            }
            base[baseLength - 1] = new double[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new double[0x8000000];
            }
        }
        return base;
    }

    @Deprecated
    public static double[][] wrap(double[] array2) {
        return BigArrays.wrap(array2);
    }

    @Deprecated
    public static double[][] ensureCapacity(double[][] array2, long length) {
        return DoubleBigArrays.ensureCapacity(array2, length, DoubleBigArrays.length(array2));
    }

    @Deprecated
    public static double[][] forceCapacity(double[][] array2, long length, long preserve) {
        return BigArrays.forceCapacity(array2, length, preserve);
    }

    @Deprecated
    public static double[][] ensureCapacity(double[][] array2, long length, long preserve) {
        return length > DoubleBigArrays.length(array2) ? DoubleBigArrays.forceCapacity(array2, length, preserve) : array2;
    }

    @Deprecated
    public static double[][] grow(double[][] array2, long length) {
        long oldLength = DoubleBigArrays.length(array2);
        return length > oldLength ? DoubleBigArrays.grow(array2, length, oldLength) : array2;
    }

    @Deprecated
    public static double[][] grow(double[][] array2, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array2);
        return length > oldLength ? DoubleBigArrays.ensureCapacity(array2, Math.max(oldLength + (oldLength >> 1), length), preserve) : array2;
    }

    @Deprecated
    public static double[][] trim(double[][] array2, long length) {
        BigArrays.ensureLength(length);
        long oldLength = DoubleBigArrays.length(array2);
        if (length >= oldLength) {
            return array2;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = (double[][])Arrays.copyOf(array2, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = DoubleArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static double[][] setLength(double[][] array2, long length) {
        return BigArrays.setLength(array2, length);
    }

    @Deprecated
    public static double[][] copy(double[][] array2, long offset, long length) {
        return BigArrays.copy(array2, offset, length);
    }

    @Deprecated
    public static double[][] copy(double[][] array2) {
        return BigArrays.copy(array2);
    }

    @Deprecated
    public static void fill(double[][] array2, double value2) {
        int i2 = array2.length;
        while (i2-- != 0) {
            Arrays.fill(array2[i2], value2);
        }
    }

    @Deprecated
    public static void fill(double[][] array2, long from2, long to, double value2) {
        BigArrays.fill(array2, from2, to, value2);
    }

    @Deprecated
    public static boolean equals(double[][] a1, double[][] a2) {
        return BigArrays.equals(a1, a2);
    }

    @Deprecated
    public static String toString(double[][] a) {
        return BigArrays.toString(a);
    }

    @Deprecated
    public static void ensureFromTo(double[][] a, long from2, long to) {
        BigArrays.ensureFromTo(DoubleBigArrays.length(a), from2, to);
    }

    @Deprecated
    public static void ensureOffsetLength(double[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength(DoubleBigArrays.length(a), offset, length);
    }

    @Deprecated
    public static void ensureSameLength(double[][] a, double[][] b) {
        if (DoubleBigArrays.length(a) != DoubleBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + DoubleBigArrays.length(a) + " != " + DoubleBigArrays.length(b));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current2 = ForkJoinTask.getPool();
        return current2 == null ? ForkJoinPool.commonPool() : current2;
    }

    private static void swap(double[][] x, long a, long b, long n) {
        int i2 = 0;
        while ((long)i2 < n) {
            BigArrays.swap(x, a, b);
            ++i2;
            ++a;
            ++b;
        }
    }

    private static long med3(double[][] x, long a, long b, long c, DoubleComparator comp) {
        int ab = comp.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = comp.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = comp.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(double[][] a, long from2, long to, DoubleComparator comp) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(double[][] x, long from2, long to, DoubleComparator comp) {
        long c;
        long a;
        long len = to - from2;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x, from2, to, comp);
            return;
        }
        long m = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = DoubleBigArrays.med3(x, m - s, m, m + s, comp);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = DoubleBigArrays.med3(x, l, m, n, comp);
        }
        double v = BigArrays.get(x, m);
        long b = a = from2;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from2, b - a);
        DoubleBigArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(double[][] x, long a, long b, long c) {
        int ab = Double.compare(BigArrays.get(x, a), BigArrays.get(x, b));
        int ac = Double.compare(BigArrays.get(x, a), BigArrays.get(x, c));
        int bc = Double.compare(BigArrays.get(x, b), BigArrays.get(x, c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(double[][] a, long from2, long to) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (Double.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            BigArrays.swap(a, i2, m);
        }
    }

    public static void quickSort(double[][] x, DoubleComparator comp) {
        DoubleBigArrays.quickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static void quickSort(double[][] x, long from2, long to) {
        long c;
        long a;
        long len = to - from2;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x, from2, to);
            return;
        }
        long m = from2 + len / 2L;
        if (len > 7L) {
            long l = from2;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s);
                m = DoubleBigArrays.med3(x, m - s, m, m + s);
                n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = DoubleBigArrays.med3(x, l, m, n);
        }
        double v = BigArrays.get(x, m);
        long b = a = from2;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Double.compare(BigArrays.get(x, b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Double.compare(BigArrays.get(x, c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap(x, b++, c--);
        }
        long n = to;
        long s = Math.min(a - from2, b - a);
        DoubleBigArrays.swap(x, from2, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        DoubleBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            DoubleBigArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1L) {
            DoubleBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(double[][] x) {
        DoubleBigArrays.quickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(double[][] x, long from2, long to) {
        ForkJoinPool pool = DoubleBigArrays.getPool();
        if (to - from2 < 8192L || pool.getParallelism() == 1) {
            DoubleBigArrays.quickSort(x, from2, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from2, to));
        }
    }

    public static void parallelQuickSort(double[][] x) {
        DoubleBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x));
    }

    public static void parallelQuickSort(double[][] x, long from2, long to, DoubleComparator comp) {
        ForkJoinPool pool = DoubleBigArrays.getPool();
        if (to - from2 < 8192L || pool.getParallelism() == 1) {
            DoubleBigArrays.quickSort(x, from2, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from2, to, comp));
        }
    }

    public static void parallelQuickSort(double[][] x, DoubleComparator comp) {
        DoubleBigArrays.parallelQuickSort(x, 0L, BigArrays.length(x), comp);
    }

    public static long binarySearch(double[][] a, long from2, long to, double key) {
        --to;
        while (from2 <= to) {
            long mid = from2 + to >>> 1;
            double midVal = BigArrays.get(a, mid);
            if (midVal < key) {
                from2 = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(double[][] a, double key) {
        return DoubleBigArrays.binarySearch(a, 0L, BigArrays.length(a), key);
    }

    public static long binarySearch(double[][] a, long from2, long to, double key, DoubleComparator c) {
        --to;
        while (from2 <= to) {
            long mid = from2 + to >>> 1;
            double midVal = BigArrays.get(a, mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from2 + 1L);
    }

    public static long binarySearch(double[][] a, double key, DoubleComparator c) {
        return DoubleBigArrays.binarySearch(a, 0L, BigArrays.length(a), key, c);
    }

    private static final long fixDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l >= 0L ? l : l ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[][] a) {
        DoubleBigArrays.radixSort(a, 0L, BigArrays.length(a));
    }

    public static void radixSort(double[][] a, long from2, long to) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(BigArrays.get(a, first + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 7 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c]) {
                double t = BigArrays.get(a, i4 + first);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    double z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(a, d + first, z);
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first, t);
                count[c] = 0L;
            }
        }
    }

    private static void selectionSort(double[][] a, double[][] b, long from2, long to) {
        for (long i2 = from2; i2 < to - 1L; ++i2) {
            long m = i2;
            for (long j = i2 + 1L; j < to; ++j) {
                if (Double.compare(BigArrays.get(a, j), BigArrays.get(a, m)) >= 0 && (Double.compare(BigArrays.get(a, j), BigArrays.get(a, m)) != 0 || Double.compare(BigArrays.get(b, j), BigArrays.get(b, m)) >= 0)) continue;
                m = j;
            }
            if (m == i2) continue;
            double t = BigArrays.get(a, i2);
            BigArrays.set(a, i2, BigArrays.get(a, m));
            BigArrays.set(a, m, t);
            t = BigArrays.get(b, i2);
            BigArrays.set(b, i2, BigArrays.get(b, m));
            BigArrays.set(b, m, t);
        }
    }

    public static void radixSort(double[][] a, double[][] b) {
        DoubleBigArrays.radixSort(a, b, 0L, BigArrays.length(a));
    }

    public static void radixSort(double[][] a, double[][] b, long from2, long to) {
        int layers = 2;
        if (BigArrays.length(a) != BigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to - from2;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from2);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a, b, first, first + length);
                continue;
            }
            double[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                BigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(BigArrays.get(k, first + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n2 = BigArrays.get(digit, i2) & 0xFF;
                count[n2] = count[n2] + 1L;
            }
            int lastUsed = -1;
            long p = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 15 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c]) {
                double t = BigArrays.get(a, i4 + first);
                double u = BigArrays.get(b, i4 + first);
                c = BigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n3 = c;
                    long l = pos[n3] - 1L;
                    pos[n3] = l;
                    long d = l;
                    if (l <= i4) break;
                    double z = t;
                    int zz = c;
                    t = BigArrays.get(a, d + first);
                    BigArrays.set(a, d + first, z);
                    z = u;
                    u = BigArrays.get(b, d + first);
                    BigArrays.set(b, d + first, z);
                    c = BigArrays.get(digit, d) & 0xFF;
                    BigArrays.set(digit, d, (byte)zz);
                }
                BigArrays.set(a, i4 + first, t);
                BigArrays.set(b, i4 + first, u);
                count[c] = 0L;
            }
        }
    }

    private static void insertionSortIndirect(long[][] perm, double[][] a, double[][] b, long from2, long to) {
        long i2 = from2;
        while (++i2 < to) {
            long t = BigArrays.get(perm, i2);
            long j = i2;
            long u = BigArrays.get(perm, j - 1L);
            while (Double.compare(BigArrays.get(a, t), BigArrays.get(a, u)) < 0 || Double.compare(BigArrays.get(a, t), BigArrays.get(a, u)) == 0 && Double.compare(BigArrays.get(b, t), BigArrays.get(b, u)) < 0) {
                BigArrays.set(perm, j, u);
                if (from2 == j - 1L) {
                    --j;
                    break;
                }
                u = BigArrays.get(perm, --j - 1L);
            }
            BigArrays.set(perm, j, t);
        }
    }

    public static void radixSortIndirect(long[][] perm, double[][] a, double[][] b, boolean stable) {
        DoubleBigArrays.ensureSameLength(a, b);
        DoubleBigArrays.radixSortIndirect(perm, a, b, 0L, BigArrays.length(a), stable);
    }

    public static void radixSortIndirect(long[][] perm, double[][] a, double[][] b, long from2, long to, boolean stable) {
        long[][] support;
        if (to - from2 < 1024L) {
            DoubleBigArrays.insertionSortIndirect(perm, a, b, from2, to);
            return;
        }
        int layers = 2;
        int maxLevel = 15;
        int stackSize = 3826;
        int stackPos = 0;
        long[] offsetStack = new long[3826];
        long[] lengthStack = new long[3826];
        int[] levelStack = new int[3826];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        long[][] lArray = support = stable ? LongBigArrays.newBigArray(BigArrays.length(perm)) : null;
        while (stackPos > 0) {
            long first = offsetStack[--stackPos];
            long length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            double[][] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            long i2 = first + length;
            while (i2-- != first) {
                int n = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, BigArrays.get(perm, i2))) >>> shift & 0xFFL ^ (long)signMask);
                count[n] = count[n] + 1L;
            }
            int lastUsed = -1;
            long p = stable ? 0L : first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                }
                pos[i3] = p += count[i3];
            }
            if (stable) {
                long i4 = first + length;
                while (i4-- != first) {
                    int n = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, BigArrays.get(perm, i4))) >>> shift & 0xFFL ^ (long)signMask);
                    long l = pos[n] - 1L;
                    pos[n] = l;
                    BigArrays.set(support, l, BigArrays.get(perm, i4));
                }
                BigArrays.copy(support, 0L, perm, first, length);
                p = first;
                for (int i5 = 0; i5 < 256; ++i5) {
                    if (level < 15 && count[i5] > 1L) {
                        if (count[i5] < 1024L) {
                            DoubleBigArrays.insertionSortIndirect(perm, a, b, p, p + count[i5]);
                        } else {
                            offsetStack[stackPos] = p;
                            lengthStack[stackPos] = count[i5];
                            levelStack[stackPos++] = level + 1;
                        }
                    }
                    p += count[i5];
                }
                Arrays.fill(count, 0L);
                continue;
            }
            long end = first + length - count[lastUsed];
            int c = -1;
            for (long i6 = first; i6 <= end; i6 += count[c]) {
                long t = BigArrays.get(perm, i6);
                c = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, t)) >>> shift & 0xFFL ^ (long)signMask);
                if (i6 < end) {
                    while (true) {
                        int n = c;
                        long l = pos[n] - 1L;
                        pos[n] = l;
                        long d = l;
                        if (l <= i6) break;
                        long z = t;
                        t = BigArrays.get(perm, d);
                        BigArrays.set(perm, d, z);
                        c = (int)(DoubleBigArrays.fixDouble(BigArrays.get(k, t)) >>> shift & 0xFFL ^ (long)signMask);
                    }
                    BigArrays.set(perm, i6, t);
                }
                if (level < 15 && count[c] > 1L) {
                    if (count[c] < 1024L) {
                        DoubleBigArrays.insertionSortIndirect(perm, a, b, i6, i6 + count[c]);
                    } else {
                        offsetStack[stackPos] = i6;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0L;
            }
        }
    }

    public static double[][] shuffle(double[][] a, long from2, long to, Random random2) {
        return BigArrays.shuffle(a, from2, to, random2);
    }

    public static double[][] shuffle(double[][] a, Random random2) {
        return BigArrays.shuffle(a, random2);
    }

    protected static class ForkJoinQuickSort
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final double[][] x;

        public ForkJoinQuickSort(double[][] x, long from2, long to) {
            this.from = from2;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            long c;
            long a;
            double[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                DoubleBigArrays.quickSort(x, this.from, this.to);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s);
            m = DoubleBigArrays.med3(x, m - s, m, m + s);
            n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n);
            m = DoubleBigArrays.med3(x, l, m, n);
            double v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c && (comparison = Double.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = Double.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                BigArrays.swap(x, b++, c--);
            }
            s = Math.min(a - this.from, b - a);
            DoubleBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            DoubleBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s), new ForkJoinQuickSort(x, this.to - t, this.to));
            } else if (s > 1L) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortComp
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final long from;
        private final long to;
        private final double[][] x;
        private final DoubleComparator comp;

        public ForkJoinQuickSortComp(double[][] x, long from2, long to, DoubleComparator comp) {
            this.from = from2;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            long c;
            long a;
            double[][] x = this.x;
            long len = this.to - this.from;
            if (len < 8192L) {
                DoubleBigArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            long m = this.from + len / 2L;
            long l = this.from;
            long n = this.to - 1L;
            long s = len / 8L;
            l = DoubleBigArrays.med3(x, l, l + s, l + 2L * s, this.comp);
            m = DoubleBigArrays.med3(x, m - s, m, m + s, this.comp);
            n = DoubleBigArrays.med3(x, n - 2L * s, n - s, n, this.comp);
            m = DoubleBigArrays.med3(x, l, m, n, this.comp);
            double v = BigArrays.get(x, m);
            long b = a = this.from;
            long d = c = this.to - 1L;
            while (true) {
                int comparison;
                if (b <= c && (comparison = this.comp.compare(BigArrays.get(x, b), v)) <= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = this.comp.compare(BigArrays.get(x, c), v)) >= 0) {
                    if (comparison == 0) {
                        BigArrays.swap(x, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                BigArrays.swap(x, b++, c--);
            }
            s = Math.min(a - this.from, b - a);
            DoubleBigArrays.swap(x, this.from, b - s, s);
            s = Math.min(d - c, this.to - d - 1L);
            DoubleBigArrays.swap(x, b, this.to - s, s);
            s = b - a;
            long t = d - c;
            if (s > 1L && t > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            } else if (s > 1L) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp(x, this.to - t, this.to, this.comp));
            }
        }
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<double[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[][] o) {
            return Arrays.deepHashCode((Object[])o);
        }

        @Override
        public boolean equals(double[][] a, double[][] b) {
            return DoubleBigArrays.equals(a, b);
        }
    }
}

